/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.sap.cloud.sdk.service.prov.api.security.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationDecorator
extends Authorization {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationDecorator.class);
    private Authorization authorization;

    public AuthorizationDecorator(Authorization authorization) {
        this.authorization = authorization;
    }

    @Override
    public boolean isAuthenticatedUser(String serviceName) {
        boolean isAuthenticated = this.authorization.isAuthenticatedUser(serviceName);
        log.debug("User is authenticated for Service: {} {}", (Object)serviceName, (Object)isAuthenticated);
        return isAuthenticated;
    }

    @Override
    public boolean isRegisteredUser(String serviceName) {
        return this.authorization.isRegisteredUser(serviceName);
    }

    @Override
    public boolean hasEntityAccess(String entityName, String operation) {
        return this.authorization.hasEntityAccess(entityName, operation);
    }

    @Override
    public String getUserName() {
        return this.authorization.getUserName();
    }

    @Override
    public String getUserId() {
        return this.authorization.getUserId();
    }

    @Override
    public boolean hasUserRole(String roleName) {
        return this.authorization.hasUserRole(roleName);
    }

    @Override
    public String getUserAttribute(String attributeName) {
        return this.authorization.getUserAttribute(attributeName);
    }
}

