/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.sap.cloud.sdk.service.prov.api.internal.CSNUtil;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthorizationRulesContainer {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationRulesContainer.class);
    private static Map<String, AuthorizationDetails> authorizationDefinition;
    private static List<String> servicesAndEntitiesWithoutAuthRule;

    private AuthorizationRulesContainer() {
    }

    private static void init() {
        if (authorizationDefinition == null) {
            log.debug("Intializing local storage for authorizationDefinition");
            authorizationDefinition = new HashMap<String, AuthorizationDetails>();
            servicesAndEntitiesWithoutAuthRule = new ArrayList<String>();
        }
    }

    public static boolean isRuleExist(String serviceOrEntityName) {
        AuthorizationRulesContainer.init();
        if (servicesAndEntitiesWithoutAuthRule.contains(serviceOrEntityName)) {
            return false;
        }
        if (authorizationDefinition.containsKey(serviceOrEntityName)) {
            return true;
        }
        AuthorizationDetails authDetails = CSNUtil.getAuthorizationDetails(serviceOrEntityName);
        if (authDetails != null && (null != authDetails.getRequires() || null != authDetails.getRestrict())) {
            authorizationDefinition.put(serviceOrEntityName, authDetails);
            return true;
        }
        servicesAndEntitiesWithoutAuthRule.add(serviceOrEntityName);
        return false;
    }

    public static AuthorizationDetails getRule(String serviceOrEntityName) {
        if (AuthorizationRulesContainer.isRuleExist(serviceOrEntityName)) {
            return authorizationDefinition.get(serviceOrEntityName);
        }
        return null;
    }

    public static Map<String, AuthorizationDetails> getAuthorizationDefinition() {
        return authorizationDefinition;
    }

    public static void setAuthorizationDefinition(Map<String, AuthorizationDetails> authorizationDefinition) {
        AuthorizationRulesContainer.authorizationDefinition = authorizationDefinition;
    }

    public static List<String> getServicesAndEntitiesWithoutAuthRule() {
        return servicesAndEntitiesWithoutAuthRule;
    }

    public static void setServicesAndEntitiesWithoutAuthRule(List<String> servicesAndEntitiesWithoutAuthRule) {
        AuthorizationRulesContainer.servicesAndEntitiesWithoutAuthRule = servicesAndEntitiesWithoutAuthRule;
    }
}

