/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionExecutorUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionExecutorUtil.class);
    private static final int ONE = 1;
    private static final String EQUALS = "=";
    private static final String SUPPORTED_OPERATORS = "[<>=]";
    private static final String SCRIPT_ENGINE = "JavaScript";
    public static final String SPECIAL = "SPECIAL~";
    public static final String EMPTY = "";

    private ExpressionExecutorUtil() {
    }

    public static boolean executeExpression(String expression, JsonObject attributes) throws ScriptException {
        boolean result = false;
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(SCRIPT_ENGINE);
        String updatedExpression = ExpressionExecutorUtil.buildExpression(expression, attributes);
        try {
            result = (Boolean)engine.eval(updatedExpression);
        }
        catch (ScriptException e) {
            logger.error(e.getMessage());
            throw e;
        }
        return result;
    }

    public static String buildExpression(String expression, JsonObject attributes) {
        boolean firstOperandFlag = true;
        boolean specialCase = false;
        StringBuilder updatedExpression = new StringBuilder();
        String[] operands = expression.trim().split(SUPPORTED_OPERATORS);
        String operator = ExpressionExecutorUtil.getOperator(expression);
        if (1 < operands.length) {
            for (String curOperand : operands) {
                curOperand = curOperand.trim();
                if (ExpressionExecutorUtil.isNumeric(curOperand = ExpressionExecutorUtil.replaceUserAttributeWithValue(curOperand, attributes))) {
                    updatedExpression.append(curOperand);
                } else if (!curOperand.isEmpty()) {
                    specialCase = true;
                    updatedExpression.append(curOperand);
                }
                if (!firstOperandFlag) continue;
                firstOperandFlag = false;
                ExpressionExecutorUtil.updateExpression(operator, specialCase, updatedExpression);
            }
        } else if (1 == operands.length) {
            specialCase = true;
            updatedExpression.append(expression);
        }
        if (specialCase) {
            return updatedExpression.insert(0, SPECIAL).toString();
        }
        return updatedExpression.toString();
    }

    private static void updateExpression(String operator, boolean specialCase, StringBuilder updatedExpression) {
        if (EQUALS.equals(operator) && !specialCase) {
            operator = "==";
        }
        updatedExpression.append(operator);
    }

    private static String replaceUserAttributeWithValue(String curOperand, JsonObject attributes) {
        int size;
        String updatedOperand;
        String[] atttibuteKeys;
        String attributeKey;
        JsonElement value;
        if (curOperand.startsWith("$") && null != (value = attributes.get(attributeKey = (atttibuteKeys = (updatedOperand = curOperand.substring(1)).split("\\."))[size = atttibuteKeys.length - 1]))) {
            curOperand = value.isJsonArray() ? value.getAsJsonArray().get(0).getAsString() : value.getAsString();
        }
        return curOperand;
    }

    private static String getOperator(String expression) {
        Pattern p = Pattern.compile(SUPPORTED_OPERATORS);
        Matcher m = p.matcher(expression);
        if (m.find()) {
            return m.group(0);
        }
        return EMPTY;
    }

    private static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    public static enum OPERATION {
        OR,
        AND;

    }
}

