/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.util;

import com.sap.cloud.sdk.service.prov.annotation.repository.AnnotatedClassMethod;
import com.sap.cloud.sdk.service.prov.annotation.repository.AnnotationRepository;
import com.sap.cloud.sdk.service.prov.api.annotations.Action;
import com.sap.cloud.sdk.service.prov.api.annotations.Function;
import com.sap.cloud.sdk.service.prov.api.constants.HttpStatusCodes;
import com.sap.cloud.sdk.service.prov.api.exception.ServiceSDKException;
import com.sap.cloud.sdk.service.prov.api.internal.InstanceProvider;
import com.sap.cloud.sdk.service.prov.api.operations.Create;
import com.sap.cloud.sdk.service.prov.api.operations.Delete;
import com.sap.cloud.sdk.service.prov.api.operations.Query;
import com.sap.cloud.sdk.service.prov.api.operations.Read;
import com.sap.cloud.sdk.service.prov.api.operations.Update;
import com.sap.cloud.sdk.service.prov.api.request.CreateRequest;
import com.sap.cloud.sdk.service.prov.api.request.DeleteRequest;
import com.sap.cloud.sdk.service.prov.api.request.GenericRequest;
import com.sap.cloud.sdk.service.prov.api.request.OperationRequest;
import com.sap.cloud.sdk.service.prov.api.request.QueryRequest;
import com.sap.cloud.sdk.service.prov.api.request.ReadRequest;
import com.sap.cloud.sdk.service.prov.api.request.Request;
import com.sap.cloud.sdk.service.prov.api.request.UpdateRequest;
import com.sap.cloud.sdk.service.prov.api.statistics.SAPStatistics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorHelper {
    public static final String CREATE = "Create";
    public static final String UPDATE = "Update";
    public static final String READ = "Read";
    public static final String DELETE = "Delete";
    public static final String QUERY = "Query";
    public static final String FUNCTION = "Function";
    public static final String ACTION = "Action";
    private static final String METHOD_NAME = " method name: ";
    private static final String SERVICE_NAME = " service name: ";
    private static final String ENTITY_NAME = " entity name: ";
    private static final String ANNOTATED_ENTITY_NAME = "ANNOTATED_ENTITY_NAME";
    private static final String ANNOTATED_SERVICE_NAME = "ANNOTATED_SERVICE_NAME";
    private static final String ANNOTATED_SOURCE_ENTITY_NAME = "ANNOTATED_SOURCE_ENTITY_NAME";
    private static final String NULL_EXCEPTION_MESSAGE = "Operation could not be performed. Check log for more information.";
    private static Logger log = LoggerFactory.getLogger(ProcessorHelper.class);
    private static ProcessorHelper self;
    private static final InstanceProvider instanceProvider;

    static InstanceProvider getInstanceProvider() {
        ServiceLoader<InstanceProvider> instanceProvider = ServiceLoader.load(InstanceProvider.class);
        Iterator<InstanceProvider> iterator = instanceProvider.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return new InstanceProvider(){

            @Override
            public Object getInstance(Class clazz) throws InstantiationException, IllegalAccessException {
                return clazz.newInstance();
            }
        };
    }

    private ProcessorHelper() {
    }

    public static Object invokeOperation(GenericRequest request, String serviceName, String operation, SAPStatistics timings) throws ServiceSDKException {
        AnnotatedClassMethod annotatedClassMethod = null;
        Object retObject = null;
        Locale locale = null;
        try {
            OperationRequest functionRequest;
            locale = request.getLocale();
            if (operation.equals(READ)) {
                ReadRequest readRequest = (ReadRequest)request;
                annotatedClassMethod = ProcessorHelper.getClassMethodtoCall(READ, serviceName, readRequest);
            } else if (operation.equals(QUERY)) {
                QueryRequest queryRequest = (QueryRequest)request;
                annotatedClassMethod = ProcessorHelper.getClassMethodtoCall(QUERY, serviceName, queryRequest);
            } else if (operation.equals(CREATE)) {
                CreateRequest createRequest = (CreateRequest)request;
                annotatedClassMethod = ProcessorHelper.getClassMethodtoCall(CREATE, serviceName, createRequest);
            } else if (operation.equals(UPDATE)) {
                UpdateRequest updateRequest = (UpdateRequest)request;
                annotatedClassMethod = ProcessorHelper.getClassMethodtoCall(UPDATE, serviceName, updateRequest);
            } else if (operation.equals(DELETE)) {
                DeleteRequest deleteRequest = (DeleteRequest)request;
                annotatedClassMethod = ProcessorHelper.getClassMethodtoCall(DELETE, serviceName, deleteRequest);
            } else if (operation.equals(FUNCTION)) {
                functionRequest = (OperationRequest)request;
                annotatedClassMethod = ProcessorHelper.getClassMethodtoCall(FUNCTION, serviceName, functionRequest);
            } else if (operation.equals(ACTION)) {
                functionRequest = (OperationRequest)request;
                annotatedClassMethod = ProcessorHelper.getClassMethodtoCall(ACTION, serviceName, functionRequest);
            }
            if (annotatedClassMethod == null) {
                throw new ServiceSDKException(" Operation not supported", HttpStatusCodes.INTERNAL_SERVER_ERROR.getStatusCode(), locale);
            }
            Class clazz = annotatedClassMethod.getUserClass();
            Method method = annotatedClassMethod.getMethod();
            retObject = ProcessorHelper.invokeMethod(clazz, method, request, operation, timings);
        }
        catch (ServiceSDKException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage() == null ? (e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : NULL_EXCEPTION_MESSAGE) : e.getMessage();
            log.error(message, (Throwable)e);
            throw new ServiceSDKException(message, HttpStatusCodes.INTERNAL_SERVER_ERROR.getStatusCode(), locale == null ? Locale.ENGLISH : locale, e);
        }
        return retObject;
    }

    private static Object invokeMethod(Class clazz, Method method, GenericRequest request, String operation, SAPStatistics timings) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Object retObject = null;
        long customTimeStart = System.currentTimeMillis();
        if (operation.equals(READ)) {
            ReadRequest readRequest = (ReadRequest)request;
            retObject = method.invoke(instanceProvider.getInstance(clazz), readRequest);
        } else if (operation.equals(QUERY)) {
            QueryRequest queryRequest = (QueryRequest)request;
            retObject = method.invoke(instanceProvider.getInstance(clazz), queryRequest);
        } else if (operation.equals(CREATE)) {
            CreateRequest createRequest = (CreateRequest)request;
            retObject = method.invoke(instanceProvider.getInstance(clazz), createRequest);
        } else if (operation.equals(UPDATE)) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            retObject = method.invoke(instanceProvider.getInstance(clazz), updateRequest);
        } else if (operation.equals(DELETE)) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            retObject = method.invoke(instanceProvider.getInstance(clazz), deleteRequest);
        } else if (operation.equals(FUNCTION)) {
            OperationRequest functionRequest = (OperationRequest)request;
            retObject = method.invoke(instanceProvider.getInstance(clazz), functionRequest);
        } else if (operation.equals(ACTION)) {
            OperationRequest actionRequest = (OperationRequest)request;
            retObject = method.invoke(instanceProvider.getInstance(clazz), actionRequest);
        }
        timings.addTimings("ext", System.currentTimeMillis() - customTimeStart);
        return retObject;
    }

    public static String getFilePath(String file) {
        return "/WEB-INF/classes/" + file;
    }

    public static AnnotatedClassMethod getClassMethodtoCall(String annotOperation, String serviceName, GenericRequest oprationRequest) throws ServiceSDKException {
        AnnotatedClassMethod<?> annotOp = null;
        List<AnnotatedClassMethod<?>> list = AnnotationRepository.getInstance().getClassMethodListForAnnotation(annotOperation);
        if (list != null) {
            annotOp = ProcessorHelper.getAnnotatedOperation(list, oprationRequest, annotOperation, serviceName);
        }
        ProcessorHelper.debugLog("Method for " + annotOperation + "annoted Operation getClassMethodtoCall() ended");
        return annotOp;
    }

    private static AnnotatedClassMethod<?> getAnnotatedOperation(List<AnnotatedClassMethod<?>> list, GenericRequest oprationRequest, String annotOperation, String serviceName) throws ServiceSDKException {
        Method method = null;
        AnnotatedClassMethod<?> annotOp = null;
        boolean isPresent = false;
        boolean isVisited = false;
        String functionName = null;
        String entityName = null;
        String sourceEntityName = null;
        if (oprationRequest instanceof OperationRequest) {
            functionName = ((OperationRequest)oprationRequest).getOperationName();
        } else if (oprationRequest instanceof Request) {
            entityName = ((Request)oprationRequest).getEntityName();
            sourceEntityName = ((Request)oprationRequest).getSourceEntityName();
        }
        ProcessorHelper.debugLog("getClassMethodtoCall for annoted operation: " + annotOperation + SERVICE_NAME + serviceName + ENTITY_NAME + entityName);
        String entityNameLocal = entityName;
        if (annotOperation.equals(FUNCTION) || annotOperation.equals(ACTION)) {
            entityNameLocal = functionName;
        }
        for (AnnotatedClassMethod<?> annotatedClassMethod : list) {
            boolean sourceEntityValid;
            boolean annoOperSourceValid;
            method = annotatedClassMethod.getMethod();
            Map<String, String> annotatedParams = ProcessorHelper.getAnnotatedMethodParams(annotOperation, method);
            String annotOperEntityName = annotatedParams.get(ANNOTATED_ENTITY_NAME);
            String annotOperServiceName = annotatedParams.get(ANNOTATED_SERVICE_NAME);
            String annotOperSourceEntityName = annotatedParams.get(ANNOTATED_SOURCE_ENTITY_NAME);
            if (annotOperServiceName != null && annotOperServiceName.equals(serviceName) && annotOperEntityName != null && annotOperEntityName.equals(entityNameLocal) && (isPresent = ProcessorHelper.isAnnotationValid(sourceEntityName, method, annoOperSourceValid = annotOperSourceEntityName == null || "".equals(annotOperSourceEntityName.trim()), sourceEntityValid = sourceEntityName != null && sourceEntityName.equals(annotOperSourceEntityName), isPresent, annotOperation, annotOperServiceName, annotOperSourceEntityName)) && !isVisited) {
                isVisited = true;
                annotOp = annotatedClassMethod;
            }
            if (!isPresent) continue;
            break;
        }
        if (!isPresent) {
            String msg = "No match found for annoted operation: " + annotOperation + SERVICE_NAME + serviceName + ENTITY_NAME + entityNameLocal;
            log.error(msg);
            throw new ServiceSDKException("Method not implemented", HttpStatusCodes.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
        }
        return annotOp;
    }

    private static Map<String, String> getAnnotatedMethodParams(String annotOperation, Method method) {
        HashMap<String, String> annotatedParams = new HashMap<String, String>();
        if (annotOperation.equals(CREATE)) {
            Create createAnno = method.getAnnotation(Create.class);
            annotatedParams.put(ANNOTATED_ENTITY_NAME, createAnno.entity());
            annotatedParams.put(ANNOTATED_SERVICE_NAME, createAnno.serviceName());
            annotatedParams.put(ANNOTATED_SOURCE_ENTITY_NAME, createAnno.sourceEntity());
        } else if (annotOperation.equals(DELETE)) {
            Delete deleteAnno = method.getAnnotation(Delete.class);
            annotatedParams.put(ANNOTATED_ENTITY_NAME, deleteAnno.entity());
            annotatedParams.put(ANNOTATED_SERVICE_NAME, deleteAnno.serviceName());
        } else if (annotOperation.equals(READ)) {
            Read readAnno = method.getAnnotation(Read.class);
            annotatedParams.put(ANNOTATED_ENTITY_NAME, readAnno.entity());
            annotatedParams.put(ANNOTATED_SERVICE_NAME, readAnno.serviceName());
            annotatedParams.put(ANNOTATED_SOURCE_ENTITY_NAME, readAnno.sourceEntity());
        } else if (annotOperation.equals(UPDATE)) {
            Update updateAnno = method.getAnnotation(Update.class);
            annotatedParams.put(ANNOTATED_ENTITY_NAME, updateAnno.entity());
            annotatedParams.put(ANNOTATED_SERVICE_NAME, updateAnno.serviceName());
        } else if (annotOperation.equals(QUERY)) {
            Query queryAnno = method.getAnnotation(Query.class);
            annotatedParams.put(ANNOTATED_ENTITY_NAME, queryAnno.entity());
            annotatedParams.put(ANNOTATED_SERVICE_NAME, queryAnno.serviceName());
            annotatedParams.put(ANNOTATED_SOURCE_ENTITY_NAME, queryAnno.sourceEntity());
        } else if (annotOperation.equals(FUNCTION)) {
            Function functionAnno = method.getAnnotation(Function.class);
            annotatedParams.put(ANNOTATED_ENTITY_NAME, functionAnno.Name());
            annotatedParams.put(ANNOTATED_SERVICE_NAME, functionAnno.serviceName());
        } else if (annotOperation.equals(ACTION)) {
            Action actionAnno = method.getAnnotation(Action.class);
            annotatedParams.put(ANNOTATED_ENTITY_NAME, actionAnno.Name());
            annotatedParams.put(ANNOTATED_SERVICE_NAME, actionAnno.serviceName());
        }
        return annotatedParams;
    }

    private static boolean isAnnotationValid(String sourceEntityName, Method method, boolean annoOperSourceValid, boolean sourceEntityValid, boolean isPresent, String annotOperation, String serviceName, String entityName) throws ServiceSDKException {
        boolean isValid = isPresent;
        if (sourceEntityName == null && annoOperSourceValid || sourceEntityValid) {
            if (!isValid) {
                isValid = true;
                ProcessorHelper.debugLog("Found match for annoted operation: " + annotOperation + SERVICE_NAME + serviceName + ENTITY_NAME + entityName + METHOD_NAME + method.getName());
            } else {
                String msg = "Duplicate entry found for annoted operation: " + annotOperation + SERVICE_NAME + serviceName + ENTITY_NAME + entityName + METHOD_NAME + method.getName();
                log.error(msg);
                throw new ServiceSDKException("Please contact your system administrator", HttpStatusCodes.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ENGLISH);
            }
        }
        return isValid;
    }

    private static void debugLog(String msg) {
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
    }

    static {
        instanceProvider = ProcessorHelper.getInstanceProvider();
        self = new ProcessorHelper();
    }
}

