/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.api;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;

import com.sap.cloud.sdk.service.prov.api.connection.DataSourceParams;
import com.sap.gateway.core.api.provider.data.IDataProviderResponse;

public interface DraftProvider {
	
	public UUID createEntityForDraftAdminData(PostUriInfo uriInfo, ODataContext context, DataSourceParams dsParams) throws ODataApplicationException;
	public IDataProviderResponse createEntityForDraftsTable(PostUriInfo uriInfo, ODataEntry content, 
			ODataContext context, UUID draftAdminUUID, DraftFlow flow, DataSourceParams dsParams) throws ODataApplicationException ;
	public IDataProviderResponse updateEntityForDraftsTable(PutMergePatchUriInfo uriInfo, ODataEntry content,
			String requestContentType, boolean merge, ODataContext context, DataSourceParams dsParams) throws ODataApplicationException;
	public IDataProviderResponse readDataFromDraftsTable(UriInfo uriInfo, ODataContext context, List<String> filters, DataSourceParams dsParams) throws ODataApplicationException;	
	public void deleteEntry(UriInfo uriInfo, ODataContext context, String entityName, Map<String,Object> keyValue, DataSourceParams dsParams) throws ODataApplicationException;
	public List<Map<String, Object>> readAllDraftEntries(UriInfo uriInfo, ODataContext context, List<String> filters, DataSourceParams dsParams) throws ODataApplicationException;
	public List<Map<String, Object>> readCombinedEntries(UriInfo uriInfo, ODataContext context, List<Map<String, Object>> activeDataCollection, DataSourceParams dsParams) throws ODataApplicationException;
	public List<Map<String, Object>> readUnchangedActive(UriInfo uriInfo, ODataContext context, List<Map<String, Object>> activeEntities, DataSourceParams dsParams) throws ODataApplicationException;
	public List<Map<String, Object>> readOwnDrafts(UriInfo uriInfo, ODataContext context, List<Map<String, Object>> activeEntities, DataSourceParams dsParams) throws ODataApplicationException;
	public List<Map<String, Object>> readUnSavedActive(UriInfo uriInfo, ODataContext context, List<Map<String, Object>> activeEntities, DataSourceParams dsParams) throws ODataApplicationException;
	public List<Map<String, Object>> readLockedByOthersEntries(UriInfo uriInfo, ODataContext context, List<Map<String, Object>> activeEntities, DataSourceParams dsParams) throws ODataApplicationException;	
	public IDataProviderResponse countAllDraftEntries(UriInfo uriInfo, ODataContext context, List<String> filters,
			DataSourceParams dsParams) throws ODataApplicationException;
	public int getInlineCount(UriInfo uriInfo, ODataContext context, DataSourceParams dataSourceParams) throws ODataApplicationException;	
}
