/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.api.extensions;

import java.util.Map;

import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;

import com.sap.gateway.core.api.provider.data.IDataProviderResponse;

/**
 * The {@link DataProviderResult} contains the result from a {@link com.sap.gateway.v4.rt.api.DataProvider}
 * method.
 * For accessing the exists several typed methods which return <code>NULL</code> if the type does not fit the method,
 * a common method to get the result as object and a <code>isResultAvailable</code> method for explicit null check.
 */
public interface DataProviderResult {
  boolean isResultAvailable();
  boolean isEntityAvailable();
  Object getResult();
 
  /**
   * Converts data and headers stored in this object to IDataProviderResponse
   * This method internally takes care of single entity or a list of entities. Hence this method can be called
   * for QUERY, READ and CREATE operations.
   * @return IDataProviderResponse containing the data and headers in this object
   */
  IDataProviderResponse getReadEntityResult();
  int getInlineCount();
  IDataProviderResponse getFunctionResponse(GetFunctionImportUriInfo uriInfo);
  void setKeys(Map<String,String> keys);
  Map<String,String> getKeys();
  void setResult(Object result);
  Map<String,Object> getRequestEntity();
  int getCount();
}
