/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.api.extensions;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;

import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;


public class ExtensionException extends Exception {
	private static final long serialVersionUID = 1L;
private Throwable rootCause;

  public ExtensionException(Exception e) {
    rootCause = getRootCause(e);
  }

  public ExtensionException(ODataApplicationException e) {
    rootCause = e;
  }

  public ExtensionException(String msg, int statusCode, Locale locale) {
    this(new ODataApplicationException(msg, locale, HttpStatusCodes.fromStatusCode(statusCode)));
  }

  @Override
  public Throwable getCause() {
    return rootCause;
  }

  /**
   * Get wrapped {@link ODataApplicationException} or <code>NULL</code> if it is
   * not an {@link ODataApplicationException}.
   *
   * @return {@link ODataApplicationException} or <code>NULL</code>
   */
  public ODataApplicationException getODataApplicationException() {
    if(rootCause instanceof ODataApplicationException) {
      return (ODataApplicationException) rootCause;
    }
    return null;
  }

  /**
   * Get wrapped {@link ODataApplicationException} or a new created
   * {@link ODataApplicationException}.
   *
   * @return an {@link ODataApplicationException}
   */
  public ODataApplicationException convert() {
    if(rootCause instanceof ODataApplicationException) {
      return (ODataApplicationException) rootCause;
    }
    return new ODataApplicationException(rootCause.getMessage(), Locale.ENGLISH, HttpStatusCodes.INTERNAL_SERVER_ERROR);
  }

  private Throwable getRootCause(Throwable e) {
    if(e instanceof InvocationTargetException) {
      final Throwable targetException = ((InvocationTargetException)e).getTargetException();
      if (targetException instanceof InvocationTargetException) {
        return getTargetException((InvocationTargetException) targetException);
      }
      return targetException;
    }
    return e;
  }

  private Throwable getTargetException(InvocationTargetException e) {
    final Throwable targetException = e.getTargetException();
    if(targetException instanceof InvocationTargetException) {
      return getTargetException((InvocationTargetException) targetException);
    }
    return targetException;
  }

}
