/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.api.extensions;

import java.util.List;


public interface ExtensionRegistry {
  void registerExtensions(List<Class<?>> clazzes);

  void registerExtension(Class<?> clazz);

  boolean isDataProviderExtensionRegistered(RequestType requestType, String entitySetName);

  ExtensionHolder getDataProviderExtension(RequestType requestType, String entitySetName);
  
  boolean dataProviderExtensionsRegistered();
  
  List<ExtensionHolder> getMetadataExtension();
  
  boolean isFunctionExtensionRegistered(String operationName);
  
  ExtensionHolder getFunctionExtension(String operationName);
  
  boolean isActionExtensionRegistered(String operationName);
  
  ExtensionHolder getActionExtension(String operationName);
  
  boolean isBeforeOperationExtensionRegistered(String operationName);
  
  ExtensionHolder getBeforeOperationExtension(String operationName);
  
  boolean isAfterOperationExtensionRegistered(String operationName);
  
  ExtensionHolder getAfterOperationExtension(String operationName);
  
  ExtensionHolder getInitTransactionExit();
  
  ExtensionHolder getEndTransactionExit();

  boolean isInitTransactionExitRegistered();
  
  boolean isEndTransactionExitRegistered();

  boolean isBeforeOperationExitRegistered(String operationName, String entitySetName);
  
  boolean isAfterOperationExitRegistered(String operationName, String entitySetName);

  ExtensionHolder getBeforeOperationExit(String entitySetName, String operationName);
  
  ExtensionHolder getAfterOperationExit(String entitySetName, String operationName);

  boolean isCleanupTransactionExitRegistered();

  ExtensionHolder getCleanupTransactionExit();
  
  public boolean isBeforeAllRegistered();
  
  public ExtensionHolder getBeforeAllExtns();

  boolean isBeforeOperationDraftExitRegistered(String operationName, String entitySetName);
  
  boolean isAfterOperationDraftExitRegistered(String operationName, String entitySetName);

  ExtensionHolder getBeforeOperationDraftExit(String entitySetName, String operationName);
  
  ExtensionHolder getAfterOperationDraftExit(String entitySetName, String operationName);
  
}
