/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.api.internal;

/**
 * 
 *
 *Interal Interface for providing api calls to manage transaction.
 */
public interface TransactionParams {
	
	/**
	 * Should implement logic for termination 
	 * of connection between the framework
	 * and the remote datasource by 
	 * toggling the isBatchFlow switch
	 * <p>
	 * Should be used only in context of 
	 * controlling transaction in case of 
	 * a Batch process
	 */
	public void closeDataSourceForBatch();
	
	
	
	
	/**
	 * 
	 * Should implement logic to toggle  
	 * autocommit feature of remote datasource  
	 * if applicable
	 * <p>
	 * Should be used only in context of 
	 * controlling transaction in case of 
	 * a Batch process
	 * 
	 * @param autoCommit
	 */
	public void setAutoCommitForDataSourceForBatch(boolean autoCommit);
	
	
	
	/**
	 * Should implement logic for commiting 
	 * completed work to the remote datasource
	 * <p>
	 * Should be used only in context of 
	 * controlling transaction in case of 
	 * a Batch process
	 */
	public void commitDataSourceForBatch();
	
	
	
	/**
	 * Should implement logic for rollback
	 * of work executed on the datasource
	 * <p>
	 * Should be used only in context of 
	 * controlling transaction in case of 
	 * a Batch process
	 */
	public void rollBackDataSourceForBatch();
	
	
	/**
	 * This is used to set the isBatchFlow switch
	 * @param isBatchFlow
	 * 
	 */
	public void setIsBatchFlow(boolean isBatchFlow);
	
	
	/**
	 * 
	 * This is used check the isBatchFlow switch
	 * @return
	 */
	public boolean isBatchFlow();
	
	/**
	 * 
	 * This is used check the batch request switch
	 * @return
	 */
	public boolean isBatchRequest();
	
	/**
	 * 
	 * This is used to set the batch request switch
	 * @return
	 */
	public void setIsBatchRequest(boolean isBatchRequest);
	
}
