/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.data.provider;

import java.sql.Connection;
import java.sql.SQLClientInfoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Map.Entry;

import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.core.edm.EdmGuid;
import org.apache.olingo.odata2.core.edm.provider.EdmComplexTypeImplProv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.sdk.service.prov.api.ExtensionHelper;
import com.sap.cloud.sdk.service.prov.api.Message;
import com.sap.cloud.sdk.service.prov.api.connection.DataSourceParams;
import com.sap.cloud.sdk.service.prov.api.internal.CSNUtil;
import com.sap.cloud.sdk.service.prov.api.request.MessageContainerImpl;
import com.sap.cloud.sdk.service.prov.api.statistics.SAPStatistics;
import com.sap.cloud.sdk.service.prov.api.usercontext.UserContextParams;
import com.sap.cloud.sdk.service.prov.v2.rt.api.internal.TransactionParams;
import com.sap.cloud.sdk.service.prov.v2.rt.etag.processor.ETagProcessor;
import com.sap.gateway.core.api.batch.ICountEntitySetParameter;
import com.sap.gateway.core.api.batch.ICreateEntityParameter;
import com.sap.gateway.core.api.batch.IDeleteEntityParameter;
import com.sap.gateway.core.api.batch.IExecuteFunctionImportParameter;
import com.sap.gateway.core.api.batch.IParameter;
import com.sap.gateway.core.api.batch.IReadEntityMediaParameter;
import com.sap.gateway.core.api.batch.IReadEntityParameter;
import com.sap.gateway.core.api.batch.IReadEntitySetParameter;
import com.sap.gateway.core.api.batch.IReadExpandedEntityParameter;
import com.sap.gateway.core.api.batch.IReadExpandedEntitySetParameter;
import com.sap.gateway.core.api.batch.IRequest;
import com.sap.gateway.core.api.batch.IUpdateEntityParameter;
import com.sap.gateway.core.api.message.MessageContainer;
import com.sap.gateway.core.api.provider.data.BaseDataProvider;
import com.sap.gateway.core.api.provider.data.BaseDataProviderResponse;
import com.sap.gateway.core.api.provider.data.IDataProviderResponse;
import com.sap.gateway.core.api.sap.statistics.SapStatisticsConstants;
import com.sap.gateway.core.api.srvrepo.IServiceInfo;

 

public class DataProvider extends BaseDataProvider {
	
	final static Logger logger = LoggerFactory.getLogger(DataProvider.class);
	
	public static final  String  APPLICATIONUSER="APPLICATIONUSER";
	public static final  String  XS_APPLICATIONUSER="XS_APPLICATIONUSER";
	private Map<String, List<String> >complexPropWithUUID  = new HashMap(); 
	DataSourceParams connectionProvider = null;
	private UserContextParams userContextParam= null;
	Long pageSize = (long) 1000;
	private Object filterExpression = null;
	private List<String> selectOptions=new ArrayList<String>();
	private boolean isDraftFlow;
	private boolean isBatchRequest;
	
	//Read the @cds.query.limit annotation for the service, if its present then return the value
	//else return the default value 1000 for the page size
	public Long getPageSize(GetEntitySetUriInfo uriInfo) {
		Long cdsQueryLimit = null;
		try {
			cdsQueryLimit = CSNUtil.getQueryLimit(uriInfo.getTargetType().getNamespace());
		} catch (EdmException exception) {
			logger.error(exception.getMessage(), exception);
		}
		if(cdsQueryLimit != null) {
			return cdsQueryLimit;
		}else {
			return this.pageSize;
		}
	}

	public DataProvider(IServiceInfo service) {
		super(service);
	}
	
	public void setDataSource(DataSourceParams connection){
		this.connectionProvider = connection;
	}
	
	public DataSourceParams getDataSource() {
		return connectionProvider;
	}

	public ExtensionHelper getExtensionHelper(ODataRequest request, String namespace) {
		// TODO Auto-generated method stub
		return null;
	}

	public void startTransaction() throws ODataApplicationException {
	}
	
	public void commitTransaction() throws ODataApplicationException {
	}
	
	public void rollbackTransaction() throws ODataApplicationException {
	}
	
	public void cleanupTransaction() {
	}
	
	public void setIsBatchFlow(boolean isBatchFlow) {
		
	}
	
	public boolean isBatchRequest() {
		return isBatchRequest;
	}

	public void setBatchRequest(boolean isBatchRequest) {
		this.isBatchRequest = isBatchRequest;
	}
	
	public TransactionParams getTSParams() {
		return null;
	}
	
	public DataSourceParams getDSParams() {
		return null;
	}
	
	/**
	 * Checks whether a function can be executed based on ETag.
	 * @param uriInfo Contains information specific to the function from the request 
	 * @param context Contains general information from the request
	 * @throws ODataException If the HTTP header is missing or if the condition specified by it is not met
	 */
	public void executeEtagCheckForFunctionImport(GetFunctionImportUriInfo uriInfo, ODataContext context) throws ODataException {
	//Override the method in corresponding data provider
	}
	
	public Boolean compareEtagValues(ODataContext context,String etagPropValue){
		Boolean etagCheck=false;
		ETagProcessor eTagProcessor=new ETagProcessor(context);
		etagCheck=eTagProcessor.evaluateETag(etagPropValue);
		return etagCheck;
	}
	
	public void populateResponseHeaderEtag(BaseDataProviderResponse response,String eTagPropReadValue,String eTagPropName,ODataEntry content){
		if(response.getHeaders()!=null){
			response.getHeaders().put("ETag", determineResponseEtagHeader(eTagPropReadValue, eTagPropName, content));
		}else{
			response.setHeaders(new HashMap<String,String>());
			response.getHeaders().put("ETag", determineResponseEtagHeader(eTagPropReadValue, eTagPropName, content));
		}
		
	}
	
	private String determineResponseEtagHeader(String eTagPropReadValue,String eTagPropName,ODataEntry content){
		if(content!=null&&content.getProperties().get(eTagPropName)!=null){
			return createETagHeaderValue(content.getProperties().get(eTagPropName).toString());
		}else{
			return createETagHeaderValue(eTagPropReadValue);
		}
		
	}
	
	public String createETagHeaderValue(String propValue) {
		//Only weak ETag value will be returned in response
		String eTag = "W/\"\"";
		if(propValue != null){
			eTag = "W/\""+propValue+"\""; 
		}
		return eTag;
	}
	
	public void castStringToGuid(List<String> coloumnNames, List<Map<String, Object>> resultEntitySet){
		for(int i=0;  i<resultEntitySet.size(); i++ ){
			Object mapObj = resultEntitySet.get(i);
			if(mapObj instanceof Map){
				this.castStringToGuid(coloumnNames, resultEntitySet.get(i));
			}
		}
	}
	
	public void castStringToGuid(List<String> coloumnNames, Map<String, Object> resultEntitySet){
		for(String columnName : coloumnNames){
			Object data = resultEntitySet.get(columnName) ;
			if(data instanceof String ){
				resultEntitySet.put(columnName, UUID.fromString((String) data));
			} 
		}
	}
	
	public void castNavigationStringToGuid(Map<String, List<String>> allNavigatedUUIDColumns, List<Map<String, Object>> resultEntitySet){
		for(int i=0; i<resultEntitySet.size(); i++){
			castNavigationStringToGuid(allNavigatedUUIDColumns, resultEntitySet.get(i));
		}
	}

	private void castNavigationStringToGuid(Map<String, List<String>> allNavigatedUUIDColumns, Map<String, Object> properties){
		for (Map.Entry<String, Object> entry : properties.entrySet()) {
			if(entry.getValue() instanceof List) {
				List<String> coloumnNames = allNavigatedUUIDColumns.get(entry.getKey());
				List entityCollection = (List)entry.getValue();
				for(int i=0; i<entityCollection.size(); i++){
					if(entityCollection.get(i) instanceof Map){
						//Convert String to UUID
						castNavigationStringToGuid(coloumnNames, (Map)entityCollection.get(i));				
						//Recursive for navigations
						castNavigationStringToGuid(allNavigatedUUIDColumns, (Map)entityCollection.get(i));
					}
				}
			}else if(entry.getValue() instanceof Map) {
				List<String> coloumnNames = allNavigatedUUIDColumns.get(entry.getKey());
				//Convert String to UUID
				castNavigationStringToGuid(coloumnNames, (Map)entry.getValue());				
				//Recursive for navigations
				castNavigationStringToGuid(allNavigatedUUIDColumns, (Map)entry.getValue());
			}
		}
	}

	private void castNavigationStringToGuid(List<String> coloumnNames, Map<String, Object> resultEntitySet){
		if(coloumnNames == null || resultEntitySet.isEmpty()){
			return;
		}
		for(String columnName : coloumnNames){
			Object data = resultEntitySet.get(columnName) ;
			if(data instanceof String ){
				resultEntitySet.put(columnName, UUID.fromString((String) data));
			} 
		}
	}
	
	public  void castStringToGuidWithCompelxProperty(List<String> coloumnNames, List<Map<String, Object>> resultEntitySet , EdmStructuralType entityType){
		for(int i=0;  i<resultEntitySet.size(); i++ ){
		for(String columnName : coloumnNames){
			Object data = resultEntitySet.get(i).get(columnName) ;
			if(data instanceof String ){
				resultEntitySet.get(i).put(columnName, UUID.fromString((String) data));
			}else if(data instanceof Map ){
				try {
			    //Handle Complex type	
				String complexTypeName = entityType.getProperty(columnName).getType().getName();
				Map<String, Object> complexData = (Map<String, Object>)data;
				 castStringToGuidWithCompelxProperty( complexPropWithUUID.get(complexTypeName) , Arrays.asList(complexData) ,  (EdmStructuralType) entityType.getProperty(columnName).getType()  );
				 
				} catch (EdmException e) {
					 
				}
			}
		  }
		}	 
	}
	
	
	public Object checkEtagValidations(BaseDataProviderResponse response,UriInfo uriInfo,ODataContext context) throws ODataApplicationException{
		return null;
	}

	
	public void populateUpdatedEntityinResponse(UriInfo uriInfo,ODataContext context,BaseDataProviderResponse response,ODataEntry content)throws ODataException {
		return;
	}
	
	public boolean checkEtagStatusPass(UriInfo uriInfo,ODataContext context,BaseDataProviderResponse response )throws ODataException {
		return false;
	}

	public void populateEtagInHeaderFromResponse(UriInfo uriInfo, BaseDataProviderResponse response) throws ODataException{
		//Based on Response Populate back E-tag value in Header in Case of Batch.
		//Parsing UriInfo is implementation Specific
	}

	public UserContextParams getUserContextParam() {
		return userContextParam;
	}

	public void setUserContextParam(UserContextParams userContextParam) {
		this.userContextParam = userContextParam;
	}
	
	public void setUserContextInfo(Connection conn) {
		if(userContextParam!=null) {
			try {
				String uname=userContextParam.getUserName();
				if (conn != null && uname!=null) {
					conn.setClientInfo(APPLICATIONUSER,uname);
					conn.setClientInfo(XS_APPLICATIONUSER,uname);
				}
			}catch(SQLClientInfoException exception) {
				logger.error(exception.getMessage(), exception);
			}
		}
	}
	
public List<String> getUUIDColumns(UriInfo uriInfo) throws EdmException{
		
		List<String> coloumnNames = new ArrayList<>();
		List<String> propertNames = null;
		EdmStructuralType entityType = null;
		if(uriInfo.getTargetEntitySet()!= null){
			entityType = uriInfo.getTargetEntitySet().getEntityType() ;
			propertNames = entityType.getPropertyNames();
		}else if(uriInfo.getTargetType() instanceof EdmStructuralType){
			entityType = (EdmStructuralType)uriInfo.getTargetType() ;
			propertNames = entityType.getPropertyNames(); 
		}
	 
		if(entityType == null){
			return coloumnNames;
		}
		for (String propertyName : propertNames) {
			
			EdmTyped property = entityType.getProperty(propertyName) ;
			
			if (property.getType() instanceof EdmGuid) {
				coloumnNames.add(propertyName);
			}
			else if(property.getType().getKind().equals(EdmTypeKind.COMPLEX) ){
				boolean isUUIDinComplextype = getUUIDColumnsInComplexType(entityType, property);
				if(isUUIDinComplextype)coloumnNames.add(propertyName);
			}
		}
		return coloumnNames;
	}
 
 
/*
 * Get UUID properties for all navigation entities
 */
public Map<String, List<String>> getAllNavigationUUIDColumns(UriInfo uriInfo) throws EdmException{
	Map<String, List<String>> navigationsUUIDs = new HashMap<>();
	if(uriInfo.getEntityContainer() == null){
		return navigationsUUIDs;
	}
	List<EdmEntitySet> entitySets = uriInfo.getEntityContainer().getEntitySets();
	for(int i=0; i<entitySets.size(); i++){
		EdmEntitySet entitySet = entitySets.get(i);
		EdmEntityType entityType = entitySet.getEntityType();
		List<String> navigationProperties =  entityType.getNavigationPropertyNames();
		for(int j=0; j<navigationProperties.size(); j++){
			EdmNavigationProperty navigationProperty = (EdmNavigationProperty) entityType.getProperty(navigationProperties.get(j));
			EdmEntitySet navigatedEntitySet = entitySet.getRelatedEntitySet(navigationProperty);
			navigationsUUIDs.put(navigationProperty.getName(), this.getNavigationUUIDColumns(navigatedEntitySet));
		}
	}
	
	return navigationsUUIDs;
}

/*
 * Get UUID properties for specific navigation entity
 */
private List<String> getNavigationUUIDColumns(EdmEntitySet navigatedEntitySet) throws EdmException{
	List<String> coloumnNames = new ArrayList<>();
	List<String> propertNames = null;
	EdmStructuralType entityType = null;
	if(navigatedEntitySet != null){
		entityType = navigatedEntitySet.getEntityType();
		propertNames = entityType.getPropertyNames();
	}
	if(entityType != null){
		for (String propertyName : propertNames) {
			
			EdmTyped property = entityType.getProperty(propertyName) ;
			
			if (property.getType() instanceof EdmGuid) {
				coloumnNames.add(propertyName);
			}
			else if(property.getType().getKind().equals(EdmTypeKind.COMPLEX) ){
				boolean isUUIDinComplextype = getUUIDColumnsInComplexType(entityType, property);
				if(isUUIDinComplextype)coloumnNames.add(propertyName);
			}
		}
	}
	return coloumnNames;
}

public boolean getUUIDColumnsInComplexType(EdmStructuralType inputEntityType, EdmTyped property  ) throws EdmException{
	 
	EdmComplexTypeImplProv complexTypeProv =  (EdmComplexTypeImplProv)property.getType(); 
	//Already Scanned
	if(complexPropWithUUID.get(complexTypeProv.getName()) != null) return true;

	List<String> propertNames = complexTypeProv.getPropertyNames() ;
	List<String> coloumnNames = new ArrayList<>(); 
	EdmStructuralType entityType = null;
	if(inputEntityType != null){ 
		//find the complex type
		entityType = (EdmStructuralType)inputEntityType.getProperty(property.getName()).getType() ;
	}
	else{
		entityType = (EdmStructuralType) property.getType() ;
	}
	
	
	
	for (String propertyName : propertNames) {
		EdmTyped edmproperty = entityType.getProperty(propertyName) ;
		
		if (edmproperty.getType() instanceof EdmGuid) {
			coloumnNames.add(propertyName);
		}
		else if(edmproperty.getType().getKind().equals(EdmTypeKind.COMPLEX) ){
			getUUIDColumnsInComplexType(inputEntityType, property);
		}		
	}
	
	
	 if(!coloumnNames.isEmpty()) {
		 complexPropWithUUID.put(complexTypeProv.getName() , coloumnNames);
		 return true;
	 }
	 
	 //Complextype contains no UUID field
	 return false;
}	

	
	
    public void generateAndSetUUIDtoPayLoad(UriInfo uriInfo,ODataEntry content) throws EdmException {
    	List<String> coloumnNames =getUUIDColumns(uriInfo);
		//fix for 1870006971. UUID should be generated if only it is a key property
		List<String> keypropertNames = uriInfo.getTargetEntitySet().getEntityType().getKeyPropertyNames();
		for (String coloumnName : coloumnNames) {
			// id would not be generated if it is already provided by the user
			if (content.getProperties().get(coloumnName) == null) {
				if(keypropertNames.contains(coloumnName)) {
					content.getProperties().put(coloumnName, UUID.randomUUID().toString());
				}
			}
			else {
				content.getProperties().put(coloumnName, content.getProperties().get(coloumnName).toString());
			}
		}
    }
    
    public void convertUUIDtoStringinPayload(UriInfo uriInfo,ODataEntry content) throws EdmException {
    	List<String> coloumnNames = getUUIDColumns(uriInfo);
		for (String coloumnName : coloumnNames) {
			if(content.getProperties().get(coloumnName) != null) {
				content.getProperties().put(coloumnName, content.getProperties().get(coloumnName).toString());
			}
		}
    }
    
	public Object getFilterExpression() {
		return filterExpression;
	}

	public void setFilterExpression(Object filterExpression) {
		this.filterExpression = filterExpression;
	}
	
	public Boolean isDraftFlow() {
		return false;
	}

	public void setIsDraftFlow(boolean draftFlow) {
		this.isDraftFlow = draftFlow;
	}
	
	public Map<String, Object> readDataFromMainTable(UriInfo uriInfo, ODataContext context, List<String> filters) throws ODataApplicationException {
		return new HashMap<>();
	}
	
	public List<Map<String, Object>> readDataCollectionFromMainTable(UriInfo uriInfo, ODataContext context, List<String> filters) throws ODataApplicationException {
		return new ArrayList<>();
	}
	
	public List<Map<String, Object>> readDataCollectionFromMainTableForCombinedEntries(UriInfo uriInfo, ODataContext context, List<String> filters, boolean pagination) throws ODataApplicationException {
		return new ArrayList<>();
	}
	
	public List<String> getSelectOptions() {
		return selectOptions;
	}

	public void setSelectOptions(List<String> selectOptions) {
		this.selectOptions = selectOptions;
	}	
	
	//$count for draft table
	public IDataProviderResponse countDataCollectionFromMainTable(UriInfo uriInfo, ODataContext context,
			List<String> filters) throws ODataApplicationException {
		return null;
	}
	
	public int getInlineCount(UriInfo uriInfo, ODataContext context,boolean maintable) throws ODataApplicationException{
		return 0;
	}
	
	public IDataProviderResponse deleteEntity(DeleteUriInfo uriInfo, ODataContext context, boolean cascadeDelete) throws ODataException {
		return deleteEntity(uriInfo, context);
	}

	public IDataProviderResponse readEntity(GetEntityUriInfo uriInfo, ODataContext context, boolean cascadeDelete)
			throws ODataException {
		return readEntity(uriInfo, context);
	}
	
	public IDataProviderResponse readEntityFromBatch(GetEntityUriInfo uriInfo, ODataContext context) throws ODataException {
		return readEntity(uriInfo, context);
	}
	
	public IDataProviderResponse readEntitySetFromBatch(GetEntitySetUriInfo uriInfo, ODataContext context) throws ODataException {
		return readEntitySet(uriInfo, context);
	}
	
	public IDataProviderResponse executeSingleOperationForBatch(IRequest request, ODataContext globalContext) throws ODataException {

		IParameter parameter = request.getParameter();
		ODataContext context = parameter.getContext();
		for (String header : globalContext.getRequestHeaders().keySet()) {
			if (context.getRequestHeader(header) == null)
				context.getRequestHeaders().put(header, globalContext.getRequestHeaders().get((header)));
		}

		String contentType = parameter.getContentType();

		try {
			switch (request.getMethod()) {
			case COUNT_ENTITY_SET:
				ICountEntitySetParameter countEntitySetParameter = (ICountEntitySetParameter) parameter;
				return countEntitySet(countEntitySetParameter.getUriInfo(), context);
			case CREATE_ENTITY:
				ICreateEntityParameter createEntityParameter = (ICreateEntityParameter) parameter;
				return createEntity(createEntityParameter.getUriInfo(), createEntityParameter.getEntry(), contentType,
						createEntityParameter.getProviderPropertiesBuilder(), context);
			case DELETE_ENTITY:
				IDeleteEntityParameter deleteEntityParameter = (IDeleteEntityParameter) parameter;
				return deleteEntity(deleteEntityParameter.getUriInfo(), context);
			case EXECUTE_FUNCTION_IMPORT:
				IExecuteFunctionImportParameter executeFunctionImportParameter = (IExecuteFunctionImportParameter) parameter;
				return executeFunctionImport(executeFunctionImportParameter.getUriInfo(), context);
			case READ_ENTITY:
				IReadEntityParameter readEntityParameter = (IReadEntityParameter) parameter;
				return readEntityFromBatch(readEntityParameter.getUriInfo(), context);
			case READ_ENTITY_MEDIA:
				IReadEntityMediaParameter readEntityMediaParameter = (IReadEntityMediaParameter) parameter;
				return readEntityMedia(readEntityMediaParameter.getUriInfo(), context);
			case READ_ENTITY_SET:
				IReadEntitySetParameter readEntitySetParameter = (IReadEntitySetParameter) parameter;
				return readEntitySetFromBatch(readEntitySetParameter.getUriInfo(), context);
			case READ_EXPANDED_ENTITY:
				IReadExpandedEntityParameter readExpandedEntityParameter = (IReadExpandedEntityParameter) parameter;
				return readExpandedEntity(readExpandedEntityParameter.getUriInfo(), context);
			case READ_EXPANDED_ENTITY_SET:
				IReadExpandedEntitySetParameter readExpandedEntitySetParameter = (IReadExpandedEntitySetParameter) parameter;
				return readExpandedEntitySet(readExpandedEntitySetParameter.getUriInfo(), context);
			case UPDATE_ENTITY:
				IUpdateEntityParameter updateEntityParameter = (IUpdateEntityParameter) parameter;
				return updateEntity(updateEntityParameter.getUriInfo(), updateEntityParameter.getContent(),
						updateEntityParameter.getRequestContentType(), updateEntityParameter.getMerge(), context);

			default:
				throw new ODataNotImplementedException();
			}
		} catch (ODataException e) {
			throw e;
		}		
	}
	
	public void setStatisticsInContext(ODataContext context, IDataProviderResponse response, SAPStatistics timings) {
		if (context.getParameter(SapStatisticsConstants.SHOWSTATSFORBATCH) != null && response != null) {
			Map<String, String> statsMap = new HashMap<>();
			statsMap.put(SapStatisticsConstants.SAPSTATS,
					timings.getTimings((Long) context.getParameter(SapStatisticsConstants.REQSTARTTIME)));
			((BaseDataProviderResponse) response).setHeaders(statsMap);
		} else {
			@SuppressWarnings("unchecked")
			Map<String, Object> sapStats = (Map<String, Object>) context
					.getParameter(SapStatisticsConstants.SAPSTATS);
			if (sapStats != null) {
				for (Entry<String, Object> entry : sapStats.entrySet()) {
					timings.addTimings(entry.getKey(), (long) entry.getValue());
				}
			}
			context.setParameter(SapStatisticsConstants.SAPSTATS, timings.getTimingsMap());
		}

	}
	
	public MessageContainer getIGWMessageContainerFromMessageContainer(MessageContainerImpl msgCon) {
		if (msgCon == null)
			return null;
		Message leadingMsg = msgCon.getLeadingMessage();
		if (leadingMsg == null)
			return null;
		List<Message> details = msgCon.getMessageDetails();
		MessageContainer igwMsgCon = new MessageContainer();
		igwMsgCon.addMessage(getIGWMessageFromMessage(leadingMsg));
		for (Message msg : details) { // NOSONAR
			igwMsgCon.addMessage(getIGWMessageFromMessage(msg));
		}
		return igwMsgCon;

	}
	
	public static com.sap.gateway.core.api.message.Message getIGWMessageFromMessage(Message msg) {
		// TODO Auto-generated method stub
		com.sap.gateway.core.api.message.Message igwMsg = new com.sap.gateway.core.api.message.Message();
		igwMsg.setMessageCode(msg.getCode());
		igwMsg.setMessageText(msg.getMessage());
		igwMsg.setReference(msg.getTarget());
		igwMsg.setSeverity(msg.getSeverity().name().toLowerCase());

		return igwMsg;
	}
}
