/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.repository.delegate;

import com.sap.cloud.sdk.service.prov.v2.rt.repository.ServiceRepositoryProvider;
import com.sap.gateway.core.api.delegate.ICoreService;
import com.sap.gateway.core.api.delegate.IServiceDelegate;
import com.sap.gateway.core.api.delegate.ServiceType;
import com.sap.gateway.core.api.exception.TechnicalException;

public class ServiceDelegate implements IServiceDelegate{
	
	private static final IServiceDelegate instance = new ServiceDelegate();

	@SuppressWarnings("unchecked")
	public static <T extends ICoreService> T getService(ServiceType serviceType) throws TechnicalException{
		return (T)getInstance().getService(serviceType, null);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T extends ICoreService> T getService(ServiceType type, String serviceAdditionalInfo)
			throws TechnicalException {
		switch(type){
		case SERVICE_REPOSITORY:
			return (T)new ServiceRepositoryProvider();
		default:
			return null;
		}
		
	}
	
	
	public static IServiceDelegate getInstance(){
		return instance;
	}

	private ServiceDelegate() {
		super();
	}

}
