package com.sap.cloud.sdk.service.prov.v2.rt.util;

import java.util.Locale;

import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;



public class EDMHelper {
	
	private EDMHelper(){
	}

	public static EdmEntitySet getEdmEntitySet(final UriInfo uriInfo, Locale locale) throws ODataException {
	    EdmEntitySet entitySet = null;

	    // First must be an entity or a function import.
	    if (uriInfo.getStartEntitySet() != null) {
	    	entitySet = uriInfo.getStartEntitySet();
	    } else if (uriInfo.getFunctionImport() != null) {
			entitySet = uriInfo.getFunctionImport().getEntitySet();
	    } else {
	    	throw new ODataApplicationException("INVALID_RESOURCE_TYPE", locale, HttpStatusCodes.NOT_IMPLEMENTED, "INVALID_RESOURCE_TYPE_CODE");
	    }
	    
	    int navigationCount = 0;
	    while (entitySet != null && navigationCount < uriInfo.getNavigationSegments().size()) {
			  final NavigationSegment uriResourceNavigation = uriInfo.getNavigationSegments().get(navigationCount);
			  try {
				if(entitySet.getRelatedEntitySet(uriResourceNavigation.getNavigationProperty()) == null) {
					  entitySet.getEntityContainer().getEntitySet(uriResourceNavigation.getNavigationProperty().getType().getName());
					  break;
				  }else {
					  entitySet = entitySet.getRelatedEntitySet(uriResourceNavigation.getNavigationProperty());
				  }
			  } catch (EdmException e) {
		    	  throw new ODataApplicationException("NAVIGATION_NOT_SUPPORTED", locale, HttpStatusCodes.NOT_IMPLEMENTED, "NAVIGATION_NOT_SUPPORTED_CODE", e);
			  }
			  navigationCount++;
	    }	    
	    return entitySet;
	}
}
