/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.util;

import java.util.Locale;

import org.apache.olingo.odata2.api.processor.ODataContext;

import com.sap.cloud.sdk.service.prov.api.security.AuthorizationService;

public class HeaderUtil {
	private HeaderUtil(){
	}
	
	public static Locale getlocale(ODataContext context){
		Locale locale = null;
		if(context!=null && context.getRequestHeader("Accept-Language") != null){
			locale = Locale.forLanguageTag(context.getRequestHeader("Accept-Language"));
		}
		if(locale==null){
			locale=Locale.ENGLISH;
		}
		return locale;
	}
	
	public static String getUserName(ODataContext context){
		String user= null;
		user= AuthorizationService.getUserName();
		if(context != null && context.getRequestHeader("username") != null){
			user = context.getRequestHeader("username");
		}
		return user;
	}

}
