/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.util;

import java.util.Locale;

import org.apache.olingo.odata2.api.processor.ODataContext;

public class LocaleUtil {
	
	final private static ThreadLocal<Locale> localeContainer = new ThreadLocal<>();
	
	/**
	 * Gets locale information associated with the current request.
	 * 
	 * @return A <code>Locale</code> object representing a specific geographical, political, or cultural region
	 */
	public static Locale getLocaleforException() {
		Locale locale = localeContainer.get();
		if(locale != null) {
			return locale;
		}
		return Locale.ENGLISH;
	}
	
	/**
	 * Sets locale information in the current request.
	 * 
	 * @param context An <code>ODataContext</code> object containing the locale information
	 */
	public static void setLocaleForRequest(ODataContext context) {
		if(context.getAcceptableLanguages()!= null && !context.getAcceptableLanguages().isEmpty()) {
			Locale locale = context.getAcceptableLanguages().get(0);
			localeContainer.set(locale);
		}
	}
}
