/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.cds;

import java.sql.Connection;
import java.sql.SQLException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.sdk.service.prov.api.connection.DataSourceParams;
import com.sap.cloud.sdk.service.prov.api.connection.JDBCDataSourceParams;
import com.sap.cloud.sdk.service.prov.api.connection.ThreadSafeObjectStore;
import com.sap.cloud.sdk.service.prov.rt.cds.wrapper.CDSConnectionWrapper;
import com.sap.cloud.sdk.service.prov.v2.rt.api.internal.TransactionParams;

public class CDSDataSourceParam implements JDBCDataSourceParams,TransactionParams {
	
	final static Logger logger=LoggerFactory.getLogger(CDSDataSourceParam.class);
	
	
	private Connection conn;
	
	private CDSConnectionWrapper connection;
	private boolean isBatchFlow;
	private boolean isBatchRequest; 

	public CDSDataSourceParam(DataSourceParams dataSourceParams) {
		this.conn = ((JDBCDataSourceParams)dataSourceParams).getConnection();
	}
	
	
	public CDSDataSourceParam(Connection  conn) {
		this.conn=conn;
	}
	

	@Override
	public final void closeDataSourceForBatch() {
		try {
			if(connection!=null){
				connection.setBatchFlow(false);
				if(!connection.isClosed()){
					connection.close();
				}
				connection.setBatchFlow(true);
			}
		} catch (SQLException e) {
			logger.error("Error occured in closing connection",e);
		}
	}

	@Override
	public final void setAutoCommitForDataSourceForBatch(boolean autoCommit) {
		try {
			if(connection!=null){
				connection.setBatchFlow(false);
				connection.setAutoCommit(autoCommit);
				connection.setBatchFlow(true);
			}
		} catch (SQLException e) {
			logger.error("Error occured in setting auto commit",e);
		}
	}

	@Override
	public final void commitDataSourceForBatch() {
		try {
			if(connection!=null){
				connection.setBatchFlow(false);
				connection.commit();
				connection.setBatchFlow(true);
			}
		} catch (SQLException e) {
			logger.error("Error occured in commiting data source",e);
		}
	}

	@Override
	public final void rollBackDataSourceForBatch() {
		try {
			if(connection!=null){
				connection.setBatchFlow(false);
				connection.rollback();
				connection.setBatchFlow(true);
			}
		} catch (SQLException e) {
			logger.error("Error occured in rolling back",e);
		}
	}

	@Override
	public final Connection getConnection() {
		try {
			if(connection!=null && !connection.isClosed()){
				logger.debug("-------------------------INITIALIZED CONNECTION OBTAINED------------------");
				return connection;
			}else{
				 
				logger.debug("-------------------------CONNECTION INITIALIZED------------------");
				if(conn!=null && !conn.isClosed()){
					connection=new CDSConnectionWrapper(conn, isBatchFlow);
				}else {
					connection = new CDSConnectionWrapper(ThreadSafeObjectStore.getConnection(), isBatchFlow);
				}
				return connection;
			}
		} catch (SQLException e) {
			logger.error("Connection object is null",e);
		}
		return null;
	}

	@Override
	public final void setIsBatchFlow(boolean isBatchFlow) {
		this.isBatchFlow=isBatchFlow;
		
	}

	@Override
	public final boolean isBatchFlow() {
		return isBatchFlow;		
	}

	@Override
	public String getSchema() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public boolean isBatchRequest() {
		return isBatchRequest;
	}

	@Override
	public void setIsBatchRequest(boolean isBatchRequest) {
		this.isBatchRequest = isBatchRequest;
	}
	
}
