/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.cds;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

import com.sap.cloud.sdk.service.prov.api.TypeMapping;

/*
 * This class holds the static information of what a CSN type & EDMX type should map to a java type.
 * It has API to fetch the corresponding Java type for an EDMX type or CSN Type or both CSN & EDMX type.
 * More information can be found in wiki: https://wiki.wdf.sap.corp/wiki/display/Gateway/Mapping+of+CDS+types+to+JAVA+types
 */
public class CDSHANATypeMapping {
	
	TypeMapping typeMapping = new TypeMapping();
	private static CDSHANATypeMapping _instance;
	
	public CDSHANATypeMapping(){
		typeMapping.registerTypeMap("Date", "Edm.DateTime", Date.class);
		typeMapping.registerTypeMap("DateTime", "Edm.DateTimeOffset", Timestamp.class);
		typeMapping.registerTypeMap("Timestamp", "Edm.DateTimeOffset", Timestamp.class);
		typeMapping.registerTypeMap("Time", "Edm.Time", Time.class);
	}
	
	@SuppressWarnings("rawtypes")
	public static Class getMappedType(String CSNType, String EdmType){
		if(_instance==null)
			_instance = new CDSHANATypeMapping();
		
		return _instance.typeMapping.getMappedType(CSNType, EdmType);
	}

}
