package com.sap.cloud.sdk.service.prov.v2.rt.cds;

import static com.sap.cloud.sdk.service.prov.api.internal.SQLMapping.quoteIfRequired;
import static com.sap.cloud.sdk.service.prov.rt.cds.AuthorizationFilter.addAuthorizationFilter;
import static com.sap.cloud.sdk.service.prov.v2.rt.cds.util.QueryHelperUtility.getEntityTypeMap;
import static com.sap.cloud.sdk.service.prov.v2.rt.cds.util.QueryHelperUtility.getParameterizedParamater;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Stack;
import java.util.stream.Collectors;

import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.edm.EdmAnnotationAttribute;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.NavigationPropertySegment;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.SelectItem;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.core.edm.provider.EdmEntityTypeImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmNavigationPropertyImplProv;
import org.apache.olingo.odata2.core.uri.KeyPredicateImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cloud.sdk.hana.sql.DateUtils;
import com.sap.cloud.sdk.service.prov.api.filter.BinaryExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.LiteralNode;
import com.sap.cloud.sdk.service.prov.api.filter.PropertyNode;
import com.sap.cloud.sdk.service.prov.api.filter.impl.FilterNodeInternal;
import com.sap.cloud.sdk.service.prov.api.internal.CSNUtil;
import com.sap.cloud.sdk.service.prov.api.internal.SQLMapping;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationService;
import com.sap.cloud.sdk.service.prov.api.security.UnauthorizedException;
import com.sap.cloud.sdk.service.prov.rt.cds.CDSQueryGenerator;
import com.sap.cloud.sdk.service.prov.rt.cds.domain.Column;
import com.sap.cloud.sdk.service.prov.rt.cds.domain.ColumnType;
import com.sap.cloud.sdk.service.prov.rt.cds.domain.Filter;
import com.sap.cloud.sdk.service.prov.rt.cds.domain.OrderBy;
import com.sap.cloud.sdk.service.prov.rt.cds.domain.Parameter;
import com.sap.cloud.sdk.service.prov.rt.cds.domain.QueryHelper;
import com.sap.cloud.sdk.service.prov.rt.cds.domain.ReadEntityInfo;
import com.sap.cloud.sdk.service.prov.rt.hana.sql.HanaExpressionVisitor;
import com.sap.cloud.sdk.service.prov.v2.rt.cds.exceptions.CDSRuntimeException;
import com.sap.cloud.sdk.service.prov.v2.rt.cds.exceptions.CDSRuntimeException.MessageKeys;
import com.sap.cloud.sdk.service.prov.v2.rt.cds.util.QueryHelperUtility;
import com.sap.cloud.sdk.service.prov.v2.rt.util.DraftUtilsV2;
import com.sap.cloud.sdk.service.prov.v2.rt.util.LocaleUtil;

public class HanaQueryHelperV2 implements QueryHelper {

	final static Logger logger = LoggerFactory.getLogger(HanaQueryHelperV2.class);
	private static final String READ = "READ";
	private static final String ACCESS_DENIED = "You do not have authorization to perform this operation.";
	private static String ALIASHLP = "ZZ";
	private static String sapNamespace = "http://www.sap.com/Protocols/SAPData";
	private static final String DRAFT_ROOT = "isDraftRoot";
	private String schema;
	private ReadEntityInfo eInfo;
	private Long topValue;
	private Long skipValue;
	private String targetWhereClause = "";
	private List<String> globalSelect = new ArrayList<>();
	private List<String> selectExtension = new ArrayList<String>();
	private List<Map<String, String>> orderByPropsFromCSON = new ArrayList<Map<String, String>>();
	private HashMap<String,ReadEntityInfo> orderByFromNavigation = new HashMap<>();
	private String globalOrderByStringFromURI = null;
	private JsonNode csn;
	private String serviceName = "";
	private String mediaColumn = null;
	private Object andFilters = null;
	private UriInfo globalUriInfo;
	private boolean isAggregateEntity = false;
	private boolean isSqlAggregated = false;
	private List<String> measuresPropertiesList = new ArrayList<>();
	private String finalCustomExpressionString = null;
	private Filter customFilter = new Filter();
	private String finalStr = null;
	private String finalOperator = "and";
	private String customFilterOperator = "and";
	private boolean isDraftRoot = false;
  private boolean isDraft = false;

	private EdmEntitySet globaltargetEntitySet;
	private static String PARAMETER_ENTITY_SUFFIX = "Parameters";
	private static String PARAMETER_NAVIGATION_PROPERTY = "Set";
	/*
	 * Constructor To Obtain QueryHelper For Obtaining the Created Entity
	 */
	public HanaQueryHelperV2(UriInfo uriInfo, ODataContext context, ODataEntry content, JsonNode csn)
			throws ODataException {

		this.serviceName = uriInfo.getTargetEntitySet().getEntityType().getNamespace();
		this.csn = csn;
		this.selectExtension = (List<String>) context.getParameter("selectOption");
		getQueryHelperEntityUriInfo(uriInfo, context, content);

	}

	/*
	 * ReadEntitySet Constructor and ReadEntity Constructor and Media Resource
	 * Constructor
	 */
	public HanaQueryHelperV2(UriInfo uriInfo, ODataContext context, JsonNode csn, String mediaColumn)
			throws ODataException {
		this.serviceName = uriInfo.getTargetEntitySet().getEntityType().getNamespace();
		this.csn = csn;
		this.mediaColumn = mediaColumn;
		this.selectExtension = (List<String>) context.getParameter("selectOption");
		processUriInfo((UriInfo) uriInfo, context);
	}

	/*
	 * ReadEntitySet Constructor and ReadEntity Constructor and Media Resource
	 * Constructor
	 */
	public HanaQueryHelperV2(UriInfo uriInfo, ODataContext context, JsonNode csn) throws ODataException {
		this.serviceName = uriInfo.getTargetEntitySet().getEntityType().getNamespace();
		this.csn = csn;
		this.selectExtension = (List<String>) context.getParameter("selectOption");
		processUriInfo((UriInfo) uriInfo, context);
	}

	/*
	 * Constructor For $count and Inline Count Extra parameter count helps us
	 * redirect to count Flow
	 *
	 */
	public HanaQueryHelperV2(UriInfo uriInfo, ODataContext context, JsonNode csn, boolean count,boolean mainTable) throws ODataException {
		this.serviceName = uriInfo.getTargetEntitySet().getEntityType().getNamespace();
		this.csn = csn;
		this.isDraftRoot = mainTable;
		processUriInfo((UriInfo) uriInfo, context);

		/*
		 * Correction To EntityInfo For Count
		 */
		// Traverse to last entity set and change columns to be fetched
		ReadEntityInfo lastnavEinfo = eInfo;
		while (lastnavEinfo.getEntityNavigated() != null) {
			// Remove Orderby
			lastnavEinfo.getOrderby().clear();
			lastnavEinfo.getOrderBySeq().clear();
			lastnavEinfo = lastnavEinfo.getEntityNavigated();
		}
		// Remove Orderby last time
		lastnavEinfo.getOrderby().clear();
		lastnavEinfo.getOrderBySeq().clear();

		// Do not remove group by if annotated with sap semantics aggregate
		if (!this.isAggregateEntity) {
			//if(uriInfo.isCount()) {
			lastnavEinfo.getColumns().clear();
			//}
		}

		// Remove any Expand Entries
		lastnavEinfo.getEntitiesExpanded().clear();

		// Remove Top Skip
		this.topValue = null;
		this.skipValue = null;
		// check if count or inlinecount on entity annotated as aggregated
		if (this.isAggregateEntity) {
			this.isSqlAggregated = true;
			/*if (uriInfo.isCount()) {
				lastnavEinfo.setCountStar(true);
			} else {
				this.isSqlAggregated = true;
			}*/
		} else {
			// Only one keyPropName is required even in case of composite keys .// Count is
			// an aggregation against parent entity set logic should hold
			String keypropName = uriInfo.getTargetEntitySet().getEntityType().getKeyPropertyNames().get(0);
			Column c = new Column("COUNT(" + quoteIfRequired(keypropName) + ") ");
			c.setDbaliasName("C").setType(ColumnType.Primitive);
			lastnavEinfo.getColumns().add(c);
		}

	}

	public HanaQueryHelperV2(UriInfo uriInfo, ODataContext context, boolean isDraftRoot, boolean isDraft, JsonNode csn)
      throws ODataException {
    this.serviceName = uriInfo.getTargetEntitySet().getEntityType().getNamespace();
    this.csn = csn;
    this.isDraftRoot = isDraftRoot;
    this.isDraft = isDraft;
    this.selectExtension = (List<String>) context.getParameter("selectOption");
    processUriInfo((UriInfo) uriInfo, context);
  }
	
	private void getQueryHelperEntityUriInfo(UriInfo uriInfo, ODataContext context, ODataEntry content)
			throws ODataException {
		EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
		this.schema = entitySet.getEntityType().getNamespace();
		List<KeyPredicate> keypredicates = new ArrayList<KeyPredicate>();
		List<EdmProperty> kepProps = entitySet.getEntityType().getKeyProperties();
		if (uriInfo.getTargetKeyPredicates() != null && !uriInfo.getTargetKeyPredicates().isEmpty()) {
			keypredicates = uriInfo.getTargetKeyPredicates();
		} else {
			for (EdmProperty key : kepProps) {
				KeyPredicate kp = null;
				if ((EdmSimpleType) key.getType() == EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance()) {
					kp = new KeyPredicateImpl(
							DateUtils.convertCalendartoLiteral((Timestamp) content.getProperties().get(key.getName())),
							key);
				} else {
					kp = new KeyPredicateImpl(HANADMLHelperV2
							.processEtagValue(uriInfo, key.getName(), content.getProperties().get(key.getName()))
							.toString(), key);
				}
				keypredicates.add(kp);
			}
		}
		this.globalUriInfo = uriInfo;
		this.selectExtension = (List<String>) context.getParameter("selectOption");
		this.eInfo = prepareEntityInfo(entitySet, "", null, keypredicates);
	}

	private void processUriInfo(UriInfo uriInfo, ODataContext context) throws ODataException {
		EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
		this.schema = entitySet.getEntityType().getNamespace();
		this.globalUriInfo = uriInfo;
		this.andFilters = context.getParameter("andFilters");
		if (this.andFilters != null)
			this.findRootCustomNode(andFilters);
		Object draftRoot = context.getParameter(DRAFT_ROOT);
        if (draftRoot != null) {
            this.isDraftRoot = Boolean.valueOf((String) draftRoot);
            context.setParameter(DRAFT_ROOT, null);
        }
		// Start Counstruction of ReadEntityInfo from the First urlpart (Normal
		// Scenario)
		if(isParameterEntity(uriInfo.getStartEntitySet())) {// Aggregation and Parameter Special Case
			prepareEntityInfoForParameterViews(uriInfo, false);
		}else {
			this.eInfo = prepareEntityInfo(uriInfo.getStartEntitySet(), "", uriInfo.getNavigationSegments());
		}
		// adding the media column to qhv2 EntityInfo
		if (mediaColumn != null) {
			Column media = formNewColumnObject(this.mediaColumn, this.eInfo.getEntityName());
			// Column media = new Column(mediaColumn);
			media.setAliasName(mediaColumn);
			media.setPathName(mediaColumn);
			media.setColumnDataType("Edm.Binary");
			media.setPathName(mediaColumn);
			media.setType(ColumnType.Primitive);
			this.eInfo.getColumns().add(media);
		}
		if (uriInfo.isCount() && this.isDraft && uriInfo.getSelect().isEmpty()) {
      this.eInfo.setCountStar(true);
  }
	}

	private void findRootCustomNode(Object andFilters) {
		finalOperator = ((FilterNodeInternal) andFilters).getOperator();
		finalOperator = getOperandValue(finalOperator);

		Queue<FilterNodeInternal> queue1 = new LinkedList<FilterNodeInternal>();
		queue1.add((FilterNodeInternal) andFilters);

		// ExpressionNode customRootNode = process(queue1);

		boolean allCustomNode = true;
		List<FilterNodeInternal> childrenNode = ((FilterNodeInternal) andFilters).getChildren();

		for (FilterNodeInternal child : childrenNode) {
			if (!child.isCustomNode()) {
				allCustomNode = false;
				break;
			}
		}

		if (allCustomNode) {
			customFilterOperator = finalOperator;
			finalCustomExpressionString = computeCustomExpressionString((FilterNodeInternal) andFilters);
		} else {
			Optional<FilterNodeInternal> customRootNode = ((FilterNodeInternal) andFilters).getChildren().stream()
					.filter(node -> node.isCustomNode()).findAny();
			if (customRootNode.isPresent()) {
				customFilterOperator = customRootNode.get().getOperator();
				customFilterOperator = getOperandValue(customFilterOperator);
				finalCustomExpressionString = computeCustomExpressionString(customRootNode.get());
			}
		}

		customFilter.setExpression(finalCustomExpressionString);

	}

	private String getOperandValue(String finalOperator2) {
		String operator;
		switch (finalOperator2) {
			// Arithmetic operation
			case "AND":
				operator = " and ";
				break;
			case "OR":
				operator = " or ";
				break;
			default:
				operator = " and ";
		}
		return operator;
	}

	private String computeCustomExpressionString(ExpressionNode expressionNode) {
		StringBuilder str = new StringBuilder();
		Queue<String> q = new LinkedList<String>();
		Queue<ExpressionNode> qNode = new LinkedList<ExpressionNode>();
		// Stack<ExpressionNode> st = new Stack();

		List<FilterNodeInternal> children = ((FilterNodeInternal) expressionNode).getChildren();

		children.forEach(exprNode -> qNode.add(exprNode));

		if (expressionNode instanceof BinaryExpressionNode) {
			ExpressionNode node1 = qNode.remove();
			ExpressionNode node2 = qNode.remove();

			if (!(node1 instanceof BinaryExpressionNode || node2 instanceof BinaryExpressionNode)) {
				String value = getValueFromNode(node2,null);
				if (value!= null){
					str.append("( ");
					str.append(value);
					String op = ((BinaryExpressionNode) expressionNode).getOperator();
					String literalVal = getLiteralValue(node1);
					if(op.equals("EQ") && literalVal.equals("null")) {
						str.append(" is null )");
					}else if(op.equals("NE") && literalVal.equals("null")) {
						str.append(" is not null )");
					}else {
						str.append(QueryHelperUtility.getBinaryOperandValue((BinaryExpressionNode) expressionNode));
						str.append("?");
						str.append(" )");
						getValueFromNode(node1,value.substring(value.lastIndexOf(".")+1));
					}
					q.add(str.toString());
				}
			} else {
				computeCustomExpressionString(node1);
				computeCustomExpressionString(node2);
			}
		}
		while (!q.isEmpty()) {
			if (null != finalStr) {
				finalStr = "( " + finalStr + customFilterOperator + q.remove() + " )";
				//	finalStr = "( " + finalStr + " )"+ customFilterOperator +"( "+ q.remove() + " )";
			} else {
				finalStr = q.remove();
			}
		}
		return finalStr;

	}


	private String getValueFromNode(ExpressionNode node,String value) {
		String right = null;
		if (node instanceof PropertyNode) {
			String str = ((PropertyNode) node).getPath();
			return (String) visitCustomProperty(str);
		}

		if (node instanceof LiteralNode) {
			right = ((LiteralNode) node).getValue().toString();
			if (right.contains("datetime'")) {
				customFilter.setParameter(new Parameter(DateUtils.dateLiteralresolver("datetime\'" + right + "\'").replaceAll("^\'|\'$", "") , "Edm.Date" , right));
			}
			else if (right.contains("datetimeoffset'")) {

				customFilter.setParameter(new Parameter(DateUtils.dateLiteralresolver("datetimeoffset\'" + right + "\'").replaceAll("^\'|\'$", "") , "Edm.Date" ,right));
			}
			customFilter.setParameter(new Parameter(right, "Edm.String", value));
		}
		return right;
	}

	private String getLiteralValue(ExpressionNode node) {
		String literalValue = "";
		if (node instanceof LiteralNode) {
			literalValue = ((LiteralNode) node).getValue().toString();
		}
		return literalValue;
	}
	public Object visitCustomProperty(String uriLiteral){

		// parseToWhereExpression difference 1 in SQLFilterExpressionVisitor
		// this.tableAlias + "." + fieldName; difference 2 in SQLFilterExpressionVisitor
		String persistenceName = uriLiteral;
		//Todo: Handle exception
		if (globaltargetEntitySet != null) {
			try {
				String namespace = globaltargetEntitySet.getEntityType().getNamespace();
				String fqName = namespace + "." + globaltargetEntitySet.getName();
				persistenceName = CDSQueryGenerator.getPersistenceName(fqName, uriLiteral);
			} catch (EdmException e) {
				logger.error("Error while processing filter", e);
			}
		}
		String pathPrefixedName = "ROOT_ENTITY_SELECT_ALIAS" + "." + "PATH_FROM_ROOT."
				+ quoteIfRequired(persistenceName);
		return pathPrefixedName;
	}

	private ReadEntityInfo prepareEntityInfo(EdmEntitySet entitySet, String parentAssociation,
											 List<NavigationSegment> navigationSegments, Object... modifiers) throws ODataException {
		ReadEntityInfo re = new ReadEntityInfo();
		re.setServiceName(serviceName);
		String entityName;
		String fqName;
		// boolean marks this entity for processing All filters,OrderBy,Expands
		// Originate from this segment
		boolean targetArtifact = false;// Default Assume this is a navigation Segment
		boolean startArtifact = false;

		// Prepare Global Select
		prepareGlobalSelectList();
		//Prepare Global OrderBy List
		globalOrderByStringFromURI = QueryHelperUtility.prepareGlobalOrderBy(globalUriInfo);
		this.orderByPropsFromCSON=CSNUtil.getOrderByProperties(serviceName, entitySet.getName());

		if (parentAssociation.isEmpty()) {
			startArtifact = true;
		}

		if (globalSelect != null && !globalSelect.isEmpty()) {
			re.setSelectOption(globalSelect);
		}

		// If it is the starting artifact :: then entity Name should be entity Set Name
		// otherwise entityName should be navigation Property Name
		entityName = startArtifact ? entitySet.getName() : navigationSegments.get(0).getNavigationProperty().getName();
		// Added as part of HANA SQL Implementation
		fqName = startArtifact ? entitySet.getName()
				: navigationSegments.get(0).getNavigationProperty().getType().getName();

		if ((navigationSegments == null || navigationSegments.isEmpty()) // This means the call is on startEntitySet
				// Itself. // No navigation
				|| (!startArtifact && navigationSegments != null && navigationSegments.size() == 1)) {// This means we
			// have
			// recursively
			// arrived at
			// the last
			// Navigation
			// segment for
			// processing
			targetArtifact = true;
		}
		// Initial Code default Settings
	// Suffix with draft table name
    if (this.isDraft && startArtifact) {
        re.setEntityName(entityName + DraftUtilsV2.DRAFTS_TABLE_NAME_SUFFIX);
    } else {
        re.setEntityName(entityName);
    }
		re.setParententityName(parentAssociation);
		// Added as part of HANA SQL Implementation
		re.setFqName(fqName);

		// Determine If the CurrentEntitySet is the Target Entity Set (Last Set in the
		// Entity)

		if (targetArtifact) { // Logically all the magic happens on this artifact
			re.setFetchColumns(true);
			// set the columns

			EdmEntityType type = entitySet.getEntityType();
			EdmAnnotationAttribute annotationAttribute = type.getAnnotations().getAnnotationAttribute("semantics",
					sapNamespace);

			if (annotationAttribute != null && annotationAttribute.getText().equals("aggregate")) {
				this.isAggregateEntity = true;
				modifyEntityInfoForAggregation(re, globalUriInfo.getSelect(), type, type.getName(),
						globalUriInfo.getFilter());
			} else {
				re.getColumns().addAll(resolvePropertiesToColumns(re.getEntityName(), entitySet.getEntityType(),
						parentAssociation != null ? parentAssociation : null, ""));
			}
			// set key predicates as necessary
			if (!startArtifact) {

				// Add Predicates
				re.getFilters()
						.addAll(navigationSegments.get(0).getKeyPredicates() != null
								? getKeyPredicates(navigationSegments.get(0).getKeyPredicates())
								: null);
				// handle custom query options like 'search'
				if(SQLMapping.isPlainSqlMapping())
					handleSearchQueryOption(globalUriInfo.getCustomQueryOptions(), re, entitySet.getName(), true);
				else
					handleSearchQueryOptionForQuoted(globalUriInfo.getCustomQueryOptions(), re, entitySet.getName(), true);
			} else {
				// Check if Modifiers have additional Predicates in Case of getting Created and
				// Updated entity Flow
				if (modifiers.length > 0 && modifiers[0] != null && modifiers[0] instanceof List<?>) {
					re.getFilters().addAll(getKeyPredicates((List<KeyPredicate>) modifiers[0]));
				} // Add Predicates For Read Flow
				else {
					re.getFilters()
							.addAll(globalUriInfo.getKeyPredicates() != null
									? getKeyPredicates(globalUriInfo.getKeyPredicates())
									: null);
					
					  re.setKeyPredicates(globalUriInfo.getKeyPredicates() != null
	                            ? QueryHelperUtility.getKeyPredicatesMap(globalUriInfo.getKeyPredicates(), this.isDraftRoot)
	                            : null);
				}
				// handle custom query options like 'search'
				if(SQLMapping.isPlainSqlMapping())
					handleSearchQueryOption(globalUriInfo.getCustomQueryOptions(), re, entitySet.getName(), true);
				else
					handleSearchQueryOptionForQuoted(globalUriInfo.getCustomQueryOptions(), re, entitySet.getName(), true);
			}

			// Handle Filters for last segment
			if (globalUriInfo.getFilter() != null) {
				Filter customFilter = prepeareParameterizedFilter((globalUriInfo));	
				if(customFilter.getExpression()!= null && !"".equals(customFilter.getExpression().trim()))	
				 re.getFilters().add(customFilter);
				
				// setting filter expression for Statble id
                re.setFilterExpForStableId(globalUriInfo.getFilter().getExpressionString());
			}
			else
			{
				Filter customFilter = prepeareParameterizedFilter();
				if(customFilter != null)
					re.getFilters().add(customFilter);
			}

		/*	// Handle Filters for last segment
			if (globalUriInfo.getFilter() != null) {
				String filterExp = null;
				filterExp = prepeareParameterizedFilter((globalUriInfo));
				if (filterExp != null && !"".equals(filterExp.trim())) {
					if (finalCustomExpressionString != null && !"".equals(finalCustomExpressionString.trim()))
						filterExp = "(" + filterExp + "and( " + finalCustomExpressionString + " ))";
					re.getFilters().add(new Filter(filterExp));
				}
			} else if (finalCustomExpressionString != null && !"".equals(finalCustomExpressionString.trim())) {
				String filterExp = "( " + finalCustomExpressionString + " )";
				re.getFilters().add(new Filter(filterExp));
			}*/

			// Add authorization filter
			initAuth(entitySet, re);
			// Add OrderBy for navigation prop
			if (globalUriInfo.getOrderBy() != null)
				checkOrderBy(globalUriInfo.getOrderBy(), re,entitySet);

			// Add OrderBy
			if (globalUriInfo.getOrderBy() != null)
				setOrderByInReadEntityInfo(globalUriInfo.getOrderBy(), re);

			// Add OrderBy if it is set in the CSON
			QueryHelperUtility.addOrderBypropertiesFromCSON(orderByPropsFromCSON,re, entitySet.getEntityType());

			// Add OrderBy for Key predicates after actual OrderBy (Cross Check they are not
			// over-riding actual order by in UriInfo)
			if (!isAggregateEntity)
				addOrderByForKeyPredicates(re, entitySet.getEntityType());

			// Recursive Call for Expand

			if (globalUriInfo.getExpand() != null && !globalUriInfo.getExpand().isEmpty()) {
				re.getEntitiesExpanded().addAll(
						prepExpandInfoList(globalUriInfo.getExpand(), parentAssociation + ALIASHLP + entityName));
			}

		} else { // This is a part of the navigation Segment , Do not Fetch Columns, Do not Set
			// Columns , Take into account key predicate filter and parent OrderBy
			re.setFetchColumns(false);
			if (!startArtifact) {
				re.setFilters(getKeyPredicates(navigationSegments.get(0).getKeyPredicates()));
			} else {
				re.setFilters(getKeyPredicates(globalUriInfo.getKeyPredicates()));
			}

			// Add Authorization filter
			try {
				addAuthorizationFilterNavigatedSegment(entitySet, re);
			} catch (UnauthorizedException e) {
				throw new ODataApplicationException(e.getMessage(), LocaleUtil.getLocaleforException(),
						HttpStatusCodes.FORBIDDEN);
			}

			if (navigationSegments != null) {
				List<NavigationSegment> subNavigationSegments = startArtifact ? navigationSegments
						: navigationSegments.subList(1, navigationSegments.size());
				if (subNavigationSegments != null && !subNavigationSegments.isEmpty()) {
					re.setEntityNavigated(prepareEntityInfo(subNavigationSegments.get(0).getEntitySet(),
							parentAssociation + ALIASHLP + entityName, subNavigationSegments));
				}
			}
		}
		if(globalUriInfo.getKeyPredicates()!=null && globalUriInfo.getKeyPredicates().size()>0) {
			re.setIsReadRequest(true);
		}

		return re;
	}

	private void initAuth(EdmEntitySet entitySet, ReadEntityInfo re) throws ODataException {

		if (!targetWhereClause.equals("")) {
			addAuthorizationFilter(re, getEntityTypeMap(entitySet), targetWhereClause,true);
		} else if (globalUriInfo.getNavigationSegments().isEmpty()) {
			addAuthorizationFilter(re, getEntityTypeMap(entitySet), AuthorizationService.getWhereCondition(),true);
		}

	}

	private String initAuthNavigationSegment(EdmEntitySet entitySet) throws ODataException {
		String entityFQN = entitySet.getEntityType().toString();
		if (AuthorizationService.getWhereCondition() != null && !AuthorizationService.getWhereCondition().equals("")
				&& targetWhereClause.equals(""))
			targetWhereClause = AuthorizationService.getWhereCondition();
		AuthorizationService.hasEntityAccess(entityFQN, READ);
		return entityFQN;
	}

	private void addAuthorizationFilterNavigatedSegment(EdmEntitySet entitySet, ReadEntityInfo re)
			throws ODataException, UnauthorizedException {
		String entityFQN = initAuthNavigationSegment(entitySet);
		if (!AuthorizationService.hasEntityAccess(entityFQN, READ)) {
			logger.error("User does not have access to navigate via this segment");
			throw new UnauthorizedException(ACCESS_DENIED);
		} else if (checkForSourceWhere(entitySet, AuthorizationService.getWhereCondition())) {

			addAuthorizationFilter(re, getEntityTypeMap(entitySet), AuthorizationService.getWhereCondition(),true);

		}
	}

	private boolean checkForSourceWhere(EdmEntitySet entitySet, String whereClause) throws ODataException {
		if (whereClause != null && whereClause.contains("=")) {
			String propName = whereClause.split("=")[0];
			List<String> propertyNames = entitySet.getEntityType().getPropertyNames();
			for (int i = 0; i < propertyNames.size(); i++) {
				if (propertyNames.get(i).equals(propName)) {
					return true;
				}
			}
		}
		return false;
	}

	private List<ReadEntityInfo> prepExpandInfoList(List<ArrayList<NavigationPropertySegment>> expandsList,
													String parentAssociation) throws EdmException {
		List<ReadEntityInfo> eInfoList = new ArrayList<ReadEntityInfo>();
		// Prepare a List of readEntitinfo for Multiple Expands on Same Level eg.
		// Person?$expand=apps,notes
		for (ArrayList<NavigationPropertySegment> expands : expandsList) {
			ReadEntityInfo eInfo = prepareExpand(expands, parentAssociation, "", eInfoList);
			if(eInfo!=null)
			eInfoList.add(eInfo);
		}
		return eInfoList;
	}

	private ReadEntityInfo prepareExpand(List<NavigationPropertySegment> expands, String parentAssociation,
										 String navigationSegmentConcatenated, List<ReadEntityInfo> siblingExpandList) throws EdmException {
		NavigationPropertySegment expand = expands.get(0);
		try {
			checkExpandAuthorization(expand);
		} catch (UnauthorizedException e) {
			logger.error(e.getMessage());
			MessageReference msgref = MessageReference.create(EdmException.class, e.getMessage());
			throw new EdmException(msgref, new ODataApplicationException(e.getMessage(),
					LocaleUtil.getLocaleforException(), HttpStatusCodes.FORBIDDEN));
		}
		
		// Ignore draft admin expand for draft root entity
		if (this.isDraftRoot && DraftUtilsV2.DRAFTS_ADMIN_TABLE_NAME.equals(expand.getNavigationProperty().getName())) {	
		      return null;
		}
		
		// Determine if ReadEntityInfo Already Exists for this Expand . Use Case ::
		// Customer?$expand=orders,orders/items,orders/items/inneritems
		ReadEntityInfo eInfo = QueryHelperUtility.determineReadEntityInfoForExpand(expand.getNavigationProperty().getName(),
				siblingExpandList);

		eInfo.setEntityName(expand.getNavigationProperty().getName());

		eInfo.setParententityName(parentAssociation);
		eInfo.setFetchColumns(true);
		if (expand.getNavigationProperty().getMultiplicity() == EdmMultiplicity.MANY) {
			eInfo.setIscollection(true);
		} else {
			eInfo.setIscollection(false);
		}
		if(orderByFromNavigation.size()>0) {
			ReadEntityInfo orderByEntity = orderByFromNavigation.get(expand.getNavigationProperty().getName());
			if(orderByEntity!=null)
				QueryHelperUtility.addOrderByProperties(orderByEntity,eInfo);
		}
		this.orderByPropsFromCSON = CSNUtil.getOrderByProperties(serviceName, expand.getTargetEntitySet().getName());
		eInfo.setColumns(resolvePropertiesToColumns(eInfo.getEntityName(), expand.getTargetEntitySet().getEntityType(),
				parentAssociation, navigationSegmentConcatenated + expand.getNavigationProperty().getName() + "/"));
		// Add OrderBy if it is set in the CSON
		QueryHelperUtility.addOrderBypropertiesFromCSON(orderByPropsFromCSON,eInfo, expand.getTargetEntitySet().getEntityType());
		// Add Default OrderBy on keys so the cartesian product comes in reserved order
		addOrderByForKeyPredicates(eInfo, expand.getTargetEntitySet().getEntityType());

		// Keep Recursing incase of MultiLevel Expand eg.
		// Person?$expand=apps/departments
		List<NavigationPropertySegment> subExpandsList = expands.subList(1, expands.size());
		if (subExpandsList != null && !subExpandsList.isEmpty()) {
			eInfo.getEntitiesExpanded()
					.add(prepareExpand(subExpandsList,
							parentAssociation + ALIASHLP + expand.getNavigationProperty().getName(),
							navigationSegmentConcatenated + expand.getNavigationProperty().getName() + "/",
							eInfo.getEntitiesExpanded()));
		}
		return eInfo;
	}

	private void checkExpandAuthorization(NavigationPropertySegment expand) throws EdmException, UnauthorizedException {
		String entityFQN = expand.getTargetEntitySet().getEntityType().toString();
		if (!AuthorizationService.hasEntityAccess(entityFQN, READ)) {
			StringBuilder errorMsg = new StringBuilder("Expanding via ");
			errorMsg.append(entityFQN);
			errorMsg.append(" not allowed for this user");
			logger.debug(errorMsg.toString());
			throw new UnauthorizedException(ACCESS_DENIED);
		}
	}

	private void handleSearchQueryOption(Map<String, String> customQueryOptions, ReadEntityInfo readEntityInfo,
										 String searchedEntity, boolean hasNavigation) throws CDSRuntimeException {

		List<String> fuzzyProperties = null;
		Filter filter = new Filter();
		String searchTerm = null;
		if (customQueryOptions != null && !customQueryOptions.isEmpty()) {
			readEntityInfo.setCustomQueryOptions(customQueryOptions);
			for (String key : customQueryOptions.keySet()) {
				if (key.toLowerCase().equals("search")) {
					searchTerm = customQueryOptions.get(key);
					break;
				}
			}
		}
		if (searchTerm != null) {
			searchTerm = searchTerm.replaceAll("^\"|\"$", "");
			searchTerm = searchTerm.replaceAll("^\'|\'$", "");
			StringBuffer searchQuery = new StringBuffer();
			List<String> searchableProperties = CSNUtil.getSearchableProperties(serviceName, searchedEntity);
			Map<String, Double> searchablePropertiesFuzzy = CSNUtil.getSearchablePropertiesWithFuzzy(serviceName,
					searchedEntity);
			String queryStr = "";
			if (searchableProperties != null) {

				if (searchablePropertiesFuzzy != null) {
					fuzzyProperties = searchablePropertiesFuzzy.keySet().stream().collect(Collectors.toList());
				}

				searchableProperties = searchableProperties.stream().map(prop -> prop).collect(Collectors.toList());
				if (hasNavigation) {
					queryStr = quoteIfRequired(readEntityInfo.getEntityName()) + ".";
				}

				for (Iterator<String> iterator = searchableProperties.iterator(); iterator.hasNext();) {
					String col = iterator.next();
					if (fuzzyProperties != null && fuzzyProperties.contains(col.toLowerCase())) {
						String type = CSNUtil.getCDSDataType(searchedEntity, serviceName, col);
						if (type.equals("cds.Date")) {
							searchQuery.append("CONTAINS(" + queryStr + quoteIfRequired(col) + ", " + "?" + ", FUZZY("
									+ searchablePropertiesFuzzy.get(col.toLowerCase()) + "))");
						} else {
							searchQuery.append("CONTAINS(" + queryStr + quoteIfRequired(col) + ", " + "?" + ", FUZZY("
									+ searchablePropertiesFuzzy.get(col.toLowerCase())
									+ " , 'similarCalculationMode=searchCompare'))");
						}
						filter.setParameter(new Parameter(searchTerm, "Edm.String", col.toLowerCase()));
					} else {
						searchQuery.append("CONTAINS(" + queryStr + quoteIfRequired(col) + ", " + "?" + ")");
						filter.setParameter(new Parameter("%" + searchTerm + "%", "Edm.String", col.toLowerCase()));
					}
					if (iterator.hasNext()) {
						searchQuery.append(" OR ");
					}

				}

				filter.setExpression(searchQuery.toString());
				readEntityInfo.getFilters().add(filter);
			} else {
				throw new CDSRuntimeException(MessageKeys.SEARCH_NOT_IMPLEMENTED,
						"Search not implemented for \"" + searchedEntity + "\" EntitySet.",
						LocaleUtil.getLocaleforException(), HttpStatusCodes.NOT_IMPLEMENTED);
			}

		}

	}

	
	private void handleSearchQueryOptionForQuoted(Map<String, String> customQueryOptions, ReadEntityInfo readEntityInfo,
			String searchedEntity, boolean hasNavigation) throws ODataException {

		String searchTerm = null;
		if (customQueryOptions != null && !customQueryOptions.isEmpty()) {
			readEntityInfo.setCustomQueryOptions(customQueryOptions);
			for (String key : customQueryOptions.keySet()) {
				if (key.toLowerCase().equals("search")) {
					searchTerm = customQueryOptions.get(key);
					break;
				}
			}
		}
		if (searchTerm != null) {
			searchTerm = searchTerm.replaceAll("^\"|\"$", "");

			if (searchTerm.contains("*") || searchTerm.contains("?")) {
				throw new CDSRuntimeException(MessageKeys.FUZZY_SEARCH_NOT_SUPPORTED, "Fuzzy Search when the sql mapping is not plain",
						Locale.ENGLISH, HttpStatusCodes.NOT_IMPLEMENTED);
			}

			String searchText = " LIKE UPPER('%" + searchTerm + "%')";
			StringBuffer searchQuery = new StringBuffer();
			List<String> searchableProperties = CSNUtil.getSearchableProperties(serviceName, searchedEntity);
			String queryStartStr = "";
			String queryEndStr = "";

			if (searchableProperties != null) {
				searchableProperties = searchableProperties.stream().map(prop -> SQLMapping.convertToUpperCaseIfRequired(prop))
						.collect(Collectors.toList());
				if (hasNavigation) {


					// Re-look SQL during quoted mode
					queryStartStr = "UPPER(ROOT_ENTITY_SELECT_ALIAS."
							+ quoteIfRequired(readEntityInfo.getEntityName()) + ".";
					queryEndStr = ")";
				} else {
					if (SQLMapping.isPlainSqlMapping()) {
						queryStartStr = "UPPER(";
						queryEndStr = ")";
					} else {
						queryStartStr = "UPPER(\"";
						queryEndStr = "\")";
					}
				}

				for (Iterator<String> iterator = searchableProperties.iterator(); iterator.hasNext(); ) {

					searchQuery.append(queryStartStr + "\"" + iterator.next() + "\"" + queryEndStr + searchText);
					if (iterator.hasNext()) {
						searchQuery.append(" OR ");
					}

				}
				// Internal Incident:1970092900 CXS OData v2 AutoExp: $filter is Ignored if
				// Custom Search is Present
				if (searchableProperties.size() > 1) {
					searchQuery.insert(0, "(");
					searchQuery.append(")");
				}
				readEntityInfo.getFilters().add(new Filter(searchQuery.toString()));
			} else {
				throw new CDSRuntimeException(MessageKeys.SEARCH_NOT_IMPLEMENTED,
						"Search not implemented for \"" + searchedEntity + "\" EntitySet.",
						LocaleUtil.getLocaleforException(), HttpStatusCodes.NOT_IMPLEMENTED);
			}

		}

}
	
	private String getAggregationFunctionFromCSN(String element, String entity) throws CDSRuntimeException {

		if (csn == null)
			throw new CDSRuntimeException(MessageKeys.CSN_FILE_NOT_FOUND, "CSN file required but not found.",
					LocaleUtil.getLocaleforException(), HttpStatusCodes.INTERNAL_SERVER_ERROR);

		JsonNode aggregation = csn.get("definitions").get(serviceName + "." + entity).get("elements").get(element)
				.get("@Aggregation.default");
		if (aggregation != null) {
			return aggregation.get("#").asText();
		}

		return null;
	}

	private List<Column> resolvePropertiesToColumns(String entPrefixName, EdmEntityType entity, String parent,
													String navigationName) throws EdmException {
		List<Column> columns = new ArrayList<Column>();
		if (entity != null && entity.getPropertyNames() != null && entity.getPropertyNames().size() > 0) {
			for (String prop : entity.getPropertyNames()) {
			// Eliminate few columns for draft root entity
        if (this.isDraftRoot && !DraftUtilsV2.isValidPropertyForMainTable(prop)) {
            continue;
        }
				String etagPropertyName = HANADMLHelperV2.getEtagPropertyName(entity);
				boolean key = false;
				boolean selected = false;
				Column col = formNewColumnObject(prop, parent + ALIASHLP + entPrefixName);
				if (entity.getKeyPropertyNames().contains(prop)) {
					key = true;
					col.setpKey(true);
					selected = true;
				}
				if (!key) { // Key properties should alaways be selected
					if (globalSelect.isEmpty() // This means no $select in query
							|| prop.equalsIgnoreCase(etagPropertyName) // This means that this is a concurrency property
							|| globalSelect.contains(navigationName + prop) // This means $select is there and property
							// has been selected
							|| globalSelect.contains(navigationName)  // This means $select is there and all
							// associated properties has been selected
							|| isOrderByFromCSONContains(prop) // If there a default orderby present in CSON, that property is also added
							//  in the entityInfo so that while adding the orderby clause, proper alias name can be added
							|| QueryHelperUtility.checkOrderByClause(prop, navigationName, globalOrderByStringFromURI)){

						selected = true;
					}
				}
				col.setType(ColumnType.Primitive);
				col.setColumnDataType(entity.getProperty(prop).getType().getName());
				if (selected) {
					columns.add(col);
				}
			}
		}
		return columns;
	}

	private boolean isOrderByFromCSONContains(String property) {
		for(Map<String, String> orderByprop:orderByPropsFromCSON) {
			if(orderByprop.containsKey(property)) {
				return true;
			}
		}
		return false;
	}

	private Column formNewColumnObject(String propertyName, String aliasPrefix) {
		Column col = new Column();
		col.setName(propertyName);
		col.setDbaliasName((aliasPrefix + ALIASHLP + propertyName).toUpperCase());
		return col;
	}

	private void addOrderByForKeyPredicates(ReadEntityInfo eInfo, EdmEntityType entity) throws EdmException {

		for (String keyP : entity.getKeyPropertyNames()) {
		// Ignore isActiveEntity key for draft root entity
      if (this.isDraftRoot && DraftUtilsV2.DRAFTS_ISACTIVE_ENTITY.equals(keyP)) {
          continue;
      }
			if (!eInfo.getOrderBySeq().contains(keyP)) {
				eInfo.getOrderBySeq().add(keyP);
				OrderBy orderBy = new OrderBy();
				orderBy.setDescending(false);
				orderBy.setPropertyName(keyP);
				orderBy.setAliasName(QueryHelperUtility.getAliasName(eInfo.getColumns(), keyP));
				eInfo.getOrderby().put(keyP, orderBy);
			}
		}

	}

	private List<Filter> getKeyPredicates(List<KeyPredicate> keyPredicate) throws EdmException {
		List<Filter> filters = new ArrayList<Filter>();
		Filter filter = null;
		for (KeyPredicate key : keyPredicate) {
		// Ignore IsActiveEntity for draft root entity
      if (this.isDraftRoot && key.getProperty().getName().equals(DraftUtilsV2.DRAFTS_ISACTIVE_ENTITY)) {
          continue;
      } else if(this.isDraft == false && key.getProperty().getName().equals(DraftUtilsV2.DRAFTS_ISACTIVE_ENTITY) == true) {
      	continue;
      }
			filter = new Filter();
			String keyName = quoteIfRequired(key.getProperty().getName());
			String pathPrefixedKeyName = "ROOT_ENTITY_SELECT_ALIAS" + "." + "PATH_FROM_ROOT."
					+ keyName.replace("/", ".");
			EdmSimpleType keyType = (EdmSimpleType) key.getProperty().getType();
			String value = getValueOfProperty(key, keyType);
			String expression = null;

			expression = pathPrefixedKeyName + " = " + "?";
			filter.setParameter(getParameterizedParamater(key, keyType));

			filter.setExpression(expression);
			filters.add(filter);
		}
		return filters;

	}

	public Filter prepeareParameterizedFilter(UriInfo uriInfo) throws ODataException {
		Filter uriFilter = (Filter) uriInfo.getFilter().accept(new HanaExpressionVisitor(uriInfo.getTargetEntitySet(),(this.isDraftRoot || this.isDraft)));
		if (customFilter.getExpression()!= null){
			uriFilter = addCustomFilter(uriFilter);
		}
		return uriFilter ;
	}

	private Filter prepeareParameterizedFilter() throws ODataException {
		if (customFilter.getExpression()!= null){
			return	customFilter;
		}
		return null;
	}

	private Filter addCustomFilter(Filter uriFilter) {

		String exp = "( " + uriFilter.getExpression() + finalOperator +  customFilter.getExpression() + " )";
		uriFilter.setExpression(exp);
		for (Parameter param : customFilter.getParameters()) {
			uriFilter.setParameter(param);
		}
		return uriFilter;
	}



	private String getValueOfProperty(KeyPredicate key, EdmSimpleType edmSimpleType) {
		String valueOfKey = "";
		if (edmSimpleType == EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance()) {
			valueOfKey = DateUtils.dateLiteralresolver("datetimeoffset\'" + key.getLiteral() + "\'");
		} else if (edmSimpleType == EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance()) {
			valueOfKey = DateUtils.dateLiteralresolver("datetime\'" + key.getLiteral() + "\'");
		} else if (!(edmSimpleType == EdmSimpleTypeKind.Int16.getEdmSimpleTypeInstance()
				|| edmSimpleType == EdmSimpleTypeKind.Int32.getEdmSimpleTypeInstance()
				|| edmSimpleType == EdmSimpleTypeKind.Int64.getEdmSimpleTypeInstance()
				|| edmSimpleType == EdmSimpleTypeKind.Decimal.getEdmSimpleTypeInstance()
				|| edmSimpleType == EdmSimpleTypeKind.Double.getEdmSimpleTypeInstance()
				|| edmSimpleType == EdmSimpleTypeKind.Boolean.getEdmSimpleTypeInstance())) {
			valueOfKey = "\'" + key.getLiteral() + "\'";
		} else {
			valueOfKey = key.getLiteral();
		}
		return valueOfKey;
	}

	private void modifyEntityInfoForAggregation(ReadEntityInfo eInfo, List<SelectItem> selectItems,
												EdmEntityType entityType, String viewName, FilterExpression filterExpression)
			throws CDSRuntimeException, EdmException {

		String AGGREGATE_ENTITY_KEY = "ID__";
		List<String> measures = new ArrayList<String>();
		List<String> groupingProperties = new ArrayList<String>();

		List<EdmProperty> properties = selectItems == null || selectItems.isEmpty()
				? entityType.getPropertyNames().stream().filter(p -> !p.equals(AGGREGATE_ENTITY_KEY)).map(p -> {
			try {
				return (EdmProperty) entityType.getProperty(p);
			} catch (EdmException e) {
				return null;
			}
		}).collect(Collectors.toList())
				: selectItems.stream().map(s -> s.getProperty()).collect(Collectors.toList());

		for (EdmProperty prop : properties) {
			EdmAnnotationAttribute aggregationRole = prop.getAnnotations().getAnnotationAttribute("aggregation-role",
					sapNamespace);
			if (aggregationRole != null && aggregationRole.getText().equals("measure")) {
				measures.add(prop.getName());
			} else if (!prop.getName().equals(AGGREGATE_ENTITY_KEY)) {
				groupingProperties.add(prop.getName());
			}
		}

		eInfo.setGroupBy(groupingProperties);
		eInfo.setColumns(
				groupingProperties.stream().map(p -> new Column(p).setDbaliasName(p)).collect(Collectors.toList()));
		if (filterExpression != null) {
			String filterExpressionString = filterExpression.getExpressionString();
			for (String s : measures) {
				String measureRegex = ".*\\b" + s + "\\b.*";
				if (filterExpressionString.matches(measureRegex)) {
					throw new CDSRuntimeException(MessageKeys.FILTER_ON_MEASURE, "$filter cannot be applied on measure",
							Locale.ENGLISH, HttpStatusCodes.BAD_REQUEST);
				}
			}
		}

		for (String m : measures) {
			String entityTypeName = entityType.getName();
			if(eInfo.isParameterisedView() && entityTypeName.endsWith("Type")) {
				entityTypeName = entityTypeName.substring(0, entityTypeName.lastIndexOf("Type"));
			}
			String aggregationFunction = getAggregationFunctionFromCSN(m, entityTypeName);
			String columnName;
			if("COUNT_DISTINCT".equals(aggregationFunction)) {
        		String refElement = CSNUtil.getAggregationRefElement(serviceName, m, entityTypeName);
        		if(refElement != null)
        			columnName = "COUNT" + "( DISTINCT " + quoteIfRequired(refElement) + ")";
        		else
        			columnName = "COUNT" + "( DISTINCT " + quoteIfRequired(m) + ")";
        	}else {
        		columnName = aggregationFunction + "(" + quoteIfRequired(m) + ")";
        	}
			this.setMeasure(columnName);
			eInfo.getColumns().add(new Column(columnName).setDbaliasName(m));
		}

	}

	private void setOrderByInReadEntityInfo(OrderByExpression orderByExpression, ReadEntityInfo eInfo)
			throws CDSRuntimeException {
		List<OrderExpression> orderExpressions = orderByExpression.getOrders();
		for (OrderExpression orderExpression : orderExpressions) {
			// Get the OrderBy Expression Only For the concerned Level which is only the
			// parent Level
			String orderByon = orderExpression.getExpression().getUriLiteral();
		// Eliminate order by if it contains HasActiveEntity,HasDraftEntity,IsActiveEntity for draft root entity
      if (this.isDraftRoot && !DraftUtilsV2.isValidPropertyForMainTable(orderByon)) {
          continue;
      }
			if (orderByon.contains("/")) {
				return;
			}

			eInfo.getOrderBySeq().add(orderByon);
			OrderBy oBy = new OrderBy();
			oBy.setPropertyName(orderByon);
			oBy.setDescending(orderExpression.getSortOrder().name() != "desc" ? false : true);
			oBy.setAliasName(QueryHelperUtility.getAliasName(eInfo.getColumns(), orderByon));
			eInfo.getOrderby().put(orderByon, oBy);
		}
	}



	@Override
	public String getSchema() {
		return schema;
	}

	@Override
	public ReadEntityInfo getEntityInfo() {
		return eInfo;
	}

	@Override
	public Long limitValue() {
		return topValue;
	}

	@Override
	public Long offsetValue() {
		return skipValue;
	}

	public void setTopValue(Long topValue) {
		this.topValue = topValue;
	}

	public void setSkipValue(Long skipValue) {
		this.skipValue = skipValue;
	}

	public boolean isAggregateEntity() {
		return isAggregateEntity;
	}

	public void setAggregateEntity(boolean isAggregateEntity) {
		this.isAggregateEntity = isAggregateEntity;
	}

	public boolean isSqlAggregated() {
		return isSqlAggregated;
	}

	public void setSqlAggregated(boolean isSqlAggregated) {
		this.isSqlAggregated = isSqlAggregated;
	}

	public List<String> getMeasuresPropertiesList() {
		return measuresPropertiesList;
	}

	public void setMeasure(String measure) {
		this.measuresPropertiesList.add(measure);
	}

	public void setMeasuresList(List<String> measuresList) {
		this.measuresPropertiesList = measuresList;
	}

	private void prepareGlobalSelectList() throws EdmException {
		if (globalUriInfo.getSelect().size() != 0) {
			if (selectExtension != null && selectExtension.size() > 0) {
				for (String selectedItem : selectExtension) {
					globalSelect.add(selectedItem);
				}
			} else {
				for (SelectItem sel : globalUriInfo.getSelect()) {
					StringBuffer selectedItem = new StringBuffer("");
					for (NavigationPropertySegment npg : sel.getNavigationPropertySegments()) {
						selectedItem.append(npg.getNavigationProperty().getName() + "/");
					}
					if (sel.getProperty() != null) {
						selectedItem.append(sel.getProperty().getName());
					}
					globalSelect.add(selectedItem.toString());
				}
			}
		}
	}

	private void checkOrderBy(OrderByExpression orderByExpression, ReadEntityInfo re, EdmEntitySet entitySet) throws EdmException, CDSRuntimeException {
        List<OrderExpression> orderExpressions = orderByExpression.getOrders();
        boolean inExpandPresent = false;
        List<ReadEntityInfo> orderbyEInfoList = new ArrayList<ReadEntityInfo>();
        for (OrderExpression orderExpression : orderExpressions) {
            ReadEntityInfo re1 = null;
            String lastnavigatedPropName = null;
            String firstnavigatedPropName = null;
            // Get the OrderBy Expression Only For the concerned Level which is only the parent Level
            String orderByon = orderExpression.getExpression().getUriLiteral();
            // Eliminate order by if it contains HasActiveEntity,HasDraftEntity,IsActiveEntity for draft root entity
            if (this.isDraftRoot && !DraftUtilsV2.isValidPropertyForMainTable(orderByon)) {
                continue;
            } else if(this.isDraft == false && DraftUtilsV2.isValidPropertyForMainTable(orderByon) == false) {
            	continue;
            }
            if (!orderByon.contains("/")) // This flow is only for when orderby is having navigation/propetyName
                return;
            
            if (ExpressionKind.MEMBER.equals(orderExpression.getExpression().getKind())) {
                EdmProperty edmProperty = null;
                MemberExpression memberExpression = (MemberExpression) orderExpression.getExpression();
                CommonExpression currentExpression = memberExpression;
                if (currentExpression != null) {
                    if (currentExpression != null
                            && currentExpression.getKind() == ExpressionKind.MEMBER) {
                        MemberExpression currentMember = (MemberExpression) currentExpression;
                        PropertyExpression p1 = (PropertyExpression) currentMember.getProperty();
                        edmProperty = (EdmProperty) p1.getEdmProperty();
                        orderByon = edmProperty.getName();
                    }
                }
                
                //Stack is used to fetch the all the entity names in orderby query except the last one 
                currentExpression = memberExpression.getPath();
                Stack<String> navigatedPropNames_stack = new Stack<String>();
                while (currentExpression != null) {
                	if(currentExpression.getKind() == ExpressionKind.MEMBER) 
                		currentExpression = ((MemberExpression) currentExpression).getPath();
                	else 
                		break;
                    if (currentExpression != null) {
                    	if(currentExpression.getKind() == ExpressionKind.MEMBER) {
                    		MemberExpression currentMember = (MemberExpression) currentExpression;
                    		navigatedPropNames_stack.push(currentMember.getProperty().getUriLiteral());
                    	}else if(currentExpression.getKind() == ExpressionKind.PROPERTY) {
                    		navigatedPropNames_stack.push(currentExpression.getUriLiteral());
                    		break;
                    	}
                    }
                }
                
                //To fetch the last entity name in orderby query
                if (memberExpression != null && memberExpression.getPath() != null) {
                	CommonExpression currentexpression = memberExpression.getPath();
                	if(currentexpression.getKind() == ExpressionKind.MEMBER) {
                		MemberExpression currentMember = (MemberExpression) currentexpression;
                    	lastnavigatedPropName = currentMember.getProperty().getUriLiteral();
                	}
                	else if(currentexpression.getKind() == ExpressionKind.PROPERTY) {
                		lastnavigatedPropName = currentexpression.getUriLiteral();
                	}
                }
                
                HashMap<String, EdmEntitySet> entitysets  = new HashMap<>();
                for(EdmEntitySet edm : entitySet.getEntityContainer().getEntitySets()) {
                	entitysets.put(edm.getName(), edm);
                }
                
                String parentAssociation = null;
                if("".equals(re.getParententityName())) {
                	parentAssociation = ALIASHLP + re.getEntityName();
                }
                else {
                	parentAssociation = re.getParententityName()+ALIASHLP + re.getEntityName();	
                }
                // Ignore draft admin expand for draft root entity
                if (this.isDraftRoot && DraftUtilsV2.DRAFTS_ADMIN_TABLE_NAME.equals(lastnavigatedPropName)) {
                    return;
                }
                String navigatedPropName = entitySet.getName();
                if(!navigatedPropNames_stack.empty()) {
                	firstnavigatedPropName = navigatedPropNames_stack.peek();
                }
                else {
                	firstnavigatedPropName = lastnavigatedPropName;
                }
                
                //to check the multiplicity and to form the parent association
            	while (!navigatedPropNames_stack.isEmpty()) {
            		EdmEntitySet entityset = entitysets.get(navigatedPropName);
            		EdmEntityTypeImplProv entityType = (EdmEntityTypeImplProv) entitySet.getEntityType();
                    EdmNavigationPropertyImplProv edmNavigationProp = (EdmNavigationPropertyImplProv) entityType.getProperty(navigatedPropNames_stack.peek());
                    QueryHelperUtility.checkEdmMultiplicity(edmNavigationProp);
                    navigatedPropName = edmNavigationProp.getToRole();
            		parentAssociation = parentAssociation + ALIASHLP + navigatedPropNames_stack.pop();
            	}
            	EdmEntitySet entityset = entitysets.get(navigatedPropName);
            	EdmEntityTypeImplProv entityType = (EdmEntityTypeImplProv) entityset.getEntityType();
                EdmNavigationPropertyImplProv edmNavigationProp = (EdmNavigationPropertyImplProv) entityType.getProperty(lastnavigatedPropName);
                QueryHelperUtility.checkEdmMultiplicity(edmNavigationProp);
                
                currentExpression = memberExpression.getPath();
                if (currentExpression != null)
                    re1 = prepareOrderBy(memberExpression.getPath(), orderByon, orderExpression.getSortOrder().name(), parentAssociation,
                            orderbyEInfoList, re, globalSelect, globalOrderByStringFromURI, null);
            }
            if (null != re1) {
                orderbyEInfoList.add(re1);
            }
            if (globalUriInfo.getExpand() != null && !globalUriInfo.getExpand().isEmpty()) {
                // Check this navigation property in $expand
                inExpandPresent = QueryHelperUtility.checkNavPropinExpand(globalUriInfo.getExpand(), firstnavigatedPropName);
                if (null != re1 && inExpandPresent) {
                    orderByFromNavigation.put(firstnavigatedPropName, re1);
                }
            }
        }
        if (orderbyEInfoList.size() > 0 && orderbyEInfoList.size() != orderByFromNavigation.size()) {
            re.getEntitiesExpanded().addAll(orderbyEInfoList);
        }
    }
	
	public ReadEntityInfo prepareOrderBy(CommonExpression currentExpression, String orderByon, String order, String parentAssociation,
			 List<ReadEntityInfo> siblingExpandList, ReadEntityInfo parentEntityInfo, List<String> globalSelect, String globalOrderByStringFromURI, ReadEntityInfo childEntityInfo) throws EdmException {
  	if(currentExpression.getKind() == ExpressionKind.PROPERTY) {
  		String navigatedPropName = currentExpression.getUriLiteral();
  		ReadEntityInfo re = prepareExpandForOrderBy((EdmEntityType) currentExpression.getEdmType(), navigatedPropName, orderByon, order, parentAssociation,
  				siblingExpandList, parentEntityInfo, globalSelect);
  		if(childEntityInfo != null) 
  			re.getEntitiesExpanded().add(childEntityInfo);
  		return re;
  	}
  	
  	MemberExpression currentMember = (MemberExpression) currentExpression;
  	String navigatedPropName = currentMember.getProperty().getUriLiteral(); 
  	ReadEntityInfo re = prepareExpandForOrderBy((EdmEntityType) currentExpression.getEdmType(), navigatedPropName, orderByon, order, parentAssociation,
				siblingExpandList, parentEntityInfo, globalSelect);
  	if(childEntityInfo != null) 
  		re.getEntitiesExpanded().add(childEntityInfo);
  	int index = parentAssociation.lastIndexOf("ZZ");
  	parentAssociation = parentAssociation.substring(0, index + 2);
  	return prepareOrderBy(((MemberExpression) currentExpression).getPath(), null, order, parentAssociation, siblingExpandList, parentEntityInfo, globalSelect, globalOrderByStringFromURI, re);
  }

	private ReadEntityInfo prepareExpandForOrderBy(EdmEntityType edmType, String navPropName, String orderByon, String order, String parentAssociation,
												   List<ReadEntityInfo> siblingExpandList, ReadEntityInfo parentEntityInfo, List<String> globalSelect) throws EdmException {


		// Determine if ReadEntityInfo Already Exists for this Expand . Use Case ::
		// Customer?$expand=orders,orders/items,orders/items/inneritems
		ReadEntityInfo navEntityInfo = QueryHelperUtility.determineReadEntityInfoForExpand(navPropName,
				siblingExpandList);
		navEntityInfo.setEntityName(navPropName);
		navEntityInfo.setParententityName(parentAssociation);
		navEntityInfo.setFetchColumns(true);
		navEntityInfo.setIscollection(false);
		navEntityInfo.setColumns(resolvePropertiesToColumnsForNavigatedEntity(navEntityInfo.getEntityName(), edmType,
				parentAssociation, navPropName + "/"));
		if(orderByon != null) {
			navEntityInfo.getOrderBySeq().add(orderByon);
			OrderBy oBy = new OrderBy();
			oBy.setPropertyName(orderByon);
			oBy.setDescending(order != "desc" ? false : true);
			oBy.setAliasName(QueryHelperUtility.getAliasName(navEntityInfo.getColumns(), orderByon));
			//navEntityInfo.getOrderby().put(orderByon, oBy);
			parentEntityInfo.getOrderByForExpanded().put(navPropName+"/"+orderByon, oBy); // This is added so that while forming the query, orderby with navigation property
			parentEntityInfo.getOrderBySeqForExpanded().add(orderByon);                   // can be considered as the first property

		}
		
		return navEntityInfo;
	}

	private List<Column> resolvePropertiesToColumnsForNavigatedEntity(String entPrefixName, EdmEntityType entity, String parent, String navigationName) throws EdmException {
		List<Column> columns = new ArrayList<Column>();
		if (entity != null && entity.getPropertyNames() != null && entity.getPropertyNames().size() > 0) {
			for (String prop : entity.getPropertyNames()) {
				String etagPropertyName = HANADMLHelperV2.getEtagPropertyName(entity);
				boolean key = false;
				boolean selected = false;
				Column col = formNewColumnObject(prop, parent + ALIASHLP + entPrefixName);
				if (entity.getKeyPropertyNames().contains(prop)) {
					key = true;
					col.setpKey(true);
					selected = true;
				}
				if (!key) { // Key properties should alaways be selected
					if (globalSelect.isEmpty() // This means no $select in query
							|| prop.equalsIgnoreCase(etagPropertyName) // This means that this is a concurrency property
							|| globalSelect.contains(navigationName + prop) // This means $select is there and property
							// has been selected
							|| globalSelect.contains(navigationName)  // This means $select is there and all
							// associated properties has been selected
							|| isOrderByFromCSONContains(prop) // If there a default orderby present in CSON, that property is also added
							//  in the entityInfo so that while adding the orderby clause, proper alias name can be added
							|| QueryHelperUtility.checkOrderByClause(prop,navigationName,globalOrderByStringFromURI)) {

						selected = true;
					}
				}
				col.setType(ColumnType.Primitive);
				col.setColumnDataType(entity.getProperty(prop).getType().getName());
				if (selected) {
					columns.add(col);
				}
			}
		}
		return columns;
	}
	/**
	 * Prepare EntityInfo for Views with Parameters
	 *
	 * @param uriInfo
	 * @param countStar
	 * @throws ODataException

	 */
	private void prepareEntityInfoForParameterViews(UriInfo uriInfo, boolean countStar) throws ODataException {

		logger.debug("Entering HANAQueryHelperV2 >> {prepareEntityInfoForParameterViews}");
		try {
			EdmEntitySet targetEntitySet = uriInfo.getTargetEntitySet();
			List<KeyPredicate> keyPredicate = uriInfo.getKeyPredicates();
			FilterExpression filterExpression = uriInfo.getFilter();
			List<SelectItem> selectItems = uriInfo.getSelect();
			String viewName = uriInfo.getStartEntitySet().getName();
			ReadEntityInfo eInfo = new ReadEntityInfo();

			eInfo.setEntityName(viewName);
			eInfo.setParententityName(viewName);
			eInfo.setIscollection(true);
			eInfo.setFetchColumns(true);
			eInfo.setServiceName(serviceName);
			for(int i=0;i<keyPredicate.size();i++) {
				String paramValue = keyPredicate.get(i).getLiteral();
				EdmType edmType = keyPredicate.get(i).getProperty().getType();
				eInfo.getParameters().put(keyPredicate.get(i).getProperty().getName(), QueryHelperUtility.convertParam(eInfo, edmType, keyPredicate.get(i).getProperty().getName(), paramValue));
			}
			eInfo.setIsParameterisedView(true);
			EdmEntityType targetType = targetEntitySet.getEntityType();
			EdmAnnotationAttribute annotationAttribute = targetType .getAnnotations().getAnnotationAttribute("semantics", sapNamespace);
			if(annotationAttribute != null && annotationAttribute.getText().equals("aggregate")) {
				this.isAggregateEntity = true;
				modifyEntityInfoForAggregation(eInfo, selectItems, targetType, viewName, filterExpression);
			}
			else{
				eInfo.setColumns(resolvePropertiesToColumns(viewName, targetEntitySet.getEntityType(),viewName, ""));
				addOrderByForKeyPredicates(eInfo, targetEntitySet.getEntityType());
			}
			//Handle Filter

			if(filterExpression!=null)
			{
				Filter filter = prepeareParameterizedFilter(uriInfo);
				if (filter != null ) {
					eInfo.getFilters().add(filter);
				}
			}
			eInfo.setCountStar(countStar);
			// for order by
			if(uriInfo.getOrderBy() != null){
				setOrderByInReadEntityInfo(uriInfo.getOrderBy(), eInfo);
			}
			eInfo.setIsParameterisedView(true);
			this.eInfo = eInfo;
		} catch (EdmException e) {
			logger.error(e.getMessage(), e);
			throw new CDSRuntimeException(CDSRuntimeException.MessageKeys.INTERNAL_ERROR, e.getMessage(), Locale.ENGLISH,
					HttpStatusCodes.INTERNAL_SERVER_ERROR, e);
		}
	}

	private boolean isParameterEntity(EdmEntitySet startEntitySet) throws EdmException {
		return startEntitySet.getEntityType().getName().endsWith(PARAMETER_ENTITY_SUFFIX) && startEntitySet.getEntityType().getProperty(PARAMETER_NAVIGATION_PROPERTY) != null;
	}
}
