/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.cds.exceptions;

import java.util.Locale;

import org.apache.olingo.odata2.api.commons.HttpStatusCodes;


public class CDSRuntimeException extends OdataGateWayException{
	
	private static final long serialVersionUID = 1L;

	public static enum MessageKeys implements MessageKey {
	    NOT_IMPLEMENTED,
	    QUERY_FAILED,
	    NO_CONNECTION,
	    INTERNAL_ERROR,
	    NO_ENTITY_FOUND,
	    TOP_SKIP_LIMITATION,
	    SERVER_PAGE_SIZE,
	    FILTER_ON_MEASURE,
	    CSN_FILE_NOT_FOUND,
	    CONFLICT,
		CSN_FILE_PARSING_ERROR,
		SEARCH_NOT_IMPLEMENTED,
		ORDERBY_ON_NAVIGATION,
		FUZZY_SEARCH_NOT_SUPPORTED,
		CREATE_MIMETYPE_MISMATCH,
		UPDATE_MIMETYPE_MISMATCH,
		READ_NO_MEDIA_FOUND,
		DELETE_NO_MEDIA_FOUND,
		UPDATE_NO_MEDIA_FOUND,
		MEDIA_ALREADY_EXISTS,
		READMEDIA_NO_ENTITY_FOUND,
		CREATEMEDIA_NO_ENTITY_FOUND,
		UPDATEMEDIA_NO_ENTITY_FOUND,
		DELETEMEDIA_NO_ENTITY_FOUND;

	    @Override
	    public String getKey() {
	      return name();
	    }
  }

		public CDSRuntimeException(MessageKey messageKey, String message, Locale locale, HttpStatusCodes status){
			super(messageKey, message, locale, status); 	
		}

		public CDSRuntimeException(MessageKey messageKey, String message, Locale locale, HttpStatusCodes status,
				Throwable e){
			super(messageKey, message, locale, status, e); 	
		}
}
