/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.rt.cds.exceptions;

import java.util.Formatter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;


public class OdataGateWayException extends ODataApplicationException{
	private static final long serialVersionUID = 1L;
	protected static final String DEFAULT_SERVER_BUNDLE_NAME = "library-exceptions-i18n";
	private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
	private Locale locale;
	private String oDataErrorCode;
	public interface MessageKey {
		/** Gets this key. */
		String getKey();
	}

	private transient MessageKey messageKey;
	private transient Object[] parameters;
	private String msg;


	public OdataGateWayException(MessageKey messageKey, String message, Locale locale, HttpStatusCodes status){
		super(message, locale, status); 	
		this.locale=locale;
		this.msg=message;
		this.messageKey=messageKey;
		this.oDataErrorCode=getClass().getSimpleName() + '.' + messageKey.getKey();
	}

	public OdataGateWayException(MessageKey messageKey, String message, Locale locale, HttpStatusCodes status,
			Throwable e){
		super(message, locale, status, e); 	
		this.locale=locale;
		this.msg=message;
		this.messageKey=messageKey;
		this.oDataErrorCode=getClass().getSimpleName() + '.' + messageKey.getKey();
	}

	@Override
	public String getLocalizedMessage(){
		if (messageKey == null) {
			return msg;
		}
		ResourceBundle bundle = createResourceBundle(locale);
		if (bundle == null) {
			return msg;
		}

		return buildMessage(bundle, locale ,messageKey);
	}

	private String buildMessage(final ResourceBundle bundle, final Locale locale ,MessageKey messageKey) {
		String message = null;
		Formatter formatter=null;
		try {
			message = bundle.getString(getClass().getSimpleName() + '.' + messageKey.getKey());
			StringBuilder builder = new StringBuilder();
			formatter = new Formatter(builder, locale);
			formatter.format(message, parameters);  // NOSONAR
			return builder.toString();
		} catch (MissingResourceException e) {
			return new String("Missing message for key '" + messageKey.getKey() + "'!" + DEFAULT_LOCALE);
		}finally{
			if(formatter!=null){
				formatter.close();
			}
		}
	}


	private ResourceBundle createResourceBundle(final Locale locale) {
		try {
			return ResourceBundle.getBundle(DEFAULT_SERVER_BUNDLE_NAME, locale == null ? DEFAULT_LOCALE : locale);
		} catch (final MissingResourceException e) {
			return null;
		}
	}
	@Override
	public String getCode() {
		return oDataErrorCode;
	}

}
