/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.response.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.internal.HasMetadata;
import com.sap.cloud.sdk.service.prov.api.util.DataConversionUtility;

public class EntityDataResponseHandler {

public static List<Map<String, Object>> getResultEntityFromEntityData(List<EntityData> edList) {
	
		List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		if(edList!=null && !edList.isEmpty()){
			
			if(edList.get(0) instanceof EntityData ) {	
			
			for(EntityData ed:edList){
				List<String> propertyNames = (((HasMetadata) ed).getEntityMetadata()).getElementNames();
				Map<String, Object> entry = new HashMap<String,Object>();
				for(String s : propertyNames) {
					Object value = ed.getElementValue(s);
					if(value instanceof HashMap){
						//To-DO Complex Type Handling
					}
					else{
						entry.put(s, value);
					}
				}
				result.add(entry);
			   }
		   }
		else{
			for(Object object :edList){
				result.add(DataConversionUtility.convertToMap(object)) ;
			}
		}
		 
		}
		return result;
		
	}
}
