/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.v2.response.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public class PojoResponseHandler {

	public static  Map<String, Object> getHashMapFromSinglePojo(Object pojoData) {
		ObjectMapper mapper = new ObjectMapper();
		/*-- Ignore Null Values --*/
		mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
		/*-- do not fail on empty beans  --*/
		mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS , false );
		/*-- First: hide all elements in the class ; make property,getter,setter hidden  --*/
		mapper.setVisibility(PropertyAccessor.ALL, Visibility.NONE);
		/*-- Second: now only make the properties discoverable   --*/
		mapper.setVisibility(PropertyAccessor.FIELD, Visibility.ANY);
		mapper.setSerializationInclusion(Include.NON_NULL);
		@SuppressWarnings("unchecked")
		Map<String, Object> pojoInMap = mapper.convertValue(pojoData, Map.class); 
		
		return pojoInMap;
	}
	
	public static List<Map<String, Object>> getHashMapFromListOfPojo(List<?> data) {
		ObjectMapper mapper = new ObjectMapper();
		/*-- Ignore Null Values --*/
		mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
		/*-- do not fail on empty beans  --*/
		mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS , false );
		/*-- First: hide all elements in the class ; make property,getter,setter hidden  --*/
		mapper.setVisibility(PropertyAccessor.ALL, Visibility.NONE);
		/*-- Second: now only make the properties discoverable   --*/
		mapper.setVisibility(PropertyAccessor.FIELD, Visibility.ANY);
		mapper.setSerializationInclusion(Include.NON_NULL);
		return data.stream().map(pojo -> {
			  @SuppressWarnings("unchecked")
			Map<String, Object> entity = mapper.convertValue(pojo, Map.class);
			  return entity ;
		}).collect(Collectors.toList());
              
	}
}
