/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.edm.xml.Edmx;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.api.serialization.ClientODataDeserializer;
import org.apache.olingo.client.api.serialization.ODataDeserializer;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.data.JSONServiceDocumentDeserializer;
import org.apache.olingo.client.core.data.XMLServiceDocumentDeserializer;
import org.apache.olingo.client.core.edm.ClientCsdlXMLMetadata;
import org.apache.olingo.client.core.edm.xml.ClientCsdlEdmx;
import org.apache.olingo.client.core.serialization.AtomDeserializer;
import org.apache.olingo.client.core.serialization.JsonDeltaDeserializer;
import org.apache.olingo.client.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.format.ContentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClientODataDeserializerImpl
implements ClientODataDeserializer {
    private final ODataDeserializer deserializer;
    private final ContentType contentType;
    private static final String SCHEMA = "Schema";
    private static final String XMLNS = "xmlns";

    public ClientODataDeserializerImpl(boolean serverMode, ContentType contentType) {
        this.contentType = contentType;
        this.deserializer = contentType.isCompatible(ContentType.APPLICATION_ATOM_SVC) || contentType.isCompatible(ContentType.APPLICATION_ATOM_XML) || contentType.isCompatible(ContentType.APPLICATION_XML) ? new AtomDeserializer() : new JsonDeserializer(serverMode);
    }

    @Override
    public ResWrap<EntityCollection> toEntitySet(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toEntitySet(input);
    }

    @Override
    public ResWrap<Entity> toEntity(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toEntity(input);
    }

    @Override
    public ResWrap<Property> toProperty(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toProperty(input);
    }

    @Override
    public ODataError toError(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toError(input);
    }

    protected XmlMapper getXmlMapper() {
        XmlMapper xmlMapper = new XmlMapper(new XmlFactory((XMLInputFactory)new InputFactoryImpl(), (XMLOutputFactory)new OutputFactoryImpl()), new JacksonXmlModule());
        xmlMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(Boolean.class, (Object)Boolean.FALSE));
        xmlMapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, com.fasterxml.jackson.databind.JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
                ctxt.getParser().skipChildren();
                return true;
            }
        });
        return xmlMapper;
    }

    @Override
    public XMLMetadata toMetadata(InputStream input) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)byteArrayOutputStream);
            byte[] inputContent = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream inputStream1 = new ByteArrayInputStream(inputContent);
            Edmx edmx = (Edmx)this.getXmlMapper().readValue((InputStream)inputStream1, ClientCsdlEdmx.class);
            ByteArrayInputStream inputStream2 = new ByteArrayInputStream(inputContent);
            List<List<String>> schemaNameSpaces = this.getAllSchemaNameSpace(inputStream2);
            return new ClientCsdlXMLMetadata(edmx, schemaNameSpaces);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse as Edmx document", e);
        }
    }

    private List<List<String>> getAllSchemaNameSpace(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<List<String>> schemaNameSpaces = new ArrayList<List<String>>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://xml.org/sax/features/namespaces", true);
        dbFactory.setFeature("http://apache.org/xml/features/validation/schema", false);
        dbFactory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(inputStream);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName(SCHEMA);
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            ArrayList<String> nameSpaces = new ArrayList<String>();
            if (nNode.getNodeType() == 1) {
                Element eElement = (Element)nNode;
                NamedNodeMap attributes = eElement.getAttributes();
                int len = attributes.getLength();
                for (int i = 0; i < len; ++i) {
                    String attrName = attributes.item(i).getNodeName();
                    if (!XMLNS.equals(attrName) && !attrName.startsWith("xmlns:")) continue;
                    nameSpaces.add(attributes.item(i).getNodeValue());
                }
            }
            schemaNameSpaces.add(nameSpaces);
        }
        return schemaNameSpaces;
    }

    @Override
    public ResWrap<ServiceDocument> toServiceDocument(InputStream input) throws ODataDeserializerException {
        return this.contentType.isCompatible(ContentType.APPLICATION_XML) ? new XMLServiceDocumentDeserializer(false).toServiceDocument(input) : new JSONServiceDocumentDeserializer(false).toServiceDocument(input);
    }

    @Override
    public ResWrap<Delta> toDelta(InputStream input) throws ODataDeserializerException {
        try {
            return this.contentType.isCompatible(ContentType.APPLICATION_ATOM_SVC) || this.contentType.isCompatible(ContentType.APPLICATION_ATOM_XML) ? new AtomDeserializer().delta(input) : new JsonDeltaDeserializer(false).toDelta(input);
        }
        catch (XMLStreamException | EdmPrimitiveTypeException e) {
            throw new ODataDeserializerException(e);
        }
    }

    @Override
    public List<CsdlSchema> fetchTermDefinitionSchema(List<InputStream> input) {
        ArrayList<CsdlSchema> schemas = new ArrayList<CsdlSchema>();
        try {
            for (InputStream stream : input) {
                ClientCsdlEdmx edmx = (ClientCsdlEdmx)this.getXmlMapper().readValue(stream, ClientCsdlEdmx.class);
                schemas.addAll(edmx.getDataServices().getSchemas());
            }
            return schemas;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse Term definition", e);
        }
    }
}

