/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.serialization.ODataSerializer;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.core.serialization.JsonEntitySerializer;
import org.apache.olingo.client.core.serialization.JsonEntitySetSerializer;
import org.apache.olingo.client.core.serialization.JsonGeoValueSerializer;
import org.apache.olingo.client.core.serialization.JsonPropertySerializer;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class JsonSerializer
implements ODataSerializer {
    private static final List<EdmPrimitiveTypeKind> NUMBER_TYPES = Arrays.asList(EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int64, EdmPrimitiveTypeKind.Decimal);
    private final JsonGeoValueSerializer geoSerializer = new JsonGeoValueSerializer();
    protected boolean serverMode;
    protected ContentType contentType;
    protected final boolean isIEEE754Compatible;
    protected final boolean isODataMetadataNone;
    protected final boolean isODataMetadataFull;

    public JsonSerializer(boolean serverMode, ContentType contentType) {
        this.serverMode = serverMode;
        this.contentType = contentType;
        this.isIEEE754Compatible = this.isIEEE754Compatible();
        this.isODataMetadataNone = this.isODataMetadataNone();
        this.isODataMetadataFull = this.isODataMetadataFull();
    }

    @Override
    public <T> void write(Writer writer, T obj) throws ODataSerializerException {
        try (JsonGenerator json = new JsonFactory().createGenerator(writer);){
            if (obj instanceof EntityCollection) {
                new JsonEntitySetSerializer(this.serverMode, this.contentType).doSerialize((EntityCollection)obj, json);
            } else if (obj instanceof Entity) {
                new JsonEntitySerializer(this.serverMode, this.contentType).doSerialize((Entity)obj, json);
            } else if (obj instanceof Property) {
                new JsonPropertySerializer(this.serverMode, this.contentType).doSerialize((Property)obj, json);
            } else if (obj instanceof Link) {
                this.link((Link)obj, json);
            }
            json.flush();
        }
        catch (IOException | EdmPrimitiveTypeException e) {
            throw new ODataSerializerException(e);
        }
    }

    private void reference(ResWrap<URI> container, JsonGenerator json) throws IOException {
        json.writeStartObject();
        if (!this.isODataMetadataNone) {
            json.writeStringField("@odata.context", container.getContextURL().toASCIIString());
        }
        json.writeStringField("@odata.id", container.getPayload().toASCIIString());
        json.writeEndObject();
    }

    @Override
    public <T> void write(Writer writer, ResWrap<T> container) throws ODataSerializerException {
        Object obj = container == null ? null : container.getPayload();
        try (JsonGenerator json = new JsonFactory().createGenerator(writer);){
            if (obj instanceof EntityCollection) {
                new JsonEntitySetSerializer(this.serverMode, this.contentType).doContainerSerialize(container, json);
            } else if (obj instanceof Entity) {
                new JsonEntitySerializer(this.serverMode, this.contentType).doContainerSerialize(container, json);
            } else if (obj instanceof Property) {
                new JsonPropertySerializer(this.serverMode, this.contentType).doContainerSerialize(container, json);
            } else if (obj instanceof Link) {
                this.link(obj, json);
            } else if (obj instanceof URI) {
                this.reference(container, json);
            }
            json.flush();
        }
        catch (IOException | EdmPrimitiveTypeException e) {
            throw new ODataSerializerException(e);
        }
    }

    protected void link(Link link, JsonGenerator jgen) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("url", link.getHref());
        jgen.writeEndObject();
    }

    protected void links(Linked linked, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        if (this.serverMode) {
            this.serverLinks(linked, jgen);
        } else {
            this.clientLinks(linked, jgen);
        }
    }

    protected void clientLinks(Linked linked, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        HashMap entitySetLinks = new HashMap();
        for (Link link : linked.getNavigationLinks()) {
            for (Annotation annotation : link.getAnnotations()) {
                this.valuable(jgen, annotation, link.getTitle() + "@" + annotation.getTerm());
            }
            if (this.isEntitySetNavigation(link)) {
                List<String> uris;
                if (entitySetLinks.containsKey(link.getTitle())) {
                    uris = (List)entitySetLinks.get(link.getTitle());
                } else {
                    uris = new ArrayList();
                    entitySetLinks.put(link.getTitle(), uris);
                }
                if (link.getHref() != null && !link.getHref().isEmpty()) {
                    uris.add(link.getHref());
                }
            } else if (link.getHref() != null && !link.getHref().isEmpty()) {
                jgen.writeStringField(link.getTitle() + "@odata.bind", link.getHref());
            }
            if (link.getInlineEntity() != null) {
                jgen.writeFieldName(link.getTitle());
                new JsonEntitySerializer(this.serverMode, this.contentType).doSerialize(link.getInlineEntity(), jgen);
                continue;
            }
            if (link.getInlineEntitySet() == null) continue;
            jgen.writeArrayFieldStart(link.getTitle());
            JsonEntitySerializer entitySerializer = new JsonEntitySerializer(this.serverMode, this.contentType);
            for (Entity subEntry : link.getInlineEntitySet().getEntities()) {
                entitySerializer.doSerialize(subEntry, jgen);
            }
            jgen.writeEndArray();
        }
        for (Map.Entry entry : entitySetLinks.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            jgen.writeArrayFieldStart((String)entry.getKey() + "@odata.bind");
            for (String string : (List)entry.getValue()) {
                jgen.writeString(string);
            }
            jgen.writeEndArray();
        }
    }

    private boolean isEntitySetNavigation(Link link) {
        return Constants.ENTITY_SET_NAVIGATION_LINK_TYPE.equals(link.getType());
    }

    protected void serverLinks(Linked linked, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        if (linked instanceof Entity && this.isODataMetadataFull) {
            for (Link link : ((Entity)linked).getMediaEditLinks()) {
                if (link.getHref() == null || link.getHref().isEmpty()) continue;
                jgen.writeStringField(link.getTitle() + "@odata.mediaEditLink", link.getHref());
            }
        }
        if (this.isODataMetadataFull) {
            for (Link link : linked.getAssociationLinks()) {
                if (link.getHref() == null || link.getHref().isEmpty()) continue;
                jgen.writeStringField(link.getTitle() + "@odata.associationLink", link.getHref());
            }
        }
        for (Link link : linked.getNavigationLinks()) {
            for (Annotation annotation : link.getAnnotations()) {
                this.valuable(jgen, annotation, link.getTitle() + "@" + annotation.getTerm());
            }
            if (link.getHref() != null && !link.getHref().isEmpty() && this.isODataMetadataFull) {
                jgen.writeStringField(link.getTitle() + "@odata.navigationLink", link.getHref());
            }
            if (link.getInlineEntity() != null) {
                jgen.writeFieldName(link.getTitle());
                new JsonEntitySerializer(this.serverMode, this.contentType).doSerialize(link.getInlineEntity(), jgen);
                continue;
            }
            if (link.getInlineEntitySet() == null) continue;
            jgen.writeArrayFieldStart(link.getTitle());
            JsonEntitySerializer entitySerializer = new JsonEntitySerializer(this.serverMode, this.contentType);
            for (Entity subEntry : link.getInlineEntitySet().getEntities()) {
                entitySerializer.doSerialize(subEntry, jgen);
            }
            jgen.writeEndArray();
        }
    }

    private void collection(JsonGenerator jgen, EdmTypeInfo typeInfo, ValueType valueType, List<?> value) throws IOException, EdmPrimitiveTypeException {
        EdmTypeInfo itemTypeInfo = typeInfo == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeInfo.getFullQualifiedName().toString()).build();
        jgen.writeStartArray();
        for (Object item : value) {
            switch (valueType) {
                case COLLECTION_PRIMITIVE: {
                    this.primitiveValue(jgen, itemTypeInfo, item);
                    break;
                }
                case COLLECTION_GEOSPATIAL: {
                    jgen.writeStartObject();
                    this.geoSerializer.serialize(jgen, (Geospatial)item);
                    jgen.writeEndObject();
                    break;
                }
                case COLLECTION_ENUM: {
                    jgen.writeString(item.toString());
                    break;
                }
                case COLLECTION_COMPLEX: {
                    ComplexValue complexItem2 = (ComplexValue)item;
                    itemTypeInfo = complexItem2.getTypeName() == null ? itemTypeInfo : new EdmTypeInfo.Builder().setTypeExpression(complexItem2.getTypeName()).build();
                    this.complexValue(jgen, itemTypeInfo, complexItem2.getValue(), complexItem2);
                    break;
                }
            }
        }
        jgen.writeEndArray();
    }

    protected void primitiveValue(JsonGenerator jgen, EdmTypeInfo typeInfo, Object value) throws IOException, EdmPrimitiveTypeException {
        EdmPrimitiveTypeKind kind;
        EdmPrimitiveTypeKind edmPrimitiveTypeKind = kind = typeInfo == null ? EdmTypeInfo.determineTypeKind(value) : typeInfo.getPrimitiveTypeKind();
        if (value == null) {
            jgen.writeNull();
        } else if (kind == EdmPrimitiveTypeKind.Boolean) {
            jgen.writeBoolean(((Boolean)value).booleanValue());
        } else if (kind == null) {
            if (this.serverMode) {
                throw new EdmPrimitiveTypeException("The primitive type could not be determined.");
            }
            jgen.writeString(value.toString());
        } else {
            String serialized = EdmPrimitiveTypeFactory.getInstance(kind).valueToString(value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null);
            if (this.isIEEE754Compatible && (kind == EdmPrimitiveTypeKind.Int64 || kind == EdmPrimitiveTypeKind.Decimal) || !NUMBER_TYPES.contains((Object)kind)) {
                jgen.writeString(serialized);
            } else {
                jgen.writeNumber(serialized);
            }
        }
    }

    private void complexValue(JsonGenerator jgen, EdmTypeInfo typeInfo, List<Property> value, Linked linked) throws IOException, EdmPrimitiveTypeException {
        jgen.writeStartObject();
        if (typeInfo != null && this.isODataMetadataFull) {
            jgen.writeStringField("@odata.type", typeInfo.external());
        }
        for (Property property : value) {
            this.valuable(jgen, property, property.getName());
        }
        if (linked != null) {
            this.links(linked, jgen);
        }
        jgen.writeEndObject();
    }

    private void value(JsonGenerator jgen, String type, Valuable value) throws IOException, EdmPrimitiveTypeException {
        EdmTypeInfo typeInfo;
        EdmTypeInfo edmTypeInfo = typeInfo = type == null ? null : new EdmTypeInfo.Builder().setTypeExpression(type).build();
        if (value.isNull()) {
            jgen.writeNull();
        } else if (value.isCollection()) {
            this.collection(jgen, typeInfo, value.getValueType(), value.asCollection());
        } else if (value.isPrimitive()) {
            this.primitiveValue(jgen, typeInfo, value.asPrimitive());
        } else if (value.isEnum()) {
            jgen.writeString(value.asEnum().toString());
        } else if (value.isGeospatial()) {
            jgen.writeStartObject();
            this.geoSerializer.serialize(jgen, value.asGeospatial());
            jgen.writeEndObject();
        } else if (value.isComplex()) {
            this.complexValue(jgen, typeInfo, value.asComplex().getValue(), value.asComplex());
        }
    }

    protected void valuable(JsonGenerator jgen, Valuable valuable, String name) throws IOException, EdmPrimitiveTypeException {
        if (!("value".equals(name) || valuable instanceof Annotation || valuable.isComplex() && !valuable.isCollection())) {
            String type = valuable.getType();
            if (!valuable.isCollection() && (type == null || type.isEmpty()) && valuable.isPrimitive()) {
                type = EdmPrimitiveTypeKind.String.getFullQualifiedName().toString();
            }
            if (type != null && !type.isEmpty() && this.isODataMetadataFull) {
                jgen.writeStringField(name + "@odata.type", new EdmTypeInfo.Builder().setTypeExpression(type).build().external());
            }
        }
        for (Annotation annotation : valuable.getAnnotations()) {
            this.valuable(jgen, annotation, name + "@" + annotation.getTerm());
        }
        jgen.writeFieldName(name);
        this.value(jgen, valuable.getType(), valuable);
    }

    private boolean isIEEE754Compatible() {
        String parameter = this.contentType.getParameters().get("IEEE754Compatible");
        return parameter == null ? false : "true".equalsIgnoreCase(parameter);
    }

    private boolean isODataMetadataNone() {
        return this.contentType.isCompatible(ContentType.APPLICATION_JSON) && "none".equalsIgnoreCase(this.contentType.getParameter("odata.metadata"));
    }

    private boolean isODataMetadataFull() {
        return this.contentType.isCompatible(ContentType.APPLICATION_JSON) && "full".equalsIgnoreCase(this.contentType.getParameter("odata.metadata"));
    }
}

