/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.QueryOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;
import org.apache.olingo.server.api.uri.queryoption.apply.BottomTop;
import org.apache.olingo.server.api.uri.queryoption.apply.Compute;
import org.apache.olingo.server.api.uri.queryoption.apply.ComputeExpression;
import org.apache.olingo.server.api.uri.queryoption.apply.Concat;
import org.apache.olingo.server.api.uri.queryoption.apply.CustomFunction;
import org.apache.olingo.server.api.uri.queryoption.apply.Expand;
import org.apache.olingo.server.api.uri.queryoption.apply.Filter;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupByItem;
import org.apache.olingo.server.api.uri.queryoption.apply.Search;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.search.SearchExpression;
import org.apache.olingo.server.core.debug.DebugResponseHelperImpl;
import org.apache.olingo.server.core.debug.DebugTab;
import org.apache.olingo.server.core.debug.ExpressionJsonVisitor;

public class DebugTabUri
implements DebugTab {
    private final UriInfo uriInfo;

    public DebugTabUri(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public String getName() {
        return "URI";
    }

    @Override
    public void appendJson(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("kind", this.uriInfo.getKind().name());
        if (this.uriInfo.getKind() == UriInfoKind.resource) {
            gen.writeFieldName("uriResourceParts");
            this.appendURIResourceParts(gen, this.uriInfo.getUriResourceParts());
        } else if (this.uriInfo.getKind() == UriInfoKind.crossjoin) {
            gen.writeFieldName("entitySetNames");
            gen.writeStartArray();
            for (String name : this.uriInfo.asUriInfoCrossjoin().getEntitySetNames()) {
                gen.writeString(name);
            }
            gen.writeEndArray();
        } else if (this.uriInfo.getKind() == UriInfoKind.entityId) {
            this.appendType(gen, "typeCast", this.uriInfo.asUriInfoEntityId().getEntityTypeCast());
        }
        if (this.uriInfo.getFormatOption() != null) {
            gen.writeStringField("format", this.uriInfo.getFormatOption().getFormat());
        }
        if (this.uriInfo.getIdOption() != null) {
            gen.writeStringField("id", this.uriInfo.getIdOption().getValue());
        }
        if (this.uriInfo.getSkipTokenOption() != null) {
            gen.writeStringField("skiptoken", this.uriInfo.getSkipTokenOption().getValue());
        }
        if (this.uriInfo.getDeltaTokenOption() != null) {
            gen.writeStringField("deltatoken", this.uriInfo.getDeltaTokenOption().getValue());
        }
        this.appendCommonJsonObjects(gen, this.uriInfo.getCountOption(), this.uriInfo.getSkipOption(), this.uriInfo.getTopOption(), this.uriInfo.getFilterOption(), this.uriInfo.getOrderByOption(), this.uriInfo.getSelectOption(), this.uriInfo.getExpandOption(), this.uriInfo.getSearchOption(), this.uriInfo.getApplyOption());
        if (!this.uriInfo.getAliases().isEmpty()) {
            gen.writeFieldName("aliases");
            DebugResponseHelperImpl.appendJsonTable(gen, this.getQueryOptionsMap(this.uriInfo.getAliases()));
        }
        if (!this.uriInfo.getCustomQueryOptions().isEmpty()) {
            gen.writeFieldName("customQueryOptions");
            DebugResponseHelperImpl.appendJsonTable(gen, this.getQueryOptionsMap(this.uriInfo.getCustomQueryOptions()));
        }
        gen.writeEndObject();
    }

    private void appendCommonJsonObjects(JsonGenerator gen, CountOption countOption, SkipOption skipOption, TopOption topOption, FilterOption filterOption, OrderByOption orderByOption, SelectOption selectOption, ExpandOption expandOption, SearchOption searchOption, ApplyOption applyOption) throws IOException {
        if (countOption != null) {
            gen.writeBooleanField("isCount", countOption.getValue());
        }
        if (skipOption != null) {
            gen.writeNumberField("skip", skipOption.getValue());
        }
        if (topOption != null) {
            gen.writeNumberField("top", topOption.getValue());
        }
        if (filterOption != null) {
            gen.writeFieldName("filter");
            this.appendExpressionJson(gen, filterOption.getExpression());
        }
        if (orderByOption != null && !orderByOption.getOrders().isEmpty()) {
            gen.writeFieldName("orderby");
            gen.writeStartObject();
            gen.writeStringField("nodeType", "orderCollection");
            gen.writeFieldName("orders");
            this.appendOrderByItemsJson(gen, orderByOption.getOrders());
            gen.writeEndObject();
        }
        if (selectOption != null && !selectOption.getSelectItems().isEmpty()) {
            gen.writeFieldName("select");
            this.appendSelectedPropertiesJson(gen, selectOption.getSelectItems());
        }
        if (expandOption != null && !expandOption.getExpandItems().isEmpty()) {
            gen.writeFieldName("expand");
            this.appendExpandedPropertiesJson(gen, expandOption.getExpandItems());
        }
        if (searchOption != null) {
            gen.writeFieldName("search");
            this.appendSearchJson(gen, searchOption.getSearchExpression());
        }
        if (applyOption != null) {
            gen.writeFieldName("apply");
            this.appendApplyItemsJson(gen, applyOption.getApplyItems());
        }
    }

    private void appendURIResourceParts(JsonGenerator gen, List<UriResource> uriResourceParts) throws IOException {
        gen.writeStartArray();
        for (UriResource resource : uriResourceParts) {
            gen.writeStartObject();
            gen.writeStringField("uriResourceKind", resource.getKind().toString());
            gen.writeStringField("segment", resource.toString());
            if (resource instanceof UriResourcePartTyped) {
                this.appendType(gen, "type", ((UriResourcePartTyped)resource).getType());
                gen.writeBooleanField("isCollection", ((UriResourcePartTyped)resource).isCollection());
            }
            if (resource instanceof UriResourceEntitySet) {
                this.appendParameters(gen, "keys", ((UriResourceEntitySet)resource).getKeyPredicates());
                this.appendType(gen, "typeFilterOnCollection", ((UriResourceEntitySet)resource).getTypeFilterOnCollection());
                this.appendType(gen, "typeFilterOnEntry", ((UriResourceEntitySet)resource).getTypeFilterOnEntry());
            } else if (resource instanceof UriResourceNavigation) {
                this.appendParameters(gen, "keys", ((UriResourceNavigation)resource).getKeyPredicates());
                this.appendType(gen, "typeFilterOnCollection", ((UriResourceNavigation)resource).getTypeFilterOnCollection());
                this.appendType(gen, "typeFilterOnEntry", ((UriResourceNavigation)resource).getTypeFilterOnEntry());
            } else if (resource instanceof UriResourceFunction) {
                this.appendParameters(gen, "parameters", ((UriResourceFunction)resource).getParameters());
                this.appendParameters(gen, "keys", ((UriResourceFunction)resource).getKeyPredicates());
                this.appendType(gen, "typeFilterOnCollection", ((UriResourceFunction)resource).getTypeFilterOnCollection());
                this.appendType(gen, "typeFilterOnEntry", ((UriResourceFunction)resource).getTypeFilterOnEntry());
            } else if (resource instanceof UriResourceSingleton) {
                this.appendType(gen, "typeFilter", ((UriResourceSingleton)resource).getEntityTypeFilter());
            } else if (resource instanceof UriResourceComplexProperty) {
                this.appendType(gen, "typeFilter", ((UriResourceComplexProperty)resource).getComplexTypeFilter());
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void appendType(JsonGenerator json, String name, EdmType type) throws IOException {
        if (type != null) {
            json.writeStringField(name, type.getFullQualifiedName().getFullQualifiedNameAsString());
        }
    }

    private void appendParameters(JsonGenerator gen, String name, List<UriParameter> parameters) throws IOException {
        if (!parameters.isEmpty()) {
            LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
            for (UriParameter parameter : parameters) {
                parameterMap.put(parameter.getName(), parameter.getText() == null ? parameter.getAlias() : parameter.getText());
            }
            gen.writeFieldName(name);
            DebugResponseHelperImpl.appendJsonTable(gen, parameterMap);
        }
    }

    private void appendOrderByItemsJson(JsonGenerator gen, List<OrderByItem> orders) throws IOException {
        gen.writeStartArray();
        for (OrderByItem item : orders) {
            gen.writeStartObject();
            gen.writeStringField("nodeType", "order");
            gen.writeStringField("sortorder", item.isDescending() ? "desc" : "asc");
            gen.writeFieldName("expression");
            this.appendExpressionJson(gen, item.getExpression());
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void appendExpandedPropertiesJson(JsonGenerator gen, List<ExpandItem> expandItems) throws IOException {
        gen.writeStartArray();
        for (ExpandItem item : expandItems) {
            this.appendExpandItemJson(gen, item);
        }
        gen.writeEndArray();
    }

    private void appendExpandItemJson(JsonGenerator gen, ExpandItem item) throws IOException {
        gen.writeStartObject();
        if (item.isStar()) {
            gen.writeBooleanField("star", item.isStar());
        } else if (item.getResourcePath() != null && !item.getResourcePath().getUriResourceParts().isEmpty()) {
            gen.writeFieldName("expandPath");
            this.appendURIResourceParts(gen, item.getResourcePath().getUriResourceParts());
        }
        if (item.isRef()) {
            gen.writeBooleanField("isRef", item.isRef());
        }
        if (item.getLevelsOption() != null) {
            gen.writeFieldName("levels");
            if (item.getLevelsOption().isMax()) {
                gen.writeString("max");
            } else {
                gen.writeNumber(item.getLevelsOption().getValue());
            }
        }
        this.appendCommonJsonObjects(gen, item.getCountOption(), item.getSkipOption(), item.getTopOption(), item.getFilterOption(), item.getOrderByOption(), item.getSelectOption(), item.getExpandOption(), item.getSearchOption(), item.getApplyOption());
        gen.writeEndObject();
    }

    private void appendExpressionJson(JsonGenerator gen, Expression expression) throws IOException {
        if (expression == null) {
            gen.writeNull();
        } else {
            try {
                JsonNode tree = expression.accept(new ExpressionJsonVisitor());
                gen.writeTree((TreeNode)tree);
            }
            catch (ODataException e) {
                gen.writeString("Exception in Debug Expression visitor occurred: " + e.getMessage());
            }
        }
    }

    private void appendSelectedPropertiesJson(JsonGenerator gen, List<SelectItem> selectItems) throws IOException {
        gen.writeStartArray();
        for (SelectItem selectItem : selectItems) {
            gen.writeString(this.getSelectString(selectItem));
        }
        gen.writeEndArray();
    }

    private String getSelectString(SelectItem selectItem) {
        if (selectItem.isStar()) {
            if (selectItem.getAllOperationsInSchemaNameSpace() == null) {
                return "*";
            }
            return selectItem.getAllOperationsInSchemaNameSpace().getFullQualifiedNameAsString() + ".*";
        }
        StringBuilder tmp = new StringBuilder();
        for (UriResource resourcePart : selectItem.getResourcePath().getUriResourceParts()) {
            if (tmp.length() > 0) {
                tmp.append('/');
            }
            tmp.append(resourcePart.toString());
        }
        return tmp.toString();
    }

    private void appendSearchJson(JsonGenerator json, SearchExpression searchExpression) throws IOException {
        json.writeStartObject();
        if (searchExpression.isSearchTerm()) {
            json.writeStringField("nodeType", "searchTerm");
            json.writeStringField("searchTerm", searchExpression.asSearchTerm().getSearchTerm());
        } else if (searchExpression.isSearchBinary()) {
            json.writeStringField("nodeType", "binary");
            json.writeStringField("operator", searchExpression.asSearchBinary().getOperator().toString());
            json.writeFieldName("left");
            this.appendSearchJson(json, searchExpression.asSearchBinary().getLeftOperand());
            json.writeFieldName("right");
            this.appendSearchJson(json, searchExpression.asSearchBinary().getRightOperand());
        } else if (searchExpression.isSearchUnary()) {
            json.writeStringField("nodeType", "unary");
            json.writeStringField("operator", searchExpression.asSearchUnary().getOperator().toString());
            json.writeFieldName("operand");
            this.appendSearchJson(json, searchExpression.asSearchUnary().getOperand());
        }
        json.writeEndObject();
    }

    private void appendApplyItemsJson(JsonGenerator json, List<ApplyItem> applyItems) throws IOException {
        json.writeStartArray();
        for (ApplyItem item : applyItems) {
            this.appendApplyItemJson(json, item);
        }
        json.writeEndArray();
    }

    private void appendApplyItemJson(JsonGenerator json, ApplyItem item) throws IOException {
        json.writeStartObject();
        json.writeStringField("kind", item.getKind().name());
        switch (item.getKind()) {
            case AGGREGATE: {
                this.appendAggregateJson(json, (Aggregate)item);
                break;
            }
            case BOTTOM_TOP: {
                json.writeStringField("method", ((BottomTop)item).getMethod().name());
                json.writeFieldName("number");
                this.appendExpressionJson(json, ((BottomTop)item).getNumber());
                json.writeFieldName("value");
                this.appendExpressionJson(json, ((BottomTop)item).getValue());
                break;
            }
            case COMPUTE: {
                json.writeFieldName("compute");
                json.writeStartArray();
                for (ComputeExpression computeExpression : ((Compute)item).getExpressions()) {
                    json.writeStartObject();
                    json.writeFieldName("expression");
                    this.appendExpressionJson(json, computeExpression.getExpression());
                    json.writeStringField("as", computeExpression.getAlias());
                    json.writeEndObject();
                }
                json.writeEndArray();
                break;
            }
            case CONCAT: {
                json.writeFieldName("concat");
                json.writeStartArray();
                for (ApplyOption option : ((Concat)item).getApplyOptions()) {
                    this.appendApplyItemsJson(json, option.getApplyItems());
                }
                json.writeEndArray();
                break;
            }
            case CUSTOM_FUNCTION: {
                json.writeStringField("name", ((CustomFunction)item).getFunction().getFullQualifiedName().getFullQualifiedNameAsString());
                this.appendParameters(json, "parameters", ((CustomFunction)item).getParameters());
                break;
            }
            case EXPAND: {
                this.appendCommonJsonObjects(json, null, null, null, null, null, null, ((Expand)item).getExpandOption(), null, null);
                break;
            }
            case FILTER: {
                this.appendCommonJsonObjects(json, null, null, null, ((Filter)item).getFilterOption(), null, null, null, null, null);
                break;
            }
            case GROUP_BY: {
                json.writeFieldName("groupBy");
                this.appendGroupByItemsJson(json, ((GroupBy)item).getGroupByItems());
                this.appendCommonJsonObjects(json, null, null, null, null, null, null, null, null, ((GroupBy)item).getApplyOption());
                break;
            }
            case IDENTITY: {
                break;
            }
            case SEARCH: {
                this.appendCommonJsonObjects(json, null, null, null, null, null, null, null, ((Search)item).getSearchOption(), null);
            }
        }
        json.writeEndObject();
    }

    private void appendGroupByItemsJson(JsonGenerator json, List<GroupByItem> groupByItems) throws IOException {
        json.writeStartArray();
        for (GroupByItem groupByItem : groupByItems) {
            json.writeStartObject();
            if (!groupByItem.getPath().isEmpty()) {
                json.writeFieldName("path");
                this.appendURIResourceParts(json, groupByItem.getPath());
            }
            json.writeBooleanField("isRollupAll", groupByItem.isRollupAll());
            if (!groupByItem.getRollup().isEmpty()) {
                json.writeFieldName("rollup");
                this.appendGroupByItemsJson(json, groupByItem.getRollup());
            }
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void appendAggregateJson(JsonGenerator json, Aggregate aggregate) throws IOException {
        json.writeFieldName("aggregate");
        this.appendAggregateExpressionsJson(json, aggregate.getExpressions());
    }

    private void appendAggregateExpressionsJson(JsonGenerator json, List<AggregateExpression> aggregateExpressions) throws IOException {
        json.writeStartArray();
        for (AggregateExpression aggregateExpression : aggregateExpressions) {
            this.appendAggregateExpressionJson(json, aggregateExpression);
        }
        json.writeEndArray();
    }

    private void appendAggregateExpressionJson(JsonGenerator json, AggregateExpression aggregateExpression) throws IOException {
        if (aggregateExpression == null) {
            json.writeNull();
        } else {
            json.writeStartObject();
            if (!aggregateExpression.getPath().isEmpty()) {
                json.writeFieldName("path");
                this.appendURIResourceParts(json, aggregateExpression.getPath());
            }
            if (aggregateExpression.getExpression() != null) {
                json.writeFieldName("expression");
                this.appendExpressionJson(json, aggregateExpression.getExpression());
            }
            if (aggregateExpression.getStandardMethod() != null) {
                json.writeStringField("standardMethod", aggregateExpression.getStandardMethod().name());
            }
            if (aggregateExpression.getCustomMethod() != null) {
                json.writeStringField("customMethod", aggregateExpression.getCustomMethod().getFullQualifiedNameAsString());
            }
            if (aggregateExpression.getAlias() != null) {
                json.writeStringField("as", aggregateExpression.getAlias());
            }
            if (aggregateExpression.getInlineAggregateExpression() != null) {
                json.writeFieldName("inlineAggregateExpression");
                this.appendAggregateExpressionJson(json, aggregateExpression.getInlineAggregateExpression());
            }
            if (!aggregateExpression.getFrom().isEmpty()) {
                json.writeFieldName("from");
                this.appendAggregateExpressionsJson(json, aggregateExpression.getFrom());
            }
            json.writeEndObject();
        }
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        Object json;
        JsonFactory jsonFactory = new ObjectMapper().getFactory();
        if (this.uriInfo.getKind() == UriInfoKind.resource) {
            writer.append("<h2>Resource Path</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            Throwable throwable = null;
            try {
                this.appendURIResourceParts((JsonGenerator)json, this.uriInfo.getUriResourceParts());
                json.close();
                writer.append("\n</li>\n</ul>\n");
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            finally {
                if (json != null) {
                    if (throwable != null) {
                        try {
                            json.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        json.close();
                    }
                }
            }
        } else if (this.uriInfo.getKind() == UriInfoKind.crossjoin) {
            writer.append("<h2>Crossjoin EntitySet Names</h2>\n").append("<ul>\n");
            for (String string : this.uriInfo.asUriInfoCrossjoin().getEntitySetNames()) {
                writer.append("<li>").append(string).append("</li>\n");
            }
            writer.append("</ul>\n");
        } else {
            writer.append("<h2>Kind</h2>\n<p>").append(this.uriInfo.getKind().name()).append("</p>\n");
            if (this.uriInfo.getKind() == UriInfoKind.entityId && this.uriInfo.asUriInfoEntityId().getEntityTypeCast() != null) {
                writer.append("<h2>Type Cast</h2>\n<p>").append(this.uriInfo.asUriInfoEntityId().getEntityTypeCast().getFullQualifiedName().getFullQualifiedNameAsString()).append("</p>\n");
            }
        }
        if (this.uriInfo.getSearchOption() != null) {
            writer.append("<h2>Search Option</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            Throwable throwable = null;
            try {
                this.appendSearchJson((JsonGenerator)json, this.uriInfo.getSearchOption().getSearchExpression());
                json.close();
                writer.append("\n</li>\n</ul>\n");
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throw throwable5;
            }
            finally {
                if (json != null) {
                    if (throwable != null) {
                        try {
                            json.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        json.close();
                    }
                }
            }
        }
        if (this.uriInfo.getFilterOption() != null) {
            writer.append("<h2>Filter Option</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            Throwable throwable = null;
            try {
                this.appendExpressionJson((JsonGenerator)json, this.uriInfo.getFilterOption().getExpression());
                json.close();
                writer.append("\n</li>\n</ul>\n");
            }
            catch (Throwable throwable8) {
                Throwable throwable9 = throwable8;
                throw throwable8;
            }
            finally {
                if (json != null) {
                    if (throwable != null) {
                        try {
                            json.close();
                        }
                        catch (Throwable throwable10) {
                            throwable.addSuppressed(throwable10);
                        }
                    } else {
                        json.close();
                    }
                }
            }
        }
        if (this.uriInfo.getOrderByOption() != null) {
            writer.append("<h2>OrderBy Option</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            Throwable throwable = null;
            try {
                this.appendOrderByItemsJson((JsonGenerator)json, this.uriInfo.getOrderByOption().getOrders());
                json.close();
                writer.append("\n</li>\n</ul>\n");
            }
            catch (Throwable throwable11) {
                Throwable throwable12 = throwable11;
                throw throwable11;
            }
            finally {
                if (json != null) {
                    if (throwable != null) {
                        try {
                            json.close();
                        }
                        catch (Throwable throwable13) {
                            throwable.addSuppressed(throwable13);
                        }
                    } else {
                        json.close();
                    }
                }
            }
        }
        if (this.uriInfo.getExpandOption() != null) {
            writer.append("<h2>Expand Option</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            Throwable throwable = null;
            try {
                this.appendExpandedPropertiesJson((JsonGenerator)json, this.uriInfo.getExpandOption().getExpandItems());
                json.close();
                writer.append("\n</li>\n</ul>\n");
            }
            catch (Throwable throwable14) {
                Throwable throwable15 = throwable14;
                throw throwable14;
            }
            finally {
                if (json != null) {
                    if (throwable != null) {
                        try {
                            json.close();
                        }
                        catch (Throwable throwable16) {
                            throwable.addSuppressed(throwable16);
                        }
                    } else {
                        json.close();
                    }
                }
            }
        }
        if (this.uriInfo.getSelectOption() != null) {
            writer.append("<h2>Selected Properties</h2>\n").append("<ul>\n");
            for (SelectItem selectItem : this.uriInfo.getSelectOption().getSelectItems()) {
                writer.append("<li>").append(this.getSelectString(selectItem)).append("</li>\n");
            }
            writer.append("</ul>\n");
        }
        if (this.uriInfo.getApplyOption() != null) {
            writer.append("<h2>Apply Option</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            Throwable throwable = null;
            try {
                this.appendApplyItemsJson((JsonGenerator)json, this.uriInfo.getApplyOption().getApplyItems());
                json.close();
                writer.append("\n</li>\n</ul>\n");
            }
            catch (Throwable throwable17) {
                Throwable throwable18 = throwable17;
                throw throwable17;
            }
            finally {
                if (json != null) {
                    if (throwable != null) {
                        try {
                            json.close();
                        }
                        catch (Throwable throwable19) {
                            throwable.addSuppressed(throwable19);
                        }
                    } else {
                        json.close();
                    }
                }
            }
        }
        if (this.uriInfo.getCountOption() != null || this.uriInfo.getSkipOption() != null || this.uriInfo.getSkipTokenOption() != null || this.uriInfo.getTopOption() != null || this.uriInfo.getFormatOption() != null || this.uriInfo.getIdOption() != null) {
            writer.append("<h2>Unstructured System Query Options</h2>\n");
            DebugResponseHelperImpl.appendHtmlTable(writer, this.getQueryOptionsMap(Arrays.asList(this.uriInfo.getCountOption(), this.uriInfo.getSkipOption(), this.uriInfo.getSkipTokenOption(), this.uriInfo.getTopOption(), this.uriInfo.getFormatOption(), this.uriInfo.getIdOption())));
        }
        if (!this.uriInfo.getAliases().isEmpty()) {
            writer.append("<h2>Aliases</h2>\n");
            DebugResponseHelperImpl.appendHtmlTable(writer, this.getQueryOptionsMap(this.uriInfo.getAliases()));
        }
        if (!this.uriInfo.getCustomQueryOptions().isEmpty()) {
            writer.append("<h2>Custom Query Options</h2>\n");
            DebugResponseHelperImpl.appendHtmlTable(writer, this.getQueryOptionsMap(this.uriInfo.getCustomQueryOptions()));
        }
    }

    private Map<String, String> getQueryOptionsMap(List<? extends QueryOption> queryOptions) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (QueryOption queryOption : queryOptions) {
            if (queryOption == null) continue;
            options.put(queryOption.getName(), queryOption.getText());
        }
        return options;
    }
}

