/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.AbstractODataObject;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EdmAssistedSerializer;
import org.apache.olingo.server.api.serializer.EdmAssistedSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;

public class EdmAssistedJsonSerializer
implements EdmAssistedSerializer {
    protected final boolean isIEEE754Compatible;
    protected final boolean isODataMetadataNone;
    protected final boolean isODataMetadataFull;

    public EdmAssistedJsonSerializer(ContentType contentType) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.isODataMetadataNone = ContentTypeHelper.isODataMetadataNone(contentType);
        this.isODataMetadataFull = ContentTypeHelper.isODataMetadataFull(contentType);
    }

    @Override
    public SerializerResult entityCollection(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollection entityCollection, EdmAssistedSerializerOptions options) throws SerializerException {
        return this.serialize(metadata, entityType, entityCollection, options == null ? null : options.getContextURL());
    }

    public SerializerResult entity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, EdmAssistedSerializerOptions options) throws SerializerException {
        return this.serialize(metadata, entityType, entity, options == null ? null : options.getContextURL());
    }

    /*
     * Exception decompiling
     */
    protected SerializerResult serialize(ServiceMetadata metadata, EdmEntityType entityType, AbstractODataObject obj, ContextURL contextURL) throws SerializerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doSerialize(EdmEntityType entityType, AbstractEntityCollection entityCollection, String contextURLString, String metadataETag, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartObject();
        this.metadata(contextURLString, metadataETag, null, null, entityCollection.getId(), false, json);
        if (entityCollection.getCount() != null) {
            if (this.isIEEE754Compatible) {
                json.writeStringField("@odata.count", Integer.toString(entityCollection.getCount()));
            } else {
                json.writeNumberField("@odata.count", entityCollection.getCount().intValue());
            }
        }
        if (entityCollection.getDeltaLink() != null) {
            json.writeStringField("@odata.deltaLink", entityCollection.getDeltaLink().toASCIIString());
        }
        for (Annotation annotation : entityCollection.getAnnotations()) {
            this.valuable(json, annotation, '@' + annotation.getTerm(), null, null);
        }
        json.writeArrayFieldStart("value");
        if (entityCollection instanceof AbstractEntityCollection) {
            AbstractEntityCollection entities = entityCollection;
            for (Entity entity : entities) {
                this.doSerialize(entityType, entity, null, null, json);
            }
        }
        json.writeEndArray();
        if (entityCollection.getNext() != null) {
            json.writeStringField("@odata.nextLink", entityCollection.getNext().toASCIIString());
        }
        json.writeEndObject();
    }

    protected void doSerialize(EdmEntityType entityType, Entity entity, String contextURLString, String metadataETag, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartObject();
        String typeName = entity.getType() == null ? null : new EdmTypeInfo.Builder().setTypeExpression(entity.getType()).build().external();
        this.metadata(contextURLString, metadataETag, entity.getETag(), typeName, entity.getId(), true, json);
        for (Annotation annotation : entity.getAnnotations()) {
            this.valuable(json, annotation, '@' + annotation.getTerm(), null, null);
        }
        for (Property property : entity.getProperties()) {
            String name = property.getName();
            EdmProperty edmProperty = entityType == null || entityType.getStructuralProperty(name) == null ? null : entityType.getStructuralProperty(name);
            this.valuable(json, property, name, edmProperty == null ? null : edmProperty.getType(), edmProperty);
        }
        if (!this.isODataMetadataNone && entity.getEditLink() != null && entity.getEditLink().getHref() != null) {
            json.writeStringField("@odata.editLink", entity.getEditLink().getHref());
            if (entity.isMediaEntity()) {
                json.writeStringField("@odata.mediaReadLink", entity.getEditLink().getHref() + "/$value");
            }
        }
        this.links(entity, entityType, json);
        json.writeEndObject();
    }

    private void metadata(String contextURLString, String metadataETag, String eTag, String type, URI id, boolean writeNullId, JsonGenerator json) throws IOException, SerializerException {
        if (!this.isODataMetadataNone) {
            if (contextURLString != null) {
                json.writeStringField("@odata.context", contextURLString);
            }
            if (metadataETag != null) {
                json.writeStringField("@odata.metadataEtag", metadataETag);
            }
            if (eTag != null) {
                json.writeStringField("@odata.etag", eTag);
            }
            if (this.isODataMetadataFull) {
                if (type != null) {
                    json.writeStringField("@odata.type", type);
                }
                if (id == null) {
                    if (writeNullId) {
                        json.writeNullField("@odata.id");
                    }
                } else {
                    json.writeStringField("@odata.id", id.toASCIIString());
                }
            }
        }
    }

    private void links(Linked linked, EdmEntityType entityType, JsonGenerator json) throws IOException, SerializerException {
        for (Link link : linked.getNavigationLinks()) {
            EdmEntityType targetType;
            String name = link.getTitle();
            for (Annotation annotation : link.getAnnotations()) {
                this.valuable(json, annotation, name + '@' + annotation.getTerm(), null, null);
            }
            EdmEntityType edmEntityType = targetType = entityType == null || name == null || entityType.getNavigationProperty(name) == null ? null : entityType.getNavigationProperty(name).getType();
            if (link.getInlineEntity() != null) {
                json.writeFieldName(name);
                this.doSerialize(targetType, link.getInlineEntity(), null, null, json);
                continue;
            }
            if (link.getInlineEntitySet() == null) continue;
            json.writeArrayFieldStart(name);
            for (Entity subEntry : link.getInlineEntitySet().getEntities()) {
                this.doSerialize(targetType, subEntry, null, null, json);
            }
            json.writeEndArray();
        }
    }

    private void collection(JsonGenerator json, EdmType itemType, String typeName, EdmProperty edmProperty, ValueType valueType, List<?> value) throws IOException, SerializerException {
        json.writeStartArray();
        for (Object item : value) {
            switch (valueType) {
                case COLLECTION_PRIMITIVE: {
                    this.primitiveValue(json, (EdmPrimitiveType)itemType, typeName, edmProperty, item);
                    break;
                }
                case COLLECTION_GEOSPATIAL: 
                case COLLECTION_ENUM: {
                    throw new SerializerException("Geo and enum types are not supported.", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
                }
                case COLLECTION_COMPLEX: {
                    this.complexValue(json, (EdmComplexType)itemType, typeName, (ComplexValue)item);
                    break;
                }
            }
        }
        json.writeEndArray();
    }

    protected void primitiveValue(JsonGenerator json, EdmPrimitiveType valueType, String typeName, EdmProperty edmProperty, Object value) throws IOException, SerializerException {
        EdmPrimitiveType type = valueType;
        if (type == null) {
            EdmPrimitiveTypeKind kind = typeName == null ? EdmTypeInfo.determineTypeKind(value) : new EdmTypeInfo.Builder().setTypeExpression(typeName).build().getPrimitiveTypeKind();
            EdmPrimitiveType edmPrimitiveType = type = kind == null ? null : EdmPrimitiveTypeFactory.getInstance(kind);
        }
        if (value == null) {
            json.writeNull();
        } else {
            if (type == null) {
                throw new SerializerException("The primitive type could not be determined.", SerializerException.MessageKeys.INCONSISTENT_PROPERTY_TYPE, "");
            }
            if (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Boolean)) {
                json.writeBoolean(((Boolean)value).booleanValue());
            } else {
                String serialized = null;
                try {
                    serialized = type.valueToString(value, edmProperty == null ? null : Boolean.valueOf(edmProperty.isNullable()), edmProperty == null ? null : edmProperty.getMaxLength(), edmProperty == null ? Constants.DEFAULT_PRECISION : edmProperty.getPrecision(), edmProperty == null ? Constants.DEFAULT_SCALE : edmProperty.getScale(), edmProperty == null ? null : Boolean.valueOf(edmProperty.isUnicode()));
                }
                catch (EdmPrimitiveTypeException e) {
                    String name = edmProperty == null ? "" : edmProperty.getName();
                    throw new SerializerException("Wrong value for property '" + name + "'!", (Throwable)e, SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, name, value.toString());
                }
                if (this.isIEEE754Compatible && (type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int64) || type == EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Decimal)) || type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Byte) && type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.SByte) && type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Single) && type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Double) && type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int16) && type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int32) && type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Int64) && type != EdmPrimitiveTypeFactory.getInstance(EdmPrimitiveTypeKind.Decimal)) {
                    json.writeString(serialized);
                } else {
                    json.writeNumber(serialized);
                }
            }
        }
    }

    private void complexValue(JsonGenerator json, EdmComplexType valueType, String typeName, ComplexValue value) throws IOException, SerializerException {
        json.writeStartObject();
        if (typeName != null && this.isODataMetadataFull) {
            json.writeStringField("@odata.type", typeName);
        }
        for (Property property : value.getValue()) {
            String name = property.getName();
            EdmProperty edmProperty = valueType == null || valueType.getStructuralProperty(name) == null ? null : valueType.getStructuralProperty(name);
            this.valuable(json, property, name, edmProperty == null ? null : edmProperty.getType(), edmProperty);
        }
        this.links(value, null, json);
        json.writeEndObject();
    }

    private void value(JsonGenerator json, Valuable value, EdmType type, EdmProperty edmProperty) throws IOException, SerializerException {
        String typeName;
        String string = typeName = value.getType() == null ? null : new EdmTypeInfo.Builder().setTypeExpression(value.getType()).build().external();
        if (value.isNull()) {
            json.writeNull();
        } else if (value.isCollection()) {
            this.collection(json, type, typeName, edmProperty, value.getValueType(), value.asCollection());
        } else if (value.isPrimitive()) {
            this.primitiveValue(json, (EdmPrimitiveType)type, typeName, edmProperty, value.asPrimitive());
        } else if (value.isComplex()) {
            this.complexValue(json, (EdmComplexType)type, typeName, value.asComplex());
        } else if (value.isEnum() || value.isGeospatial()) {
            throw new SerializerException("Geo and enum types are not supported.", SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
    }

    protected void valuable(JsonGenerator json, Valuable valuable, String name, EdmType type, EdmProperty edmProperty) throws IOException, SerializerException {
        if (this.isODataMetadataFull && !(valuable instanceof Annotation) && !valuable.isComplex()) {
            String typeName = valuable.getType();
            if (typeName == null && type == null && valuable.isPrimitive()) {
                EdmPrimitiveTypeKind kind;
                if (valuable.isCollection()) {
                    if (!valuable.asCollection().isEmpty() && (kind = EdmTypeInfo.determineTypeKind(valuable.asCollection().get(0))) != null) {
                        typeName = "Collection(" + kind.getFullQualifiedName().getFullQualifiedNameAsString() + ')';
                    }
                } else {
                    kind = EdmTypeInfo.determineTypeKind(valuable.asPrimitive());
                    if (kind != null) {
                        typeName = kind.getFullQualifiedName().getFullQualifiedNameAsString();
                    }
                }
            }
            if (typeName != null) {
                json.writeStringField(name + "@odata.type", this.constructTypeExpression(typeName));
            }
        }
        for (Annotation annotation : valuable.getAnnotations()) {
            this.valuable(json, annotation, name + '@' + annotation.getTerm(), null, null);
        }
        json.writeFieldName(name);
        this.value(json, valuable, type, edmProperty);
    }

    private String constructTypeExpression(String typeName) {
        EdmTypeInfo typeInfo = new EdmTypeInfo.Builder().setTypeExpression(typeName).build();
        StringBuilder stringBuilder = new StringBuilder();
        if (typeInfo.isCollection()) {
            stringBuilder.append("#Collection(");
        } else {
            stringBuilder.append('#');
        }
        stringBuilder.append(typeInfo.isPrimitiveType() ? typeInfo.getFullQualifiedName().getName() : typeInfo.getFullQualifiedName().getFullQualifiedNameAsString());
        if (typeInfo.isCollection()) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

