/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmAnnotatable;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmMember;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.TargetType;
import org.apache.olingo.commons.api.edm.annotation.EdmApply;
import org.apache.olingo.commons.api.edm.annotation.EdmCast;
import org.apache.olingo.commons.api.edm.annotation.EdmConstantExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmDynamicExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmIf;
import org.apache.olingo.commons.api.edm.annotation.EdmIsOf;
import org.apache.olingo.commons.api.edm.annotation.EdmLabeledElement;
import org.apache.olingo.commons.api.edm.annotation.EdmLabeledElementReference;
import org.apache.olingo.commons.api.edm.annotation.EdmLogicalOrComparisonExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmNavigationPropertyPath;
import org.apache.olingo.commons.api.edm.annotation.EdmNot;
import org.apache.olingo.commons.api.edm.annotation.EdmNull;
import org.apache.olingo.commons.api.edm.annotation.EdmPath;
import org.apache.olingo.commons.api.edm.annotation.EdmPropertyPath;
import org.apache.olingo.commons.api.edm.annotation.EdmPropertyValue;
import org.apache.olingo.commons.api.edm.annotation.EdmRecord;
import org.apache.olingo.commons.api.edm.annotation.EdmUrlRef;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edmx.EdmxReference;
import org.apache.olingo.commons.api.edmx.EdmxReferenceInclude;
import org.apache.olingo.commons.api.edmx.EdmxReferenceIncludeAnnotation;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.Kind;
import org.apache.olingo.server.api.serializer.SerializerException;

public class MetadataDocumentJsonSerializer {
    private final ServiceMetadata serviceMetadata;
    private final Map<String, String> namespaceToAlias = new HashMap<String, String>();
    private static final String DOLLAR = "$";
    private static final String VERSION = "$Version";
    private static final String REFERENCES = "$Reference";
    private static final String INCLUDE = "$Include";
    private static final String NAMESPACE = "$Namespace";
    private static final String ALIAS = "$Alias";
    private static final String INCLUDE_ANNOTATIONS = "$IncludeAnnotations";
    private static final String TERM_NAMESPACE = "$TermNamespace";
    private static final String TARGET_NAMESPACE = "$TargetNamespace";
    private static final String QUALIFIER = "$Qualifier";
    private static final String IS_FLAGS = "$IsFlags";
    private static final String UNDERLYING_TYPE = "$UnderlyingType";
    private static final String KIND = "$Kind";
    private static final String MAX_LENGTH = "$MaxLength";
    private static final String PRECISION = "$Precision";
    private static final String SCALE = "$Scale";
    private static final String SRID = "$SRID";
    private static final String COLLECTION = "$Collection";
    private static final String BASE_TYPE = "$BaseType";
    private static final String HAS_STREAM = "$HasStream";
    private static final String KEY = "$Key";
    private static final String ABSTRACT = "$Abstract";
    private static final String TYPE = "$Type";
    private static final String NULLABLE = "$Nullable";
    private static final String UNICODE = "$Unicode";
    private static final String DEFAULT_VALUE = "$DefaultValue";
    private static final String PARTNER = "$Partner";
    private static final String CONTAINS_TARGET = "$ContainsTarget";
    private static final String REFERENTIAL_CONSTRAINT = "$ReferentialConstraint";
    private static final String ISBOUND = "$IsBound";
    private static final String ENTITY_SET_PATH = "$EntitySetPath";
    private static final String PARAMETER = "$Parameter";
    private static final String RETURN_TYPE = "$ReturnType";
    private static final String ISCOMPOSABLE = "$IsComposable";
    private static final String PARAMETER_NAME = "$Name";
    private static final String BASE_TERM = "$BaseTerm";
    private static final String APPLIES_TO = "$AppliesTo";
    private static final String NAVIGATION_PROPERTY_BINDING = "$NavigationPropertyBinding";
    private static final String EXTENDS = "$Extends";
    private static final String INCLUDE_IN_SERV_DOC = "$IncludeInServiceDocument";
    private static final String ANNOTATION = "$Annotations";
    private static final String ANNOTATION_PATH = "$Path";
    private static final String NAME = "$Name";

    public MetadataDocumentJsonSerializer(ServiceMetadata serviceMetadata) throws SerializerException {
        if (serviceMetadata == null || serviceMetadata.getEdm() == null) {
            throw new SerializerException("Service Metadata and EDM must not be null for a service.", SerializerException.MessageKeys.NULL_METADATA_OR_EDM, new String[0]);
        }
        this.serviceMetadata = serviceMetadata;
    }

    public void writeMetadataDocument(JsonGenerator json) throws SerializerException, IOException {
        json.writeStartObject();
        json.writeStringField(VERSION, "4.01");
        if (!this.serviceMetadata.getReferences().isEmpty()) {
            this.appendReference(json);
        }
        this.appendDataServices(json);
        json.writeEndObject();
    }

    private void appendDataServices(JsonGenerator json) throws SerializerException, IOException {
        for (EdmSchema schema : this.serviceMetadata.getEdm().getSchemas()) {
            this.appendSchema(json, schema);
        }
    }

    private void appendSchema(JsonGenerator json, EdmSchema schema) throws SerializerException, IOException {
        json.writeFieldName(schema.getNamespace());
        json.writeStartObject();
        if (schema.getAlias() != null) {
            json.writeStringField(ALIAS, schema.getAlias());
            this.namespaceToAlias.put(schema.getNamespace(), schema.getAlias());
        }
        this.appendEnumTypes(json, schema.getEnumTypes());
        this.appendTypeDefinitions(json, schema.getTypeDefinitions());
        this.appendEntityTypes(json, schema.getEntityTypes());
        this.appendComplexTypes(json, schema.getComplexTypes());
        this.appendActions(json, schema.getActions());
        this.appendFunctions(json, schema.getFunctions());
        this.appendTerms(json, schema.getTerms());
        this.appendEntityContainer(json, schema.getEntityContainer());
        this.appendAnnotationGroups(json, schema.getAnnotationGroups());
        this.appendAnnotations(json, schema, null);
        json.writeEndObject();
    }

    private void appendAnnotationGroups(JsonGenerator json, List<EdmAnnotations> annotationGroups) throws SerializerException, IOException {
        if (!annotationGroups.isEmpty()) {
            json.writeObjectFieldStart(ANNOTATION);
        }
        for (EdmAnnotations annotationGroup : annotationGroups) {
            this.appendAnnotationGroup(json, annotationGroup);
        }
        if (!annotationGroups.isEmpty()) {
            json.writeEndObject();
        }
    }

    private void appendAnnotationGroup(JsonGenerator json, EdmAnnotations annotationGroup) throws SerializerException, IOException {
        String targetPath = annotationGroup.getTargetPath();
        if (annotationGroup.getQualifier() != null) {
            json.writeObjectFieldStart(targetPath + "#" + annotationGroup.getQualifier());
        } else {
            json.writeObjectFieldStart(targetPath);
        }
        this.appendAnnotations(json, annotationGroup, null);
        json.writeEndObject();
    }

    private void appendEntityContainer(JsonGenerator json, EdmEntityContainer container) throws SerializerException, IOException {
        if (container != null) {
            json.writeObjectFieldStart(container.getName());
            json.writeStringField(KIND, Kind.EntityContainer.name());
            FullQualifiedName parentContainerName = container.getParentContainerName();
            if (parentContainerName != null) {
                String parentContainerNameString = this.namespaceToAlias.get(parentContainerName.getNamespace()) != null ? this.namespaceToAlias.get(parentContainerName.getNamespace()) + "." + parentContainerName.getName() : parentContainerName.getFullQualifiedNameAsString();
                json.writeObjectFieldStart(Kind.Extending.name());
                json.writeStringField(KIND, Kind.EntityContainer.name());
                json.writeStringField(EXTENDS, parentContainerNameString);
                json.writeEndObject();
            }
            this.appendEntitySets(json, container.getEntitySets());
            String containerNamespace = this.namespaceToAlias.get(container.getNamespace()) != null ? this.namespaceToAlias.get(container.getNamespace()) : container.getNamespace();
            this.appendActionImports(json, container.getActionImports(), containerNamespace);
            this.appendFunctionImports(json, container.getFunctionImports(), containerNamespace);
            this.appendSingletons(json, container.getSingletons());
            this.appendAnnotations(json, container, null);
            json.writeEndObject();
        }
    }

    private void appendSingletons(JsonGenerator json, List<EdmSingleton> singletons) throws SerializerException, IOException {
        for (EdmSingleton singleton : singletons) {
            json.writeObjectFieldStart(singleton.getName());
            json.writeStringField(KIND, Kind.Singleton.name());
            json.writeStringField(TYPE, this.getAliasedFullQualifiedName(singleton.getEntityType()));
            this.appendNavigationPropertyBindings(json, singleton);
            this.appendAnnotations(json, singleton, null);
            json.writeEndObject();
        }
    }

    private void appendFunctionImports(JsonGenerator json, List<EdmFunctionImport> functionImports, String containerNamespace) throws SerializerException, IOException {
        for (EdmFunctionImport functionImport : functionImports) {
            json.writeObjectFieldStart(functionImport.getName());
            json.writeStringField(KIND, Kind.FunctionImport.name());
            FullQualifiedName functionFqn = functionImport.getFunctionFqn();
            String functionFQNString = this.namespaceToAlias.get(functionFqn.getNamespace()) != null ? this.namespaceToAlias.get(functionFqn.getNamespace()) + "." + functionFqn.getName() : functionFqn.getFullQualifiedNameAsString();
            json.writeStringField(DOLLAR + Kind.Function.name(), functionFQNString);
            EdmEntitySet returnedEntitySet = functionImport.getReturnedEntitySet();
            if (returnedEntitySet != null) {
                json.writeStringField(DOLLAR + Kind.EntitySet.name(), containerNamespace + "." + returnedEntitySet.getName());
            }
            if (functionImport.isIncludeInServiceDocument()) {
                json.writeBooleanField(INCLUDE_IN_SERV_DOC, functionImport.isIncludeInServiceDocument());
            }
            this.appendAnnotations(json, functionImport, null);
            json.writeEndObject();
        }
    }

    private void appendActionImports(JsonGenerator json, List<EdmActionImport> actionImports, String containerNamespace) throws SerializerException, IOException {
        for (EdmActionImport actionImport : actionImports) {
            json.writeObjectFieldStart(actionImport.getName());
            json.writeStringField(KIND, Kind.ActionImport.name());
            json.writeStringField(DOLLAR + Kind.Action.name(), this.getAliasedFullQualifiedName(actionImport.getUnboundAction()));
            if (actionImport.getReturnedEntitySet() != null) {
                json.writeStringField(DOLLAR + Kind.EntitySet.name(), containerNamespace + "." + actionImport.getReturnedEntitySet().getName());
            }
            this.appendAnnotations(json, actionImport, null);
            json.writeEndObject();
        }
    }

    private void appendEntitySets(JsonGenerator json, List<EdmEntitySet> entitySets) throws SerializerException, IOException {
        for (EdmEntitySet entitySet : entitySets) {
            json.writeObjectFieldStart(entitySet.getName());
            json.writeStringField(KIND, Kind.EntitySet.name());
            json.writeStringField(TYPE, this.getAliasedFullQualifiedName(entitySet.getEntityType()));
            if (!entitySet.isIncludeInServiceDocument()) {
                json.writeBooleanField(INCLUDE_IN_SERV_DOC, entitySet.isIncludeInServiceDocument());
            }
            this.appendNavigationPropertyBindings(json, entitySet);
            this.appendAnnotations(json, entitySet, null);
            json.writeEndObject();
        }
    }

    private void appendNavigationPropertyBindings(JsonGenerator json, EdmBindingTarget bindingTarget) throws SerializerException, IOException {
        if (bindingTarget.getNavigationPropertyBindings() != null && !bindingTarget.getNavigationPropertyBindings().isEmpty()) {
            json.writeObjectFieldStart(NAVIGATION_PROPERTY_BINDING);
            for (EdmNavigationPropertyBinding binding : bindingTarget.getNavigationPropertyBindings()) {
                json.writeStringField(binding.getPath(), binding.getTarget());
            }
            json.writeEndObject();
        }
    }

    private void appendTerms(JsonGenerator json, List<EdmTerm> terms) throws SerializerException, IOException {
        for (EdmTerm term : terms) {
            json.writeObjectFieldStart(term.getName());
            json.writeStringField(KIND, Kind.Term.name());
            json.writeStringField(TYPE, this.getAliasedFullQualifiedName(term.getType()));
            if (term.getBaseTerm() != null) {
                json.writeStringField(BASE_TERM, this.getAliasedFullQualifiedName(term.getBaseTerm().getFullQualifiedName()));
            }
            if (term.getAppliesTo() != null && !term.getAppliesTo().isEmpty()) {
                String appliesToString = "";
                boolean first = true;
                for (TargetType target : term.getAppliesTo()) {
                    if (first) {
                        first = false;
                        appliesToString = target.toString();
                        continue;
                    }
                    appliesToString = appliesToString + " " + target.toString();
                }
                json.writeStringField(APPLIES_TO, appliesToString);
            }
            if (!term.isNullable()) {
                json.writeBooleanField(NULLABLE, term.isNullable());
            }
            if (term.getDefaultValue() != null) {
                json.writeStringField(DEFAULT_VALUE, term.getDefaultValue());
            }
            if (term.getMaxLength() != null) {
                json.writeNumberField(MAX_LENGTH, term.getMaxLength().intValue());
            }
            if (term.getPrecision() != null) {
                json.writeNumberField(PRECISION, term.getPrecision().intValue());
            }
            if (term.getScale() != null) {
                json.writeNumberField(SCALE, term.getScale().intValue());
            }
            this.appendAnnotations(json, term, null);
            json.writeEndObject();
        }
    }

    private void appendFunctions(JsonGenerator json, List<EdmFunction> functions) throws SerializerException, IOException {
        HashMap<String, List> functionsMap = new HashMap<String, List>();
        for (EdmFunction edmFunction : functions) {
            if (functionsMap.containsKey(edmFunction.getName())) {
                List actionsWithSpecificActionName = (List)functionsMap.get(edmFunction.getName());
                actionsWithSpecificActionName.add(edmFunction);
                functionsMap.put(edmFunction.getName(), actionsWithSpecificActionName);
                continue;
            }
            ArrayList<EdmFunction> functionList = new ArrayList<EdmFunction>();
            functionList.add(edmFunction);
            functionsMap.put(edmFunction.getName(), functionList);
        }
        for (Map.Entry entry : functionsMap.entrySet()) {
            json.writeArrayFieldStart((String)entry.getKey());
            List functionEntry = (List)entry.getValue();
            for (EdmFunction function : functionEntry) {
                json.writeStartObject();
                json.writeStringField(KIND, Kind.Function.name());
                if (function.getEntitySetPath() != null) {
                    json.writeStringField(ENTITY_SET_PATH, function.getEntitySetPath());
                }
                if (function.isBound()) {
                    json.writeBooleanField(ISBOUND, function.isBound());
                }
                if (function.isComposable()) {
                    json.writeBooleanField(ISCOMPOSABLE, function.isComposable());
                }
                this.appendOperationParameters(json, function);
                this.appendOperationReturnType(json, function);
                this.appendAnnotations(json, function, null);
                json.writeEndObject();
            }
            json.writeEndArray();
        }
    }

    private void appendActions(JsonGenerator json, List<EdmAction> actions) throws SerializerException, IOException {
        HashMap<String, List> actionsMap = new HashMap<String, List>();
        for (EdmAction edmAction : actions) {
            if (actionsMap.containsKey(edmAction.getName())) {
                List actionsWithSpecificActionName = (List)actionsMap.get(edmAction.getName());
                actionsWithSpecificActionName.add(edmAction);
                actionsMap.put(edmAction.getName(), actionsWithSpecificActionName);
                continue;
            }
            ArrayList<EdmAction> actionList = new ArrayList<EdmAction>();
            actionList.add(edmAction);
            actionsMap.put(edmAction.getName(), actionList);
        }
        for (Map.Entry entry : actionsMap.entrySet()) {
            json.writeArrayFieldStart((String)entry.getKey());
            List actionEntry = (List)entry.getValue();
            for (EdmAction action : actionEntry) {
                json.writeStartObject();
                json.writeStringField(KIND, Kind.Action.name());
                if (action.getEntitySetPath() != null) {
                    json.writeStringField(ENTITY_SET_PATH, action.getEntitySetPath());
                }
                json.writeBooleanField(ISBOUND, action.isBound());
                this.appendOperationParameters(json, action);
                this.appendOperationReturnType(json, action);
                this.appendAnnotations(json, action, null);
                json.writeEndObject();
            }
            json.writeEndArray();
        }
    }

    private void appendOperationReturnType(JsonGenerator json, EdmOperation operation) throws SerializerException, IOException {
        EdmReturnType returnType = operation.getReturnType();
        if (returnType != null) {
            json.writeObjectFieldStart(RETURN_TYPE);
            String returnTypeFqnString = EdmTypeKind.PRIMITIVE.equals((Object)returnType.getType().getKind()) ? this.getFullQualifiedName(returnType.getType()) : this.getAliasedFullQualifiedName(returnType.getType());
            json.writeStringField(TYPE, returnTypeFqnString);
            if (returnType.isCollection()) {
                json.writeBooleanField(COLLECTION, returnType.isCollection());
            }
            this.appendReturnTypeFacets(json, returnType);
            json.writeEndObject();
        }
    }

    private void appendReturnTypeFacets(JsonGenerator json, EdmReturnType returnType) throws SerializerException, IOException {
        if (!returnType.isNullable()) {
            json.writeBooleanField(NULLABLE, returnType.isNullable());
        }
        if (returnType.getMaxLength() != null) {
            json.writeNumberField(MAX_LENGTH, returnType.getMaxLength().intValue());
        }
        if (returnType.getPrecision() != null) {
            json.writeNumberField(PRECISION, returnType.getPrecision().intValue());
        }
        if (returnType.getScale() != null) {
            json.writeNumberField(SCALE, returnType.getScale().intValue());
        }
    }

    private void appendOperationParameters(JsonGenerator json, EdmOperation operation) throws SerializerException, IOException {
        if (!operation.getParameterNames().isEmpty()) {
            json.writeArrayFieldStart(PARAMETER);
        }
        for (String parameterName : operation.getParameterNames()) {
            EdmParameter parameter = operation.getParameter(parameterName);
            json.writeStartObject();
            json.writeStringField("$Name", parameterName);
            String typeFqnString = EdmTypeKind.PRIMITIVE.equals((Object)parameter.getType().getKind()) ? this.getFullQualifiedName(parameter.getType()) : this.getAliasedFullQualifiedName(parameter.getType());
            json.writeStringField(TYPE, typeFqnString);
            if (parameter.isCollection()) {
                json.writeBooleanField(COLLECTION, parameter.isCollection());
            }
            this.appendParameterFacets(json, parameter);
            this.appendAnnotations(json, parameter, null);
            json.writeEndObject();
        }
        if (!operation.getParameterNames().isEmpty()) {
            json.writeEndArray();
        }
    }

    private void appendParameterFacets(JsonGenerator json, EdmParameter parameter) throws SerializerException, IOException {
        if (!parameter.isNullable()) {
            json.writeBooleanField(NULLABLE, parameter.isNullable());
        }
        if (parameter.getMaxLength() != null) {
            json.writeNumberField(MAX_LENGTH, parameter.getMaxLength().intValue());
        }
        if (parameter.getPrecision() != null) {
            json.writeNumberField(PRECISION, parameter.getPrecision().intValue());
        }
        if (parameter.getScale() != null) {
            json.writeNumberField(SCALE, parameter.getScale().intValue());
        }
    }

    private void appendComplexTypes(JsonGenerator json, List<EdmComplexType> complexTypes) throws SerializerException, IOException {
        for (EdmComplexType complexType : complexTypes) {
            json.writeObjectFieldStart(complexType.getName());
            json.writeStringField(KIND, Kind.ComplexType.name());
            if (complexType.getBaseType() != null) {
                json.writeStringField(BASE_TYPE, this.getAliasedFullQualifiedName(complexType.getBaseType()));
            }
            if (complexType.isAbstract()) {
                json.writeBooleanField(ABSTRACT, complexType.isAbstract());
            }
            this.appendProperties(json, complexType);
            this.appendNavigationProperties(json, complexType);
            this.appendAnnotations(json, complexType, null);
            json.writeEndObject();
        }
    }

    private void appendEntityTypes(JsonGenerator json, List<EdmEntityType> entityTypes) throws SerializerException, IOException {
        for (EdmEntityType entityType : entityTypes) {
            json.writeObjectFieldStart(entityType.getName());
            json.writeStringField(KIND, Kind.EntityType.name());
            if (entityType.hasStream()) {
                json.writeBooleanField(HAS_STREAM, entityType.hasStream());
            }
            if (entityType.getBaseType() != null) {
                json.writeStringField(BASE_TYPE, this.getAliasedFullQualifiedName(entityType.getBaseType()));
            }
            if (entityType.isAbstract()) {
                json.writeBooleanField(ABSTRACT, entityType.isAbstract());
            }
            this.appendKey(json, entityType);
            this.appendProperties(json, entityType);
            this.appendNavigationProperties(json, entityType);
            this.appendAnnotations(json, entityType, null);
            json.writeEndObject();
        }
    }

    private void appendNavigationProperties(JsonGenerator json, EdmStructuredType type) throws SerializerException, IOException {
        ArrayList<String> navigationPropertyNames = new ArrayList<String>(type.getNavigationPropertyNames());
        if (type.getBaseType() != null) {
            navigationPropertyNames.removeAll(type.getBaseType().getNavigationPropertyNames());
        }
        for (String navigationPropertyName : navigationPropertyNames) {
            EdmNavigationProperty navigationProperty = type.getNavigationProperty(navigationPropertyName);
            json.writeObjectFieldStart(navigationPropertyName);
            json.writeStringField(KIND, Kind.NavigationProperty.name());
            json.writeStringField(TYPE, this.getAliasedFullQualifiedName(navigationProperty.getType()));
            if (navigationProperty.isCollection()) {
                json.writeBooleanField(COLLECTION, navigationProperty.isCollection());
            }
            if (!navigationProperty.isNullable()) {
                json.writeBooleanField(NULLABLE, navigationProperty.isNullable());
            }
            if (navigationProperty.getPartner() != null) {
                EdmNavigationProperty partner = navigationProperty.getPartner();
                json.writeStringField(PARTNER, partner.getName());
            }
            if (navigationProperty.containsTarget()) {
                json.writeBooleanField(CONTAINS_TARGET, navigationProperty.containsTarget());
            }
            if (navigationProperty.getReferentialConstraints() != null) {
                for (EdmReferentialConstraint constraint : navigationProperty.getReferentialConstraints()) {
                    json.writeObjectFieldStart(REFERENTIAL_CONSTRAINT);
                    json.writeStringField(constraint.getPropertyName(), constraint.getReferencedPropertyName());
                    for (EdmAnnotation annotation : constraint.getAnnotations()) {
                        this.appendAnnotations(json, annotation, null);
                    }
                    json.writeEndObject();
                }
            }
            this.appendAnnotations(json, navigationProperty, null);
            json.writeEndObject();
        }
    }

    private void appendProperties(JsonGenerator json, EdmStructuredType type) throws SerializerException, IOException {
        ArrayList<String> propertyNames = new ArrayList<String>(type.getPropertyNames());
        if (type.getBaseType() != null) {
            propertyNames.removeAll(type.getBaseType().getPropertyNames());
        }
        for (String propertyName : propertyNames) {
            EdmProperty property = type.getStructuralProperty(propertyName);
            json.writeObjectFieldStart(propertyName);
            String fqnString = property.isPrimitive() ? this.getFullQualifiedName(property.getType()) : this.getAliasedFullQualifiedName(property.getType());
            json.writeStringField(TYPE, fqnString);
            if (property.isCollection()) {
                json.writeBooleanField(COLLECTION, property.isCollection());
            }
            if (!property.isNullable()) {
                json.writeBooleanField(NULLABLE, property.isNullable());
            }
            if (!property.isUnicode()) {
                json.writeBooleanField(UNICODE, property.isUnicode());
            }
            if (property.getDefaultValue() != null) {
                json.writeStringField(DEFAULT_VALUE, property.getDefaultValue());
            }
            if (property.getMaxLength() != null) {
                json.writeNumberField(MAX_LENGTH, property.getMaxLength().intValue());
            }
            if (property.getPrecision() != null) {
                json.writeNumberField(PRECISION, property.getPrecision().intValue());
            }
            if (property.getScale() != null) {
                json.writeNumberField(SCALE, property.getScale().intValue());
            }
            if (property.getSrid() != null) {
                json.writeStringField(SRID, "" + property.getSrid());
            }
            this.appendAnnotations(json, property, null);
            json.writeEndObject();
        }
    }

    private void appendKey(JsonGenerator json, EdmEntityType entityType) throws SerializerException, IOException {
        List<EdmKeyPropertyRef> keyPropertyRefs = entityType.getKeyPropertyRefs();
        if (keyPropertyRefs != null && !keyPropertyRefs.isEmpty()) {
            EdmEntityType baseType = entityType.getBaseType();
            if (baseType != null && baseType.getKeyPropertyRefs() != null && !baseType.getKeyPropertyRefs().isEmpty()) {
                return;
            }
            json.writeArrayFieldStart(KEY);
            for (EdmKeyPropertyRef keyRef : keyPropertyRefs) {
                if (keyRef.getAlias() != null) {
                    json.writeStartObject();
                    json.writeStringField(keyRef.getAlias(), keyRef.getName());
                    json.writeEndObject();
                    continue;
                }
                json.writeString(keyRef.getName());
            }
            json.writeEndArray();
        }
    }

    private String getAliasedFullQualifiedName(EdmType type) {
        FullQualifiedName fqn = type.getFullQualifiedName();
        return this.getAliasedFullQualifiedName(fqn);
    }

    private void appendTypeDefinitions(JsonGenerator json, List<EdmTypeDefinition> typeDefinitions) throws SerializerException, IOException {
        for (EdmTypeDefinition definition : typeDefinitions) {
            json.writeObjectFieldStart(definition.getName());
            json.writeStringField(KIND, definition.getKind().name());
            json.writeStringField(UNDERLYING_TYPE, this.getFullQualifiedName(definition.getUnderlyingType()));
            if (definition.getMaxLength() != null) {
                json.writeStringField(MAX_LENGTH, "" + definition.getMaxLength());
            }
            if (definition.getPrecision() != null) {
                json.writeStringField(PRECISION, "" + definition.getPrecision());
            }
            if (definition.getScale() != null) {
                json.writeStringField(SCALE, "" + definition.getScale());
            }
            if (definition.getSrid() != null) {
                json.writeStringField(SRID, "" + definition.getSrid());
            }
            this.appendAnnotations(json, definition, null);
            json.writeEndObject();
        }
    }

    private void appendEnumTypes(JsonGenerator json, List<EdmEnumType> enumTypes) throws SerializerException, IOException {
        for (EdmEnumType enumType : enumTypes) {
            json.writeObjectFieldStart(enumType.getName());
            json.writeStringField(KIND, Kind.EnumType.name());
            json.writeBooleanField(IS_FLAGS, enumType.isFlags());
            json.writeStringField(UNDERLYING_TYPE, this.getFullQualifiedName(enumType.getUnderlyingType()));
            for (String memberName : enumType.getMemberNames()) {
                EdmMember member = enumType.getMember(memberName);
                if (member.getValue() != null) {
                    json.writeStringField(memberName, member.getValue());
                }
                this.appendAnnotations(json, member, memberName);
            }
            json.writeEndObject();
        }
    }

    private void appendAnnotations(JsonGenerator json, EdmAnnotatable annotatable, String memberName) throws SerializerException, IOException {
        List<EdmAnnotation> annotations = annotatable.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            for (EdmAnnotation annotation : annotations) {
                String termName;
                String string = termName = memberName != null ? memberName : "";
                if (annotation.getTerm() != null) {
                    termName = termName + "@" + this.getAliasedFullQualifiedName(annotation.getTerm().getFullQualifiedName());
                }
                if (annotation.getQualifier() != null) {
                    termName = termName + "#" + annotation.getQualifier();
                }
                if (annotation.getExpression() == null && termName.length() > 0) {
                    json.writeBooleanField(termName, true);
                } else {
                    this.appendExpression(json, annotation.getExpression(), termName);
                }
                this.appendAnnotations(json, annotation, termName);
            }
        }
    }

    private void appendExpression(JsonGenerator json, EdmExpression expression, String termName) throws SerializerException, IOException {
        if (expression == null) {
            return;
        }
        if (expression.isConstant()) {
            this.appendConstantExpression(json, expression.asConstant(), termName);
        } else if (expression.isDynamic()) {
            this.appendDynamicExpression(json, expression.asDynamic(), termName);
        } else {
            throw new IllegalArgumentException("Unkown expressiontype in metadata");
        }
    }

    private void appendDynamicExpression(JsonGenerator json, EdmDynamicExpression dynExp, String termName) throws SerializerException, IOException {
        json.writeFieldName(termName);
        switch (dynExp.getExpressionType()) {
            case And: {
                this.appendLogicalOrComparisonExpression(json, dynExp.asAnd());
                break;
            }
            case Or: {
                this.appendLogicalOrComparisonExpression(json, dynExp.asOr());
                break;
            }
            case Not: {
                this.appendNotExpression(json, dynExp.asNot());
                break;
            }
            case Eq: {
                this.appendLogicalOrComparisonExpression(json, dynExp.asEq());
                break;
            }
            case Ne: {
                this.appendLogicalOrComparisonExpression(json, dynExp.asNe());
                break;
            }
            case Gt: {
                this.appendLogicalOrComparisonExpression(json, dynExp.asGt());
                break;
            }
            case Ge: {
                this.appendLogicalOrComparisonExpression(json, dynExp.asGe());
                break;
            }
            case Lt: {
                this.appendLogicalOrComparisonExpression(json, dynExp.asLt());
                break;
            }
            case Le: {
                this.appendLogicalOrComparisonExpression(json, dynExp.asLe());
                break;
            }
            case AnnotationPath: {
                json.writeStartObject();
                json.writeStringField(ANNOTATION_PATH, dynExp.asAnnotationPath().getValue());
                json.writeEndObject();
                break;
            }
            case Apply: {
                EdmApply asApply = dynExp.asApply();
                json.writeStartObject();
                json.writeArrayFieldStart(DOLLAR + asApply.getExpressionName());
                for (EdmExpression parameter : asApply.getParameters()) {
                    this.appendExpression(json, parameter, null);
                }
                json.writeEndArray();
                json.writeStringField(DOLLAR + Kind.Function.name(), asApply.getFunction());
                this.appendAnnotations(json, asApply, null);
                json.writeEndObject();
                break;
            }
            case Cast: {
                EdmCast asCast = dynExp.asCast();
                json.writeStartObject();
                this.appendExpression(json, asCast.getValue(), DOLLAR + asCast.getExpressionName());
                json.writeStringField(TYPE, this.getAliasedFullQualifiedName(asCast.getType()));
                if (asCast.getMaxLength() != null) {
                    json.writeNumberField(MAX_LENGTH, asCast.getMaxLength().intValue());
                }
                if (asCast.getPrecision() != null) {
                    json.writeNumberField(PRECISION, asCast.getPrecision().intValue());
                }
                if (asCast.getScale() != null) {
                    json.writeNumberField(SCALE, asCast.getScale().intValue());
                }
                this.appendAnnotations(json, asCast, null);
                json.writeEndObject();
                break;
            }
            case Collection: {
                json.writeStartArray();
                for (EdmExpression item : dynExp.asCollection().getItems()) {
                    this.appendExpression(json, item, null);
                }
                json.writeEndArray();
                break;
            }
            case If: {
                EdmIf asIf = dynExp.asIf();
                json.writeStartObject();
                json.writeArrayFieldStart(DOLLAR + asIf.getExpressionName());
                this.appendExpression(json, asIf.getGuard(), null);
                this.appendExpression(json, asIf.getThen(), null);
                this.appendExpression(json, asIf.getElse(), null);
                json.writeEndArray();
                this.appendAnnotations(json, asIf, null);
                json.writeEndObject();
                break;
            }
            case IsOf: {
                EdmIsOf asIsOf = dynExp.asIsOf();
                json.writeStartObject();
                this.appendExpression(json, asIsOf.getValue(), DOLLAR + asIsOf.getExpressionName());
                json.writeStringField(TYPE, this.getAliasedFullQualifiedName(asIsOf.getType()));
                if (asIsOf.getMaxLength() != null) {
                    json.writeNumberField(MAX_LENGTH, asIsOf.getMaxLength().intValue());
                }
                if (asIsOf.getPrecision() != null) {
                    json.writeNumberField(PRECISION, asIsOf.getPrecision().intValue());
                }
                if (asIsOf.getScale() != null) {
                    json.writeNumberField(SCALE, asIsOf.getScale().intValue());
                }
                this.appendAnnotations(json, asIsOf, null);
                json.writeEndObject();
                break;
            }
            case LabeledElement: {
                EdmLabeledElement asLabeledElement = dynExp.asLabeledElement();
                json.writeStartObject();
                this.appendExpression(json, asLabeledElement.getValue(), DOLLAR + asLabeledElement.getExpressionName());
                json.writeStringField("$Name", asLabeledElement.getName());
                this.appendAnnotations(json, asLabeledElement, null);
                json.writeEndObject();
                break;
            }
            case LabeledElementReference: {
                EdmLabeledElementReference asLabeledElementReference = dynExp.asLabeledElementReference();
                json.writeStartObject();
                json.writeStringField(DOLLAR + asLabeledElementReference.getExpressionName(), asLabeledElementReference.getValue());
                json.writeEndObject();
                break;
            }
            case Null: {
                EdmNull asNull = dynExp.asNull();
                json.writeStartObject();
                json.writeStringField(DOLLAR + asNull.getExpressionName(), null);
                this.appendAnnotations(json, dynExp.asNull(), null);
                json.writeEndObject();
                break;
            }
            case NavigationPropertyPath: {
                EdmNavigationPropertyPath asNavigationPropertyPath = dynExp.asNavigationPropertyPath();
                json.writeStartObject();
                json.writeStringField(DOLLAR + asNavigationPropertyPath.getExpressionName(), asNavigationPropertyPath.getValue());
                json.writeEndObject();
                break;
            }
            case Path: {
                EdmPath asPath = dynExp.asPath();
                json.writeStartObject();
                json.writeStringField(DOLLAR + asPath.getExpressionName(), asPath.getValue());
                json.writeEndObject();
                break;
            }
            case PropertyPath: {
                EdmPropertyPath asPropertyPath = dynExp.asPropertyPath();
                json.writeStartObject();
                json.writeStringField(DOLLAR + asPropertyPath.getExpressionName(), asPropertyPath.getValue());
                json.writeEndObject();
                break;
            }
            case Record: {
                EdmRecord asRecord = dynExp.asRecord();
                json.writeStartObject();
                EdmStructuredType type = asRecord.getType();
                if (type != null) {
                    json.writeStringField(TYPE, this.getAliasedFullQualifiedName(type));
                }
                for (EdmPropertyValue propValue : asRecord.getPropertyValues()) {
                    this.appendExpression(json, propValue.getValue(), propValue.getProperty());
                    this.appendAnnotations(json, propValue, propValue.getProperty());
                }
                this.appendAnnotations(json, asRecord, null);
                json.writeEndObject();
                break;
            }
            case UrlRef: {
                EdmUrlRef asUrlRef = dynExp.asUrlRef();
                json.writeStartObject();
                this.appendExpression(json, asUrlRef.getValue(), DOLLAR + asUrlRef.getExpressionName());
                this.appendAnnotations(json, asUrlRef, null);
                json.writeEndObject();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown ExpressionType for dynamic expression: " + (Object)((Object)dynExp.getExpressionType()));
            }
        }
    }

    private void appendNotExpression(JsonGenerator json, EdmNot exp) throws SerializerException, IOException {
        json.writeStartObject();
        this.appendExpression(json, exp.getLeftExpression(), DOLLAR + exp.getExpressionName());
        this.appendAnnotations(json, exp, null);
        json.writeEndObject();
    }

    private void appendLogicalOrComparisonExpression(JsonGenerator json, EdmLogicalOrComparisonExpression exp) throws SerializerException, IOException {
        json.writeStartObject();
        json.writeArrayFieldStart(DOLLAR + exp.getExpressionName());
        this.appendExpression(json, exp.getLeftExpression(), null);
        this.appendExpression(json, exp.getRightExpression(), null);
        json.writeEndArray();
        this.appendAnnotations(json, exp, null);
        json.writeEndObject();
    }

    private void appendConstantExpression(JsonGenerator json, EdmConstantExpression constExp, String termName) throws SerializerException, IOException {
        switch (constExp.getExpressionType()) {
            case Binary: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case Date: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case DateTimeOffset: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case Decimal: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case Float: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case Int: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case Duration: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case EnumMember: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case Guid: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case TimeOfDay: {
                json.writeObjectFieldStart(termName);
                json.writeStringField(DOLLAR + constExp.getExpressionName(), constExp.getValueAsString());
                json.writeEndObject();
                break;
            }
            case Bool: {
                if (termName != null && termName.length() > 0) {
                    json.writeBooleanField(termName, Boolean.valueOf(constExp.getValueAsString()).booleanValue());
                    break;
                }
                json.writeBoolean(Boolean.valueOf(constExp.getValueAsString()).booleanValue());
                break;
            }
            case String: {
                if (termName != null && termName.length() > 0) {
                    json.writeStringField(termName, constExp.getValueAsString());
                    break;
                }
                json.writeString(constExp.getValueAsString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown ExpressionType for constant expression: " + (Object)((Object)constExp.getExpressionType()));
            }
        }
    }

    private String getAliasedFullQualifiedName(FullQualifiedName fqn) {
        String name = this.namespaceToAlias.get(fqn.getNamespace()) != null ? this.namespaceToAlias.get(fqn.getNamespace()) + "." + fqn.getName() : fqn.getFullQualifiedNameAsString();
        return name;
    }

    private String getFullQualifiedName(EdmType type) {
        return type.getFullQualifiedName().getFullQualifiedNameAsString();
    }

    private void appendReference(JsonGenerator json) throws SerializerException, IOException {
        json.writeObjectFieldStart(REFERENCES);
        for (EdmxReference reference : this.serviceMetadata.getReferences()) {
            List<EdmxReferenceIncludeAnnotation> includeAnnotations;
            json.writeObjectFieldStart(reference.getUri().toASCIIString());
            List<EdmxReferenceInclude> includes = reference.getIncludes();
            if (!includes.isEmpty()) {
                this.appendIncludes(json, includes);
            }
            if (!(includeAnnotations = reference.getIncludeAnnotations()).isEmpty()) {
                this.appendIncludeAnnotations(json, includeAnnotations);
            }
            json.writeEndObject();
        }
        json.writeEndObject();
    }

    private void appendIncludeAnnotations(JsonGenerator json, List<EdmxReferenceIncludeAnnotation> includeAnnotations) throws SerializerException, IOException {
        json.writeArrayFieldStart(INCLUDE_ANNOTATIONS);
        for (EdmxReferenceIncludeAnnotation includeAnnotation : includeAnnotations) {
            json.writeStartObject();
            json.writeStringField(TERM_NAMESPACE, includeAnnotation.getTermNamespace());
            if (includeAnnotation.getQualifier() != null) {
                json.writeStringField(QUALIFIER, includeAnnotation.getQualifier());
            }
            if (includeAnnotation.getTargetNamespace() != null) {
                json.writeStringField(TARGET_NAMESPACE, includeAnnotation.getTargetNamespace());
            }
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void appendIncludes(JsonGenerator json, List<EdmxReferenceInclude> includes) throws SerializerException, IOException {
        json.writeArrayFieldStart(INCLUDE);
        for (EdmxReferenceInclude include : includes) {
            json.writeStartObject();
            json.writeStringField(NAMESPACE, include.getNamespace());
            if (include.getAlias() != null) {
                this.namespaceToAlias.put(include.getNamespace(), include.getAlias());
                json.writeStringField(ALIAS, include.getAlias());
            }
            json.writeEndObject();
        }
        json.writeEndArray();
    }
}

