/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms;

import com.sap.cloud.servicesdk.xbem.core.MessagingService;
import com.sap.cloud.servicesdk.xbem.core.exception.MessagingRuntimeException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jms.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnectionExtension {
    private static final Logger LOG = LoggerFactory.getLogger(JmsConnectionExtension.class);
    private final MessagingService clientInfo;

    public JmsConnectionExtension(MessagingService clientInfo) {
        this.clientInfo = clientInfo;
    }

    public Object headersExtension(Connection connection, URI uri) {
        return this.headersExtension(connection, uri, this.requestOAuthToken());
    }

    private Object headersExtension(Connection connection, URI uri, String token) {
        LOG.trace("Headers extension:: connection={}; uri: {}", (Object)connection, (Object)uri);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        return headers;
    }

    private String requestOAuthToken() {
        String endpoint = this.clientInfo.getOAuthTokenEndpoint();
        String clientId = this.clientInfo.getClientId();
        String clientSecret = this.clientInfo.getClientSecret();
        OAuthHandler.AuthSettings oaSettings = OAuthHandler.AuthSettings.createClientCredentialsGrant(endpoint, clientId, clientSecret);
        try {
            OAuthHandler handler = new OAuthHandler(oaSettings);
            return handler.doTokenRequest();
        }
        catch (IOException e) {
            throw new MessagingRuntimeException("Unable to get OAuth token: " + e.getMessage(), (Throwable)e);
        }
    }

    static class OAuthHandler {
        private static final String OAUTH_CLIENT_FLOW_BODY_TEMPLATE = "client_id=%s&client_secret=%s&grant_type=client_credentials&response_type=token";
        static final String CLIENT_CREDENTIALS_GRANT = "client_credentials";
        static final String PASSWORD_GRANT = "password";
        static final String AUTH_BEARER = "Bearer ";
        static final String ACCEPT_HEADER = "Accept";
        static final String CONTENT_TYPE_HEADER = "Content-Type";
        static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
        static final String APPLICATION_JSON = "application/json";
        static final String USER_AGENT = "emjapi";
        static final String USER_AGENT_HEADER = "User-Agent";
        static final String AUTHORIZATION_HEADER = "Authorization";
        private static final String HTTP_METHOD_POST = "POST";
        private static final String OAUTH_TOKEN_URL_POSTFIX = "/oauth/token";
        private static final String AUTH_BASIC = "Basic ";
        private static final int BUFFER_SIZE = 65536;
        private static final int MAX_READ_SIZE = 655360;
        private final AuthSettings authSettings;

        OAuthHandler(AuthSettings authSettings) {
            this.authSettings = authSettings;
        }

        String doTokenRequest() throws IOException {
            String oauthFlow = this.authSettings.getoAuthGrantType();
            if (PASSWORD_GRANT.equalsIgnoreCase(oauthFlow)) {
                throw new UnsupportedOperationException("Found unknown oauth flow value: " + oauthFlow);
            }
            if (CLIENT_CREDENTIALS_GRANT.equalsIgnoreCase(oauthFlow)) {
                String url = this.authSettings.getoAuthEndpoint();
                String clientId = this.authSettings.getoAuthClientId();
                String clientSecret = this.authSettings.getoAuthClientSecret();
                return this.doTokenRequestClientFlow(url, clientId, clientSecret);
            }
            throw new IllegalStateException("Found unknown oauth flow value: " + oauthFlow);
        }

        private String doTokenRequestClientFlow(String url, String clientId, String clientSecret) throws IOException {
            LOG.trace("Start doTokenRequestClientFlow:: {}. With ClientId:: {}", (Object)url, (Object)clientId);
            String body = String.format(OAUTH_CLIENT_FLOW_BODY_TEMPLATE, clientId, clientSecret);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(CONTENT_TYPE_HEADER, APPLICATION_X_WWW_FORM_URLENCODED);
            headers.put(ACCEPT_HEADER, APPLICATION_JSON);
            headers.put(USER_AGENT_HEADER, USER_AGENT);
            String cid = clientId + ":" + clientSecret;
            String b64 = Base64.getEncoder().encodeToString(cid.getBytes(StandardCharsets.ISO_8859_1));
            headers.put(AUTHORIZATION_HEADER, AUTH_BASIC + b64);
            String postUrl = url.endsWith(OAUTH_TOKEN_URL_POSTFIX) ? url + "?grant_type=client_credentials" : url + OAUTH_TOKEN_URL_POSTFIX + "?grant_type=client_credentials";
            String response = this.post(postUrl, body, headers);
            return this.extractToken(response);
        }

        String extractToken(String response) throws IOException {
            int index = response.indexOf("\"access_token\"");
            int tokenIndex = response.indexOf(34, index + 14) + 1;
            int lastTokenIndex = response.indexOf(34, tokenIndex);
            if (index <= 0 || lastTokenIndex <= tokenIndex) {
                throw new IOException("Unable to extract access_token from response: " + response);
            }
            return response.substring(tokenIndex, lastTokenIndex);
        }

        /*
         * Exception decompiling
         */
        private String post(String url, String content, Map<String, String> additionalHeaders) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private HttpURLConnection openConnection(String url) throws IOException {
            URL urly = new URL(url);
            Proxy proxy = this.getProxy();
            HttpURLConnection con = proxy == null ? (HttpURLConnection)urly.openConnection() : (HttpURLConnection)urly.openConnection(proxy);
            return con;
        }

        private Proxy getProxy() {
            String host = System.getProperty("http.proxyHost");
            if (host != null) {
                String portParam = System.getProperty("http.proxyPort");
                int port = Integer.parseInt(portParam);
                InetSocketAddress addr = new InetSocketAddress(host, port);
                return new Proxy(Proxy.Type.HTTP, addr);
            }
            host = System.getProperty("https.proxyHost");
            if (host != null) {
                String portParam = System.getProperty("https.proxyPort");
                int port = Integer.parseInt(portParam);
                InetSocketAddress addr = new InetSocketAddress(host, port);
                return new Proxy(Proxy.Type.HTTP, addr);
            }
            return null;
        }

        private String handleResponse(HttpURLConnection con) throws IOException {
            int responseCode = con.getResponseCode();
            if (!this.is2xx(responseCode)) {
                String message = String.format("Unable to Fetch a token: got a none 2xx response code '%s' from OAuth-Endpoint '%s'.", responseCode, con.getURL());
                LOG.error(message);
                throw new IOException(message);
            }
            return this.readResponseBody(con);
        }

        /*
         * Exception decompiling
         */
        private String readResponseBody(HttpURLConnection con) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Charset getCharset(HttpURLConnection connection) {
            String contentTypeHeader = connection.getHeaderField(CONTENT_TYPE_HEADER);
            if (contentTypeHeader != null) {
                String contentTypeHeaderLc = contentTypeHeader.toLowerCase(Locale.US);
                if (contentTypeHeaderLc.contains("utf-8")) {
                    return StandardCharsets.UTF_8;
                }
                if (contentTypeHeaderLc.contains("iso-8859-1")) {
                    return StandardCharsets.ISO_8859_1;
                }
            }
            return StandardCharsets.US_ASCII;
        }

        private boolean is2xx(int responseCode) {
            return responseCode >= 200 && responseCode < 300;
        }

        public static final class AuthSettings {
            private String oAuthGrantType;
            private String oAuthClientId;
            private String oAuthClientSecret;
            private String oAuthEndpoint;

            private AuthSettings() {
            }

            static AuthSettings createClientCredentialsGrant(String tokenEndpoint, String clientId, String clientSecret) {
                AuthSettings auth = new AuthSettings();
                auth.oAuthClientId = clientId;
                auth.oAuthClientSecret = clientSecret;
                auth.oAuthEndpoint = tokenEndpoint;
                auth.oAuthGrantType = OAuthHandler.CLIENT_CREDENTIALS_GRANT;
                return auth;
            }

            String getoAuthGrantType() {
                return this.oAuthGrantType;
            }

            String getoAuthClientId() {
                return this.oAuthClientId;
            }

            String getoAuthClientSecret() {
                return this.oAuthClientSecret;
            }

            String getoAuthEndpoint() {
                return this.oAuthEndpoint;
            }
        }
    }
}

