/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms;

import com.sap.cloud.servicesdk.xbem.core.MessagingService;
import com.sap.cloud.servicesdk.xbem.core.MessagingServiceConnectionSettings;
import com.sap.cloud.servicesdk.xbem.core.MessagingServiceExtension;
import com.sap.cloud.servicesdk.xbem.core.exception.MessagingException;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.JmsConnectionExtension;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.MessagingServiceJmsConnectionFactory;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.MessagingServiceJmsSettings;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.uribuilder.ConnectionSettingsTool;
import java.util.Optional;
import javax.jms.ConnectionFactory;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsConnectionFactory;

public class MessagingServiceJmsExtension
implements MessagingServiceExtension<MessagingServiceJmsConnectionFactory> {
    private static final String JMS_AMQPWSS_SCHEME = "amqpwss";
    private static final String JMS_AMQPWS_SCHEME = "amqpws";
    private static final String WSS_SCHEME = "wss";
    private static final String WS_SCHEME = "ws";
    private static final String SCHEME_SEPARATORS = "://";
    private static final String WSS = "wss://";
    private static final String WS = "ws://";
    private static final String JMS_AMQPWSS = "amqpwss://";
    private static final String JMS_AMQPWS = "amqpws://";
    private static final int SSL_PORT = 443;
    private static final int HTTP_PORT = 80;
    private static final char COLON = ':';
    private static final char SLASH = '/';
    public static final String QUESTION_MARK = "?";
    public static final String SCHEMA_SEP = "://";
    public static final String EQUALS_SIGN = "=";
    private MessagingService clientInfo;
    private MessagingServiceJmsSettings settings;

    public void init(MessagingService clientInfo, MessagingServiceConnectionSettings settings) {
        if (settings != null && !(settings instanceof MessagingServiceJmsSettings)) {
            throw new IllegalArgumentException("Expected " + MessagingServiceJmsSettings.class.getName() + " but found " + settings.getClass().getName());
        }
        if (clientInfo == null) {
            throw new IllegalArgumentException("MessagingService info must not be null.");
        }
        this.settings = (MessagingServiceJmsSettings)settings;
        this.clientInfo = new MessagingService(clientInfo);
    }

    public boolean supportsType(Class clazz) {
        return clazz == ConnectionFactory.class || clazz == MessagingServiceJmsConnectionFactory.class;
    }

    public Class<MessagingServiceJmsConnectionFactory> getExtensionType() {
        return MessagingServiceJmsConnectionFactory.class;
    }

    public MessagingServiceJmsConnectionFactory create() throws MessagingException {
        if (this.clientInfo == null) {
            throw new MessagingException("Not yet initialized (missing `init()`");
        }
        return this.init();
    }

    private MessagingServiceJmsConnectionFactory init() {
        JmsConnectionFactory factory = new JmsConnectionFactory();
        JmsConnectionExtension extension = this.createExtension(this.clientInfo, this.settings);
        factory.setRemoteURI(this.getServiceUrl());
        factory.setExtension(JmsConnectionExtensions.HTTP_HEADERS_OVERRIDE.toString(), extension::headersExtension);
        factory.setValidatePropertyNames(this.clientInfo.isValidatePropertyNames());
        return new MessagingServiceJmsConnectionFactory(factory);
    }

    private JmsConnectionExtension createExtension(MessagingService clientInfo, MessagingServiceJmsSettings settings) {
        if (settings != null && settings.getAuthenticationRequest() != null) {
            return new JmsConnectionExtension(settings.getAuthenticationRequest());
        }
        return new JmsConnectionExtension(clientInfo);
    }

    private String getServiceUrl() {
        String url = this.clientInfo.getServiceUrl();
        if (url.startsWith(WSS)) {
            url = JMS_AMQPWSS + url.substring(WSS.length());
            url = this.addPortIfNotSet(url, 443).orElse(url);
        } else if (url.startsWith(WS)) {
            url = JMS_AMQPWS + url.substring(WS.length());
            url = this.addPortIfNotSet(url, 80).orElse(url);
        }
        url = this.addSettings(url, this.clientInfo, this.settings);
        return url;
    }

    private String addSettings(String url, MessagingService clientInfo, MessagingServiceJmsSettings settings) {
        url = ConnectionSettingsTool.buildConnectionUri(url, settings, clientInfo);
        return url;
    }

    private Optional<String> addPortIfNotSet(String url, int port) {
        int pos = url.lastIndexOf(58);
        if (pos > 0 && pos < url.length()) {
            int lastpos = url.indexOf(47, pos);
            if (lastpos == -1) {
                lastpos = url.length();
            }
            try {
                Integer.parseInt(url.substring(pos + 1, lastpos));
                return Optional.empty();
            }
            catch (NumberFormatException e) {
                int shSepPos = url.indexOf("://");
                int hostEndPos = url.indexOf(47, shSepPos + "://".length());
                if (hostEndPos == -1) {
                    return Optional.of(url + ':' + port);
                }
                String result = url.substring(0, hostEndPos) + ':' + port + url.substring(hostEndPos);
                return Optional.of(result);
            }
        }
        return Optional.empty();
    }
}

