/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection;

import com.sap.cloud.servicesdk.xbem.core.exception.MessagingRuntimeException;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthHandler;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthHandlerHelper;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthSettings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthHandlerDefault
implements OAuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthHandlerDefault.class);
    private static final String AUTH_BASIC = "Basic ";
    private static final String OAUTH_CLIENT_FLOW_BODY_TEMPLATE = "client_id=%s&client_secret=%s&grant_type=client_credentials&response_type=token";
    private static final OAuthHandlerHelper<HttpURLConnection> OAUTH_HANDLER_HELPER = new OAuthHandlerHelper();
    private final OAuthSettings authSettings;

    public OAuthHandlerDefault(OAuthSettings authSettings) {
        this.authSettings = authSettings;
    }

    @Override
    public String doTokenRequest() {
        String oauthFlow = this.authSettings.getoAuthGrantType();
        if ("client_credentials".equalsIgnoreCase(oauthFlow)) {
            String url = this.authSettings.getoAuthEndpoint();
            String clientId = this.authSettings.getoAuthClientId();
            String clientSecret = this.authSettings.getoAuthClientSecret();
            try {
                return this.doTokenRequestClientFlow(url, clientId, clientSecret);
            }
            catch (IOException e) {
                String message = "Unable to get OAuth token. TokenFlow:: binding-secret, instance-secret";
                LOG.error(message, (Throwable)e);
                throw new MessagingRuntimeException(message + " " + e.getMessage(), (Throwable)e);
            }
        }
        throw new IllegalStateException("Found unknown oauth flow value: " + oauthFlow);
    }

    private String doTokenRequestClientFlow(String url, String clientId, String clientSecret) throws IOException {
        long startTime = System.currentTimeMillis();
        LOG.debug("Start doTokenRequestClientFlow (binding-secret or instance-secret flow):: {}. With ClientId:: {}", (Object)url, (Object)clientId);
        String body = String.format(OAUTH_CLIENT_FLOW_BODY_TEMPLATE, clientId, clientSecret);
        HashMap<String, String> headers = new HashMap<String, String>();
        String cid = clientId + ":" + clientSecret;
        String b64 = Base64.getEncoder().encodeToString(cid.getBytes(StandardCharsets.ISO_8859_1));
        headers.put("Authorization", AUTH_BASIC + b64);
        String postUrl = url.endsWith("/oauth/token") ? url + "?grant_type=client_credentials" : url + "/oauth/token" + "?grant_type=client_credentials";
        HttpURLConnection httpConnection = this.getHttpConnection(postUrl);
        String accessToken = OAUTH_HANDLER_HELPER.post(httpConnection, body, headers);
        long durationOfRequest = System.currentTimeMillis() - startTime;
        LOG.debug("Finished doTokenRequestClientFlow time in milli seconds (binding-secret or instance-secret flow):: {}", (Object)durationOfRequest);
        return accessToken;
    }

    private HttpURLConnection getHttpConnection(String url) throws IOException {
        return OAUTH_HANDLER_HELPER.openConnection(url);
    }
}

