/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection;

import com.sap.cloud.servicesdk.xbem.core.CredentialType;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthHandler;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthHandlerDefault;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthHandlerX509;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthSettings;

public class OAuthHandlerFactory {
    private OAuthHandlerFactory() {
    }

    public static OAuthHandler createOAuthHandler(OAuthSettings oAuthSettings) {
        if (oAuthSettings == null) {
            throw new IllegalArgumentException("OAuth settings must not be null");
        }
        CredentialType credentialsType = oAuthSettings.getOAuthCredentialType();
        if (CredentialType.X509.equals((Object)credentialsType)) {
            return new OAuthHandlerX509(oAuthSettings);
        }
        return new OAuthHandlerDefault(oAuthSettings);
    }
}

