/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection;

import com.sap.cloud.servicesdk.xbem.core.commons.Version;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthHandlerHelper<T extends HttpURLConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthHandlerHelper.class);
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String HTTP_METHOD_POST = "POST";
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_READ_SIZE = 655360;

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE_HEADER, APPLICATION_X_WWW_FORM_URLENCODED);
        headers.put(ACCEPT_HEADER, APPLICATION_JSON);
        headers.put("User-Agent", "emjapi/" + Version.getInstance().getVersion());
        return headers;
    }

    public String post(T con, String body) throws IOException {
        return this.post(con, body, null);
    }

    /*
     * Exception decompiling
     */
    public String post(T con, String content, Map<String, String> additionalHeaders) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Proxy getProxy() {
        String host = System.getProperty("http.proxyHost");
        if (host != null) {
            String portParam = System.getProperty("http.proxyPort");
            int port = Integer.parseInt(portParam);
            InetSocketAddress addr = new InetSocketAddress(host, port);
            return new Proxy(Proxy.Type.HTTP, addr);
        }
        host = System.getProperty("https.proxyHost");
        if (host != null) {
            String portParam = System.getProperty("https.proxyPort");
            int port = Integer.parseInt(portParam);
            InetSocketAddress addr = new InetSocketAddress(host, port);
            return new Proxy(Proxy.Type.HTTP, addr);
        }
        return null;
    }

    public T openConnection(String url) throws IOException {
        URL urly = new URL(url);
        Proxy proxy = this.getProxy();
        HttpURLConnection con = proxy == null ? (HttpURLConnection)urly.openConnection() : (HttpURLConnection)urly.openConnection(proxy);
        return (T)con;
    }

    private String handleResponse(T con) throws IOException {
        int responseCode = ((HttpURLConnection)con).getResponseCode();
        if (!this.is2xx(responseCode)) {
            String message = String.format("Unable to Fetch a token: got a none 2xx response code '%s' from OAuth-Endpoint '%s'.", responseCode, ((URLConnection)con).getURL());
            LOG.error(message);
            throw new IOException(message);
        }
        String responseBody = this.readResponseBody(con);
        return this.extractToken(responseBody);
    }

    private boolean is2xx(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    /*
     * Exception decompiling
     */
    private String readResponseBody(T con) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Charset getCharset(T connection) {
        String contentTypeHeader = ((URLConnection)connection).getHeaderField(CONTENT_TYPE_HEADER);
        if (contentTypeHeader != null) {
            String contentTypeHeaderLc = contentTypeHeader.toLowerCase(Locale.US);
            if (contentTypeHeaderLc.contains("utf-8")) {
                return StandardCharsets.UTF_8;
            }
            if (contentTypeHeaderLc.contains("iso-8859-1")) {
                return StandardCharsets.ISO_8859_1;
            }
        }
        return StandardCharsets.US_ASCII;
    }

    private String extractToken(String response) throws IOException {
        int index = response.indexOf("\"access_token\"");
        int tokenIndex = response.indexOf(34, index + 14) + 1;
        int lastTokenIndex = response.indexOf(34, tokenIndex);
        if (index <= 0 || lastTokenIndex <= tokenIndex) {
            throw new IOException("Unable to extract access_token from response: " + response);
        }
        return response.substring(tokenIndex, lastTokenIndex);
    }
}

