/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection;

import com.sap.cloud.servicesdk.xbem.core.exception.MessagingRuntimeException;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthHandler;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthHandlerHelper;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthSettings;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.x509.TokenRequestX509;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthHandlerX509
implements OAuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthHandlerX509.class);
    private static final String OAUTH_CLIENT_FLOW_BODY_TEMPLATE = "client_id=%s&grant_type=client_credentials&response_type=token";
    private final OAuthSettings oAuthSettings;
    private final OAuthHandlerHelper<HttpsURLConnection> oAuthCommons = new OAuthHandlerHelper();

    public OAuthHandlerX509(OAuthSettings oAuthSettings) {
        this.validateOauthSettings(oAuthSettings);
        this.oAuthSettings = oAuthSettings;
    }

    private void validateOauthSettings(OAuthSettings oAuthSettings) {
        if (oAuthSettings.getoAuthCertificate() == null || "".equals(oAuthSettings.getoAuthCertificate())) {
            throw new MessagingRuntimeException("Certificate must not be null or empty.");
        }
        if (oAuthSettings.getoAuthPrivateKey() == null || "".equals(oAuthSettings.getoAuthPrivateKey())) {
            throw new MessagingRuntimeException("Private Key must not be null or empty.");
        }
    }

    @Override
    public String doTokenRequest() {
        String oauthFlow = this.oAuthSettings.getoAuthGrantType();
        if ("client_credentials".equalsIgnoreCase(oauthFlow)) {
            try {
                return this.doTokenRequestClientFlow();
            }
            catch (IOException | GeneralSecurityException e) {
                String message = "Unable to get OAuth token. TokenFlow:: x509";
                LOG.error(message, (Throwable)e);
                throw new MessagingRuntimeException(message + "" + e.getMessage(), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException("Found unknown oauth flow value: " + oauthFlow);
    }

    private String doTokenRequestClientFlow() throws GeneralSecurityException, IOException {
        long startTime = System.currentTimeMillis();
        String url = this.oAuthSettings.getoAuthEndpoint();
        if (!url.endsWith("oauth/token")) {
            url = url + "/oauth/token";
        }
        String clientId = this.oAuthSettings.getoAuthClientId();
        LOG.debug("Start doTokenRequestClientFlow (x509):: {}. With ClientId:: {}", (Object)url, (Object)clientId);
        HttpsURLConnection httpsConnection = this.getHttpsConnection(url);
        String body = String.format(OAUTH_CLIENT_FLOW_BODY_TEMPLATE, clientId);
        String accessToken = this.oAuthCommons.post(httpsConnection, body);
        long durationOfRequest = System.currentTimeMillis() - startTime;
        LOG.debug("Finished doTokenRequestClientFlow (x509) time in milli seconds:: {}. With ClientId:: {}", (Object)durationOfRequest, (Object)clientId);
        return accessToken;
    }

    private HttpsURLConnection getHttpsConnection(String url) throws GeneralSecurityException, IOException {
        TokenRequestX509 tokenRequestX509 = new TokenRequestX509(this.oAuthSettings.getoAuthPrivateKey(), this.oAuthSettings.getoAuthCertificate());
        SSLContext sslContext = tokenRequestX509.getSslContext();
        HttpsURLConnection con = this.oAuthCommons.openConnection(url);
        con.setSSLSocketFactory(sslContext.getSocketFactory());
        return con;
    }
}

