/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms;

import com.sap.cloud.servicesdk.xbem.core.CredentialType;
import com.sap.cloud.servicesdk.xbem.core.MessagingService;
import com.sap.cloud.servicesdk.xbem.core.commons.Version;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthHandler;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthHandlerFactory;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.OAuthSettings;
import jakarta.jms.Connection;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.HashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnectionExtension {
    private static final Logger LOG = LoggerFactory.getLogger(JmsConnectionExtension.class);
    private final Supplier<String> defaultTokenRequest = this::requestOAuthToken;
    private MessagingService clientInfo;
    private Supplier<String> authenticationRequest;

    public JmsConnectionExtension(MessagingService clientInfo) {
        this.clientInfo = clientInfo;
    }

    public JmsConnectionExtension(Supplier<String> authenticationRequest) {
        this.authenticationRequest = authenticationRequest;
    }

    public Object headersExtension(Connection connection, URI uri) {
        if (this.authenticationRequest != null) {
            LOG.debug("Use custom authentication request.");
            return this.headersExtension(connection, uri, this.authenticationRequest.get());
        }
        return this.headersExtension(connection, uri, this.defaultTokenRequest.get());
    }

    private Object headersExtension(Connection connection, URI uri, String token) {
        LOG.trace("Headers extension:: connection={}; uri: {}", (Object)connection, (Object)uri);
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
        headers.put("Authorization", (CallSite)((Object)("Bearer " + token)));
        headers.put("User-Agent", (CallSite)((Object)("emjapi/" + Version.getInstance().getVersion())));
        return headers;
    }

    private String requestOAuthToken() {
        String endpoint = this.clientInfo.getOAuthTokenEndpoint();
        String clientId = this.clientInfo.getClientId();
        String clientSecret = this.clientInfo.getClientSecret();
        String certificate = this.clientInfo.getCertificate();
        String privateKey = this.clientInfo.getPrivateKey();
        CredentialType credentialsType = this.clientInfo.getCredentialType();
        OAuthSettings oaSettings = new OAuthSettings(endpoint, clientId, clientSecret, certificate, privateKey, credentialsType);
        OAuthHandler oAuthHandler = OAuthHandlerFactory.createOAuthHandler(oaSettings);
        return oAuthHandler.doTokenRequest();
    }
}

