/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection;

import com.sap.cloud.servicesdk.xbem.core.commons.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthHandlerHelper<T extends HttpURLConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthHandlerHelper.class);
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String HTTP_METHOD_POST = "POST";
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_READ_SIZE = 655360;

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE_HEADER, APPLICATION_X_WWW_FORM_URLENCODED);
        headers.put(ACCEPT_HEADER, APPLICATION_JSON);
        headers.put("User-Agent", "emjapi/" + Version.getInstance().getVersion());
        return headers;
    }

    public String post(T con, String body) throws IOException {
        return this.post(con, body, null);
    }

    public String post(T con, String content, Map<String, String> additionalHeaders) throws IOException {
        Map<String, String> headers = this.getHeaders();
        if (additionalHeaders != null) {
            headers.putAll(additionalHeaders);
        }
        headers.forEach((arg_0, arg_1) -> con.setRequestProperty(arg_0, arg_1));
        ((HttpURLConnection)con).setRequestMethod(HTTP_METHOD_POST);
        ((URLConnection)con).setDoOutput(true);
        try (OutputStream os = ((URLConnection)con).getOutputStream();){
            String string;
            block14: {
                WritableByteChannel outChannel = Channels.newChannel(os);
                try {
                    ByteBuffer outBuffer = ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8));
                    int wrote = outChannel.write(outBuffer);
                    if (wrote < 0) {
                        throw new IOException("No data written");
                    }
                    string = this.handleResponse(con);
                    if (outChannel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (outChannel != null) {
                        try {
                            outChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outChannel.close();
            }
            return string;
        }
    }

    public Proxy getProxy() {
        String host = System.getProperty("http.proxyHost");
        if (host != null) {
            String portParam = System.getProperty("http.proxyPort");
            int port = Integer.parseInt(portParam);
            InetSocketAddress addr = new InetSocketAddress(host, port);
            return new Proxy(Proxy.Type.HTTP, addr);
        }
        host = System.getProperty("https.proxyHost");
        if (host != null) {
            String portParam = System.getProperty("https.proxyPort");
            int port = Integer.parseInt(portParam);
            InetSocketAddress addr = new InetSocketAddress(host, port);
            return new Proxy(Proxy.Type.HTTP, addr);
        }
        return null;
    }

    public T openConnection(String url) throws IOException {
        URL urly = new URL(url);
        Proxy proxy = this.getProxy();
        HttpURLConnection con = proxy == null ? (HttpURLConnection)urly.openConnection() : (HttpURLConnection)urly.openConnection(proxy);
        return (T)con;
    }

    private String handleResponse(T con) throws IOException {
        int responseCode = ((HttpURLConnection)con).getResponseCode();
        if (!this.is2xx(responseCode)) {
            String message = String.format("Unable to Fetch a token: got a none 2xx response code '%s' from OAuth-Endpoint '%s'.", responseCode, ((URLConnection)con).getURL());
            LOG.error(message);
            throw new IOException(message);
        }
        String responseBody = this.readResponseBody(con);
        return this.extractToken(responseBody);
    }

    private boolean is2xx(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    private String readResponseBody(T con) throws IOException {
        Charset responseCharset = this.getCharset(con);
        try (InputStream is = ((URLConnection)con).getInputStream();){
            String string;
            block14: {
                ReadableByteChannel inChannel = Channels.newChannel(is);
                try {
                    int maxRead;
                    ByteBuffer inBuffer = ByteBuffer.allocate(65536);
                    byte[] tmp = new byte[65536];
                    StringBuilder response = new StringBuilder();
                    int read = inChannel.read(inBuffer);
                    for (maxRead = 655360; read > 0 && maxRead > 0; maxRead -= read) {
                        inBuffer.flip();
                        inBuffer.get(tmp, 0, read);
                        response.append(new String(tmp, 0, read, responseCharset));
                        inBuffer.clear();
                        read = inChannel.read(inBuffer);
                    }
                    if (maxRead <= 0) {
                        throw new IOException("Buffer overflow for response.");
                    }
                    string = response.toString();
                    if (inChannel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (inChannel != null) {
                        try {
                            inChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inChannel.close();
            }
            return string;
        }
    }

    private Charset getCharset(T connection) {
        String contentTypeHeader = ((URLConnection)connection).getHeaderField(CONTENT_TYPE_HEADER);
        if (contentTypeHeader != null) {
            String contentTypeHeaderLc = contentTypeHeader.toLowerCase(Locale.US);
            if (contentTypeHeaderLc.contains("utf-8")) {
                return StandardCharsets.UTF_8;
            }
            if (contentTypeHeaderLc.contains("iso-8859-1")) {
                return StandardCharsets.ISO_8859_1;
            }
        }
        return StandardCharsets.US_ASCII;
    }

    private String extractToken(String response) throws IOException {
        int index = response.indexOf("\"access_token\"");
        int tokenIndex = response.indexOf(34, index + 14) + 1;
        int lastTokenIndex = response.indexOf(34, tokenIndex);
        if (index <= 0 || lastTokenIndex <= tokenIndex) {
            throw new IOException("Unable to extract access_token from response: " + response);
        }
        return response.substring(tokenIndex, lastTokenIndex);
    }
}

