/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.x509;

import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.httpconnection.x509.MinimalDERParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class TokenRequestX509 {
    private static final char[] KEYSTORE_PASSWORD = "".toCharArray();
    private final String pk;
    private final String certificate;

    public TokenRequestX509(String privateKey, String certificate) {
        this.pk = privateKey;
        this.certificate = certificate;
    }

    public SSLContext getSslContext() throws GeneralSecurityException, IOException {
        PrivateKey privateKey = this.getPrivateKeyFromString(this.pk);
        List<X509Certificate> x509s = this.getCertificatesFromString(this.certificate);
        KeyStore keyStore = this.createKeyStore(privateKey, x509s);
        return this.createSSLContext(keyStore, KEYSTORE_PASSWORD);
    }

    private SSLContext createSSLContext(KeyStore keyStore, char[] keyStorePassword) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        return SSLContextBuilder.create().loadKeyMaterial(keyStore, keyStorePassword).loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
    }

    public KeyStore createKeyStore(PrivateKey privateKey, List<X509Certificate> x509s) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", privateKey, null, x509s.toArray(new X509Certificate[0]));
        return keyStore;
    }

    public List<X509Certificate> getCertificatesFromString(String certificates) throws CertificateException, IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(certificates.getBytes());){
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            List<X509Certificate> list = factory.generateCertificates(inputStream).stream().map(X509Certificate.class::cast).collect(Collectors.toList());
            return list;
        }
    }

    private PrivateKey getPrivateKeyFromString(String rsaPrivateKey) throws GeneralSecurityException {
        String privateKeyPEM = rsaPrivateKey;
        privateKeyPEM = privateKeyPEM.replace("-----BEGIN RSA PRIVATE KEY-----", "");
        privateKeyPEM = privateKeyPEM.replace("-----END RSA PRIVATE KEY-----", "");
        privateKeyPEM = privateKeyPEM.replace("\n", "");
        privateKeyPEM = privateKeyPEM.replace("\\n", "");
        KeySpec keySpec = this.parseDERPrivateKey(Base64.getDecoder().decode(privateKeyPEM));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private KeySpec parseDERPrivateKey(byte[] privateKeyDerEncoded) throws GeneralSecurityException {
        RSAPrivateCrtKeySpec keySpec;
        MinimalDERParser parser = new MinimalDERParser(privateKeyDerEncoded);
        try {
            parser.getSequence();
            BigInteger version = parser.getBigInteger();
            if (!version.equals(BigInteger.ZERO)) {
                throw new IllegalArgumentException("Only version 0 supported for PKCS1 decoding.");
            }
            BigInteger modulus = parser.getBigInteger();
            BigInteger publicExponent = parser.getBigInteger();
            BigInteger privateExponent = parser.getBigInteger();
            BigInteger primeP = parser.getBigInteger();
            BigInteger primeQ = parser.getBigInteger();
            BigInteger primeExponentP = parser.getBigInteger();
            BigInteger primeExponentQ = parser.getBigInteger();
            BigInteger crtCoefficient = parser.getBigInteger();
            keySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Exception during parsing DER encoded private key", e);
        }
        return keySpec;
    }
}

