/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.uribuilder;

import com.sap.cloud.servicesdk.xbem.core.MessagingService;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.MessagingServiceJmsSettings;
import com.sap.cloud.servicesdk.xbem.extension.sapcp.jms.uribuilder.UrlBuilder;

public class ConnectionSettingsTool {
    private static final String CLOUD_EVENT_MAPPING_URL_PARAMETER = "amqpAppPropContentTypeMapping";

    private ConnectionSettingsTool() {
    }

    public static String buildConnectionUri(String url, MessagingServiceJmsSettings settings, MessagingService clientInfo) {
        String cloudEventContentType;
        UrlBuilder innerUrlBuilder = new UrlBuilder((String)url);
        if (clientInfo != null && (cloudEventContentType = clientInfo.getAmqpContentTypeMappingProperty()) != null) {
            innerUrlBuilder.addParameter(CLOUD_EVENT_MAPPING_URL_PARAMETER, cloudEventContentType);
        }
        if (settings != null) {
            innerUrlBuilder.addParameter("amqp.idleTimeout", String.valueOf(settings.getAmqpIdleTimeout()));
            innerUrlBuilder.addParameter("amqp.traceFrames", String.valueOf(settings.isAmqpTraceFrame()));
            url = innerUrlBuilder.getUrl();
            url = "failover:(" + (String)url + ")";
            UrlBuilder failoverUrlBuilder = new UrlBuilder((String)url);
            failoverUrlBuilder.addParameter("failover.maxReconnectAttempts", String.valueOf(settings.getFailoverMaxReconnectAttempts()));
            failoverUrlBuilder.addParameter("failover.initialReconnectDelay", String.valueOf(settings.getFailoverInitialReconnectDelay()));
            failoverUrlBuilder.addParameter("failover.reconnectDelay", String.valueOf(settings.getFailoverReconnectDelay()));
            failoverUrlBuilder.addParameter("failover.useReconnectBackOff", String.valueOf(false));
            failoverUrlBuilder.addParameter("jms.requestTimeout", String.valueOf(settings.getJmsRequestTimeout()));
            return failoverUrlBuilder.getUrl();
        }
        return innerUrlBuilder.getUrl();
    }
}

