package com.sap.xs.env;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Credentials {

	@JsonProperty("user")
	private String user;
	@JsonProperty("username")
	private String username;

	@JsonProperty("password")
	private String password;

	@JsonProperty("url")
	private String url;
	@JsonProperty("uri")
	private String uri;

	@JsonProperty("driver")
	private String driver;

	@JsonProperty("host")
	private String host;
	@JsonProperty("hostname")
	private String hostname;

	@JsonProperty("port")
	private String port;

	@JsonProperty("db")
	private String db;
	@JsonProperty("dbname")
	private String dbname;

	private Map<String, Object> any = new HashMap<>();

	public Credentials() {
		// for Jackson
	}

	public Credentials(Map<String, Object> credentialsMap) {
		this.setDriver((String) credentialsMap.get("driver"));
		this.setUrl((String) credentialsMap.get("url"));
		this.setHost((String) credentialsMap.get("host"));
		this.setPort((String) credentialsMap.get("port"));
		this.setUser((String) credentialsMap.get("user"));
		this.setPassword((String) credentialsMap.get("password"));
		this.any().putAll(credentialsMap);
	}

	/**
	 * @return user
	 */
	public String getUser() {
		return user == null ? username : user;
	}

	/**
	 * @param user
	 *            user to set
	 */
	public void setUser(String user) {
		this.user = user;
	}

	/**
	 * @return password
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param password
	 *            password to set
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return url
	 */
	public String getUrl() {
		return url == null ? uri : url;
	}

	/**
	 * @param url
	 *            url to set
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * @return driver
	 */
	public String getDriver() {
		return driver;
	}

	/**
	 * @param driver
	 *            to set
	 */
	public void setDriver(String driver) {
		this.driver = driver;
	}

	/**
	 * @return host
	 */
	public String getHost() {
		return host == null ? hostname : host;
	}

	/**
	 * @param host
	 *            host to set
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return port
	 */
	public String getPort() {
		return port;
	}

	/**
	 * @param port
	 *            port to set
	 */
	public void setPort(String port) {
		this.port = port;
	}

	/**
	 * @return database name
	 */
	public String getDbname() {
		return db == null ? dbname : db;
	}

	/**
	 * @param dbname
	 *            database name to set
	 */
	public void setDbname(String dbname) {
		this.dbname = dbname;
		this.db = null;
	}

	/**
	 * @param uri
	 *            uri to set
	 * @throws IOException
	 *             In case the uri cannot be set
	 */
	public void setUri(String uri) throws IOException {
		this.uri = uri;
	}

	/**
	 * @return uri
	 */
	public String getUri() {
		return uri;
	}

	/**
	 * @return map of properties that are not predefined
	 */
	@JsonAnyGetter
	public Map<String, Object> any() {
		return any;
	}

	/**
	 * @param requiredAttributes
	 *            required attributes
	 * @return if {@link #any()} contains requiredAttributes
	 */
	@SuppressWarnings("unchecked")
	public boolean hasRequiredAttributes(List<String> ... requiredAttributes) {
		boolean hasrequired = true;
		for (List<String> requiredAttribute : requiredAttributes) {
			hasrequired &= hasAtLeastOneAttribute(requiredAttribute);
		}
		return hasrequired;
	}

	/**
	 * @param name
	 *            name of property to set
	 * @param value
	 *            value of property to set
	 */
	@JsonAnySetter
	public void set(String name, Object value) {
		any.put(name, value);
	}

	/**
	 * @param name
	 *            name of {@link Credentials} property
	 * @return value of the property
	 */
	public Object get(String name) {
		switch (name) {
		case "user":
			return getUser();
		case "password":
			return getPassword();
		case "url":
			return getUrl();
		case "uri":
			return getUri();
		case "driver":
			return getDriver();
		case "host":
			return getHost();
		case "port":
			return getPort();
		case "dbname":
			return getDbname();
		default:
			return any.get(name);
		}
	}

	private boolean hasAtLeastOneAttribute(List<String> requiredAttributes) {
		for (String requiredAttribute : requiredAttributes) {
			if (any().containsKey(requiredAttribute)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{");
		sb.append("\"user\":\"").append(getUser()).append("\"");
		sb.append(", \"password\":\"***\"");
		sb.append(", \"url\":\"").append(getUrl()).append("\"");
		sb.append(", \"driver\":\"").append(getDriver()).append("\"");
		sb.append(", \"host\":\"").append(getHost()).append("\"");
		sb.append(", \"port\":\"").append(getPort()).append("\"");

		String dataBaseName = getDbname();
		if (dataBaseName != null) {
			sb.append(", \"dbname\":\"").append(dataBaseName).append("\"");
		}

		sb.append("}");

		return sb.toString();
	}
}
