package com.sap.xs.env;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Limits {
	@JsonProperty(value = "disk")
	private int disk;

	@JsonProperty(value = "fds")
	private int fds;

	@JsonProperty(value = "mem")
	private int mem;

	private Map<String, Object> any = new HashMap<>();

	/**
	 * @return disk limit
	 */
	public int getDisk() {
		return disk;
	}

	/**
	 * @return file descriptors limit
	 */
	public int getFds() {
		return fds;
	}

	/**
	 * @return memory limit
	 */
	public int getMem() {
		return mem;
	}

	/**
	 * @return map of properties that are not predefined
	 */
	@JsonAnyGetter
	public Map<String, Object> any() {
		return any;
	}

	/**
	 * @param name
	 *            name of property to set
	 * @param value
	 *            value of property to set
	 */
	@JsonAnySetter
	public void set(String name, Object value) {
		any.put(name, value);
	}

	@Override
	public String toString() {
		return "{\"disk\": " + disk + ", \"fds\": " + fds + ", \"mem\": " + mem + "}";
	}
}
