package com.sap.xs.env;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Service implements Cloneable {

	@JsonProperty("name")
	private String name;
	@JsonProperty("label")
	private String label;
	@JsonProperty("tags")
	private List<String> tags = new ArrayList<>();
	@JsonProperty("plan")
	private String plan;
	@JsonProperty("credentials")
	private Credentials credentials;

	private final Map<String, Object> any = new HashMap<>();

	/**
	 * @return map of properties that are not predefined
	 */
	@JsonAnyGetter
	public Map<String, Object> any() {
		return any;
	}

	/**
	 * @param name
	 *            name of property to set
	 * @param value
	 *            value of property to set
	 */
	@JsonAnySetter
	public void set(String name, Object value) {
		any.put(name, value);
	}

	/**
	 * @return tags
	 */
	public List<String> getTags() {
		return tags;
	}

	/**
	 * @param tags
	 *            tags to set
	 */
	public void setTags(List<String> tags) {
		this.tags = tags;
	}

	/**
	 * @return name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return service instance name
	 */
	public String getServiceInstanceName() {
		return any.containsKey("instance_name") ? (String) get("instance_name") : getName();
	}

	/**
	 * @param name
	 *            name of {@link Service} property
	 * @return value of the property
	 */
	public Object get(String name) {
		switch (name) {
		case "tags":
			return getTags();
		case "name":
			return getName();
		case "label":
			return getLabel();
		case "plan":
			return getPlan();
		case "credentials":
			return getCredentials();
		default:
			return any.get(name);
		}
	}

	/**
	 * @return label
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * @param label
	 *            label to set
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * @return plan
	 */
	public String getPlan() {
		return plan;
	}

	/**
	 * @param plan
	 *            plan to set
	 */
	public void setPlan(String plan) {
		this.plan = plan;
	}

	/**
	 * @return credentials
	 */
	public Credentials getCredentials() {
		return credentials;
	}

	/**
	 * @param credentials
	 *            credentials to set
	 */
	public void setCredentials(Credentials credentials) {
		this.credentials = credentials;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{");
		sb.append("\"name\":\"").append(getName()).append("\"");
		sb.append(", \"label\":\"").append(getLabel()).append("\"");
		sb.append(", \"tags\":").append(StringUtil.listAsJson(getTags()));
		sb.append(", \"plan\":\"").append(getPlan()).append("\"");
		sb.append("}");

		return sb.toString();
	}

	/**
	 * @return copy of a {@link Service}
	 * @throws RuntimeException
	 *     If the object's class does not support the Cloneable interface.
	 */
	@Override
	public Service clone() {
		try {
			return (Service) super.clone();
		} catch (CloneNotSupportedException e) {
			throw new RuntimeException(e);
		}
	}
}
