package com.sap.xs.env;

import java.util.List;
import java.util.regex.Pattern;

class StringUtil {

	private static final Pattern PASSWORD_PATTERN = Pattern
			.compile("((?<!\\\\)\".*?password.*?(?<!\\\\)\"\\s*:\\s*\").*?((?<!\\\\)\"|$)");
	private static final String PASSWORD_REPLACEMENT = "$1***$2";

	private StringUtil() {}

	/**
	 * @param input
	 *            string to be secured
	 * @return The replaced and secured string
	 */
	public static String hidePasswords(String input) {
		return PASSWORD_PATTERN.matcher(input).replaceAll(PASSWORD_REPLACEMENT);
	}

	/**
	 * @param list
	 *            string to be converted to JSON
	 * @return string in JSON format
	 */
	public static String listAsJson(List<String> list) {
		if (list == null) {
			return "null";
		}

		if (list.isEmpty()) {
			return "[]";
		}

		StringBuilder sb = new StringBuilder();
		sb.append("[\"").append(list.get(0)).append("\"");
		for (String item : list.subList(1, list.size())) {
			sb.append(", \"").append(item).append("\"");
		}
		sb.append("]");
		return sb.toString();
	}
}
