/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.env;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Credentials {
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="uri")
    private String uri;
    @JsonProperty(value="driver")
    private String driver;
    @JsonProperty(value="host")
    private String host;
    @JsonProperty(value="hostname")
    private String hostname;
    @JsonProperty(value="port")
    private String port;
    @JsonProperty(value="db")
    private String db;
    @JsonProperty(value="dbname")
    private String dbname;
    private Map<String, Object> any = new HashMap<String, Object>();

    public Credentials() {
    }

    public Credentials(Map<String, Object> credentialsMap) {
        this.setDriver((String)credentialsMap.get("driver"));
        this.setUrl((String)credentialsMap.get("url"));
        this.setHost((String)credentialsMap.get("host"));
        this.setPort((String)credentialsMap.get("port"));
        this.setUser((String)credentialsMap.get("user"));
        this.setPassword((String)credentialsMap.get("password"));
        this.any().putAll(credentialsMap);
    }

    public String getUser() {
        return this.user == null ? this.username : this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url == null ? this.uri : this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getHost() {
        return this.host == null ? this.hostname : this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbname() {
        return this.db == null ? this.dbname : this.db;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
        this.db = null;
    }

    public void setUri(String uri) throws IOException {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.any;
    }

    public boolean hasRequiredAttributes(List<String> ... requiredAttributes) {
        boolean hasrequired = true;
        for (List<String> requiredAttribute : requiredAttributes) {
            hasrequired &= this.hasAtLeastOneAttribute(requiredAttribute);
        }
        return hasrequired;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.any.put(name, value);
    }

    public Object get(String name) {
        switch (name) {
            case "user": {
                return this.getUser();
            }
            case "password": {
                return this.getPassword();
            }
            case "url": {
                return this.getUrl();
            }
            case "uri": {
                return this.getUri();
            }
            case "driver": {
                return this.getDriver();
            }
            case "host": {
                return this.getHost();
            }
            case "port": {
                return this.getPort();
            }
            case "dbname": {
                return this.getDbname();
            }
        }
        return this.any.get(name);
    }

    private boolean hasAtLeastOneAttribute(List<String> requiredAttributes) {
        for (String requiredAttribute : requiredAttributes) {
            if (!this.any().containsKey(requiredAttribute)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"user\":\"").append(this.getUser()).append("\"");
        sb.append(", \"password\":\"***\"");
        sb.append(", \"url\":\"").append(this.getUrl()).append("\"");
        sb.append(", \"driver\":\"").append(this.getDriver()).append("\"");
        sb.append(", \"host\":\"").append(this.getHost()).append("\"");
        sb.append(", \"port\":\"").append(this.getPort()).append("\"");
        String dataBaseName = this.getDbname();
        if (dataBaseName != null) {
            sb.append(", \"dbname\":\"").append(dataBaseName).append("\"");
        }
        sb.append("}");
        return sb.toString();
    }
}

