/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.env;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.xs.env.Credentials;
import com.sap.xs.env.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Service
implements Cloneable {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="tags")
    private List<String> tags = new ArrayList<String>();
    @JsonProperty(value="plan")
    private String plan;
    @JsonProperty(value="credentials")
    private Credentials credentials;
    private final Map<String, Object> any = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.any;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.any.put(name, value);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServiceInstanceName() {
        return this.any.containsKey("instance_name") ? (String)this.get("instance_name") : this.getName();
    }

    public Object get(String name) {
        switch (name) {
            case "tags": {
                return this.getTags();
            }
            case "name": {
                return this.getName();
            }
            case "label": {
                return this.getLabel();
            }
            case "plan": {
                return this.getPlan();
            }
            case "credentials": {
                return this.getCredentials();
            }
        }
        return this.any.get(name);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPlan() {
        return this.plan;
    }

    public void setPlan(String plan) {
        this.plan = plan;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"name\":\"").append(this.getName()).append("\"");
        sb.append(", \"label\":\"").append(this.getLabel()).append("\"");
        sb.append(", \"tags\":").append(StringUtil.listAsJson(this.getTags()));
        sb.append(", \"plan\":\"").append(this.getPlan()).append("\"");
        sb.append("}");
        return sb.toString();
    }

    public Service clone() {
        try {
            return (Service)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

