/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.env;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.sap.xs.env.Limits;
import com.sap.xs.env.StringUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VcapApplication {
    public static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    private static final Logger LOGGER = Logger.getLogger(VcapApplication.class.getName());
    private static final ObjectReader READER = new ObjectMapper().readerFor(VcapApplication.class);
    @JsonProperty(value="application_id")
    private String applicationId;
    @JsonProperty(value="application_name")
    private String applicationName;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="application_uris")
    private List<String> applicationUris;
    @JsonProperty(value="uris")
    private List<String> uris;
    @JsonProperty(value="application_version")
    private String applicationVersion;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="host")
    private String host;
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonProperty(value="instance_index")
    private String instanceIndex;
    @JsonProperty(value="limits")
    private Limits limits;
    @JsonProperty(value="port")
    private String port;
    @JsonProperty(value="space_id")
    private String spaceId;
    @JsonProperty(value="space_name")
    private String spaceName;
    @JsonProperty(value="start")
    private String start;
    @JsonProperty(value="started_at")
    private String startedAt;
    @JsonProperty(value="started_at_timestamp")
    private String startedAtTimestamp;
    @JsonProperty(value="state_timestamp")
    private String stateTimestamp;
    @JsonProperty(value="users")
    private List<String> users;
    @JsonProperty(value="organization_name")
    private String organizationName;
    private Map<String, Object> any = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.any;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.any.put(name, value);
    }

    public static VcapApplication fromEnvironment() {
        return VcapApplication.from(System.getenv(VCAP_APPLICATION));
    }

    public static VcapApplication fromSystemProperty() {
        return VcapApplication.from(System.getProperty(VCAP_APPLICATION));
    }

    public static VcapApplication from(String application) {
        if (application == null || application.trim().isEmpty()) {
            return new VcapApplication();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Parsing VCAP_APPLICATION: " + application);
        }
        try {
            VcapApplication vcapApplication = (VcapApplication)READER.readValue(application);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Parsed VCAP_APPLICATION: " + vcapApplication.toString());
            }
            return vcapApplication;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "", e);
            throw new IllegalArgumentException("Cannot parse VCAP_APPLICATION.");
        }
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationName() {
        return this.applicationName == null ? this.name : this.applicationName;
    }

    public List<String> getApplicationUris() {
        return this.applicationUris == null ? this.uris : this.applicationUris;
    }

    public String getApplicationVersion() {
        return this.applicationVersion == null ? this.version : this.applicationVersion;
    }

    public String getHost() {
        return this.host;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceIndex() {
        return this.instanceIndex;
    }

    public Limits getLimits() {
        return this.limits;
    }

    public String getPort() {
        return this.port;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public String getStart() {
        return this.start == null ? this.startedAt : this.start;
    }

    public String getStartedAtTimestamp() {
        return this.startedAtTimestamp == null ? this.stateTimestamp : this.startedAtTimestamp;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public Object get(String name) {
        switch (name) {
            case "application_id": {
                return this.getApplicationId();
            }
            case "application_name": 
            case "name": {
                return this.getApplicationName();
            }
            case "application_uris": 
            case "uris": {
                return this.getApplicationUris();
            }
            case "application_version": 
            case "version": {
                return this.getApplicationVersion();
            }
            case "host": {
                return this.getHost();
            }
            case "instance_id": {
                return this.getInstanceId();
            }
            case "instance_index": {
                return this.getInstanceIndex();
            }
            case "limits": {
                return this.getLimits();
            }
            case "port": {
                return this.getPort();
            }
            case "space_id": {
                return this.getSpaceId();
            }
            case "space_name": {
                return this.getSpaceName();
            }
            case "start": 
            case "started_at": {
                return this.getStart();
            }
            case "started_at_timestamp": 
            case "state_timestamp": {
                return this.getStartedAtTimestamp();
            }
            case "users": {
                return this.getUsers();
            }
            case "organization_name": {
                return this.getOrganizationName();
            }
        }
        return this.any.get(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"application_id\": \"").append(this.getApplicationId()).append("\"");
        sb.append(", \"application_name\": \"").append(this.getApplicationName()).append("\"");
        sb.append(", \"application_uris\": ").append(StringUtil.listAsJson(this.getApplicationUris()));
        sb.append(", \"application_version\": \"").append(this.getApplicationVersion()).append("\"");
        sb.append(", \"host\": \"").append(this.getHost()).append("\"");
        sb.append(", \"instance_id\": \"").append(this.getInstanceId()).append("\"");
        sb.append(", \"instance_index\": ").append(this.getInstanceIndex());
        if (this.getLimits() != null) {
            sb.append(", \"limits\": ").append(this.getLimits());
        }
        sb.append(", \"port\": \"").append(this.getPort()).append("\"");
        sb.append(", \"space_id\": \"").append(this.getSpaceId()).append("\"");
        sb.append(", \"space_name\": \"").append(this.getSpaceName()).append("\"");
        sb.append(", \"start\": \"").append(this.getStart()).append("\"");
        sb.append(", \"started_at_timestamp\": \"").append(this.getStartedAtTimestamp()).append("\"");
        sb.append(", \"users\": ").append(StringUtil.listAsJson(this.getUsers()));
        sb.append(", \"organization_name\": \"").append(this.getOrganizationName()).append("\"");
        sb.append("}");
        return sb.toString();
    }
}

