package com.sap.xs.security;

import java.util.Map;

import com.sap.xsa.security.container.XSTokenRequest;

public interface UserData {
	//same methods as XSUserInfo + overloaded requestToken(..) substituting the one having deprecated XSTokenRequest argument 
	String getLogonName() throws UserDataException;
	
	String getGivenName() throws UserDataException;
	
	String getFamilyName() throws UserDataException;
	
	String getOrigin() throws UserDataException;
	
	String getIdentityZone() throws UserDataException;
	
	String getSubaccountId() throws UserDataException;
	
	String getZoneId() throws UserDataException;
	
	String getSubdomain() throws UserDataException;
	
	String getClientId() throws UserDataException;
	
	String getJsonValue(String attribute) throws UserDataException;
	
	String getEmail() throws UserDataException;
	
	String getDBToken() throws UserDataException;
	
	String getHdbToken() throws UserDataException;
	
	String getAppToken();
	
	String getToken(String namespace, String name) throws UserDataException;

	String[] getAttribute(String attributeName) throws UserDataException;
	
	boolean hasAttributes() throws UserDataException;
	
	String[] getSystemAttribute(String attributeName) throws UserDataException;
	
	boolean checkScope(String scope) throws UserDataException;
	
	boolean checkLocalScope(String scope) throws UserDataException;
	
	String getAdditionalAuthAttribute(String attributeName) throws UserDataException;
	
	String getCloneServiceInstanceId() throws UserDataException;
	
	String getGrantType() throws UserDataException;
	
	boolean isInForeignMode() throws UserDataException;
	
	String requestTokenForClient(String clientId, String clientSecret, String baseUaaUrl) throws UserDataException;
	
	String requestTokenForUser(String clientId, String clientSecret, String baseUaaUrl) throws UserDataException;
	
	String requestToken(XSTokenRequest tokenRequest) throws UserDataException;
	
	String requestToken(String clientId, String clientSecret, String baseUaaUrl, int requestType, Map<String, String> additionalAuthAttributes) throws UserDataException;
}
