package com.sap.xs.security;

import java.lang.reflect.InvocationTargetException;

import com.sap.xsa.security.container.XSTokenRequest;
import com.sap.xsa.security.container.XSUserInfo;
import com.sap.xsa.security.container.XSUserInfoException;

@SuppressWarnings("deprecation")
public class UserInfoDelegate implements XSUserInfo {

	private Object userInfo;

	private String logonName;
	private String email;
	private String dbToken;
	private String subaccountId;
	private String identityZone;

	public UserInfoDelegate(Object userInfo) {
		if (!userInfo.getClass().getName().equals("com.sap.xs2.security.container.UserInfo")) {
			throw new IllegalArgumentException(
					"Parameter 'userInfo' is of unsupported type: " + userInfo.getClass().getName());
		}

		this.userInfo = userInfo;
	}

	@Override
	public String getLogonName() {
		if (logonName == null) {
			try {
				logonName = (String) userInfo.getClass().getMethod("getLogonName").invoke(userInfo);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException
					| NoSuchMethodException | SecurityException e) {
				throw new XSUserInfoException("Could not call method 'getLogonName'.", e);
			}
		}

		return logonName;
	}

	@Override
	public String getJsonValue(String attribute) {
		try {
			return (String) userInfo.getClass().getMethod("getJsonValue", String.class).invoke(userInfo, attribute);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getJsonValue'.", e);
		}
	}

	@Override
	public String getEmail() {
		if (email == null) {
			try {
				email = (String) userInfo.getClass().getMethod("getEmail").invoke(userInfo);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException
					| NoSuchMethodException | SecurityException e) {
				throw new XSUserInfoException("Could not call method 'getEmail'.", e);
			}
		}

		return logonName;
	}

	@Override
	public String getDBToken() {
		if (dbToken == null) {
			try {
				dbToken = (String) userInfo.getClass().getMethod("getDBToken").invoke(userInfo);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException
					| NoSuchMethodException | SecurityException e) {
				throw new XSUserInfoException("Could not call method 'getDBToken'.", e);
			}
		}

		return dbToken;
	}

	@Override
	public String getToken(String namespace, String name) {
		try {
			return (String) userInfo.getClass().getMethod("getToken", String.class, String.class).invoke(userInfo,
					namespace, name);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getToken'.", e);
		}
	}

	@Override
	public String[] getAttribute(String attributeName) {
		try {
			return (String[]) userInfo.getClass().getMethod("getAttribute", String.class).invoke(userInfo,
					attributeName);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getAttribute'.", e);
		}
	}

	@Override
	public String[] getSystemAttribute(String attributeName) {
		try {
			return (String[]) userInfo.getClass().getMethod("getSystemAttribute", String.class).invoke(userInfo,
					attributeName);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getSystemAttribute'.", e);
		}
	}

	@Override
	public boolean checkScope(String scope) {
		try {
			return (boolean) userInfo.getClass().getMethod("checkScope", String.class).invoke(userInfo, scope);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'checkScope'.", e);
		}
	}

	@Override
	public boolean checkLocalScope(String scope) {
		try {
			return (boolean) userInfo.getClass().getMethod("checkLocalScope", String.class).invoke(userInfo, scope);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'checkLocalScope'.", e);
		}
	}

	@Override
	public String getAdditionalAuthAttribute(String attributeName) {
		try {
			return (String) userInfo.getClass().getMethod("getAdditionalAuthAttribute", String.class).invoke(userInfo,
					attributeName);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getAdditionalAuthAttribute'.", e);
		}
	}

	@Override
	public String getCloneServiceInstanceId() {
		try {
			return (String) userInfo.getClass().getMethod("getCloneServiceInstanceId").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getCloneServiceInstanceId'.", e);
		}
	}

	@Override
	public String getFamilyName() {
		try {
			return (String) userInfo.getClass().getMethod("getFamilyName").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getFamilyName'.", e);
		}
	}

	@Override
	public String getGivenName() {
		try {
			return (String) userInfo.getClass().getMethod("getGivenName").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getGivenName'.", e);
		}
	}

	@Override
	public String getGrantType() {
		try {
			return (String) userInfo.getClass().getMethod("getGrantType").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getGrantType'.", e);
		}
	}

	@Override
	public String getHdbToken() {
		try {
			return (String) userInfo.getClass().getMethod("getHdbToken").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getHdbToken'.", e);
		}
	}

	@Override
	public boolean hasAttributes() {
		try {
			return (boolean) userInfo.getClass().getMethod("hasAttributes").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'hasAttributes'.", e);
		}
	}

	@Override
	public boolean isInForeignMode() {
		try {
			return (boolean) userInfo.getClass().getMethod("isInForeignMode").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'isInForeignMode'.", e);
		}
	}

	@Override
	public String requestTokenForClient(String clientId, String clientSecret, String uaaUrl) {
		try {
			return (String) userInfo.getClass()
					.getMethod("requestTokenForClient", String.class, String.class, String.class)
					.invoke(userInfo, clientId, clientSecret, uaaUrl);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'requestTokenForClient'.", e);
		}
	}

	@Override
	public String requestTokenForUser(String clientId, String clientSecret, String uaaUrl) {
		try {
			return (String) userInfo.getClass()
					.getMethod("requestTokenForUser", String.class, String.class, String.class)
					.invoke(userInfo, clientId, clientSecret, uaaUrl);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'requestTokenForUser'.", e);
		}
	}

	@Override
	public String getSubdomain() {
		try {
			return (String) userInfo.getClass().getMethod("getSubdomain").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getSubdomain'.", e);
		}
	}

	@Override
	public String requestToken(XSTokenRequest tokenRequest) {
		try {
			return (String) userInfo.getClass().getMethod("requestToken").invoke(userInfo, tokenRequest);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'requestToken'.", e);
		}
	}

	@Override
	public String getClientId() {
		try {
			return (String) userInfo.getClass().getMethod("getClientId").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getClientId'.", e);
		}
	}

	@Override
	public String getAppToken() {
		try {
			return (String) userInfo.getClass().getMethod("getAppToken").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new IllegalStateException("Could not call method 'getAppToken'.", e);
		}
	}

	@Override
	public String getOrigin() {
		try {
			return (String) userInfo.getClass().getMethod("getOrigin").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getOrigin'.", e);
		}
	}

	@Override
	public String getSubaccountId() {
		if (subaccountId == null) {
			try {
				subaccountId = (String) userInfo.getClass().getMethod("getSubaccountId").invoke(userInfo);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException
					| NoSuchMethodException | SecurityException e) {
				throw new XSUserInfoException("Could not call method 'getSubaccountId'.", e);
			}
		}

		return subaccountId;
	}

	@Override
	public String getZoneId() {
		try {
			return (String) userInfo.getClass().getMethod("getZoneId").invoke(userInfo);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException
				| SecurityException e) {
			throw new XSUserInfoException("Could not call method 'getZoneId'.", e);
		}
	}

	@Override
	public String getIdentityZone() {
		if (identityZone == null) {
			try {
				identityZone = (String) userInfo.getClass().getMethod("getIdentityZone").invoke(userInfo);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException
					| NoSuchMethodException | SecurityException e) {
				throw new XSUserInfoException("Could not call method 'getIdentityZone'.", e);
			}
		}

		return identityZone;
	}
}
