package com.sap.xs.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import com.sap.xsa.security.container.XSUserInfo;

public final class UserInfoHolder {

	private static ThreadLocal<XSUserInfo> userInfo = new InheritableThreadLocal<>();
	private static ThreadLocal<UserData> userData = new InheritableThreadLocal<>();
	private static Method getUserInfoMethod;

	private UserInfoHolder() {
	}

	/**
	 * @param getUserInfoMethod getUserInfo method to set on {@link UserInfoHolder}
	 */
	public static void setGetUserInfoMethod(Method getUserInfoMethod) {
		UserInfoHolder.getUserInfoMethod = getUserInfoMethod;
	}

	/**
	 * @param userInfo user information for {@link UserInfoHolder}
	 */
	public static void setUserInfo(XSUserInfo userInfo) {
		UserInfoHolder.userInfo.set(userInfo);
	}
	
	public static void setUserData(UserData userData) {
		UserInfoHolder.userData.set(userData);
	}

	/**
	 * @return xs user information
	 */
	public static XSUserInfo getUserInfo() {
		XSUserInfo userInfo = UserInfoHolder.userInfo.get();

		if (userInfo == null && getUserInfoMethod != null) {
			try {
				// Use the delegate for spring security if available
				Object userInfoObject = getUserInfoMethod.invoke(null);
				userInfo = new UserInfoDelegate(userInfoObject);
				setUserInfo(userInfo);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
				throw new IllegalStateException("User information is not set.", e);
			}
		}

		if (userInfo == null) {
			throw new IllegalStateException("User information is not set.");
		}

		return userInfo;
	}
	
	public static UserData getUserData() {
		UserData userData = UserInfoHolder.userData.get();
		if (userData == null) {
			throw new IllegalStateException("User information is not set.");
		}

		return userData;
	}
	
}
