/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.spring.boot.mt.config;

import com.sap.cloud.spring.boot.mt.lib.Const;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name = Const.COM_SAP_MT_ENABLED, matchIfMissing = true)
@Configuration("ComSapMtApplicationContextAccess")
public class ApplicationContextAccess implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContextAccess.class);

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextAccess.applicationContext = applicationContext;
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return applicationContext.getBean(clazz);
        } catch (NoUniqueBeanDefinitionException e) {
            logger.error("No unique bean defined for class {}", clazz.toString());
            throw e;
        } catch (NoSuchBeanDefinitionException e) {
            logger.debug("No bean defined for class {}", clazz.toString());
            return null;
        } catch (BeansException e) {
            logger.error("Could not create bean for class {}", clazz.toString());
            throw e;
        }
    }
}

