/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.spring.boot.mt.config;

import com.sap.cloud.mt.subscription.HanaEncryptionTool.DbEncryptionMode;
import com.sap.cloud.mt.subscription.PollingParameters;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.spring.boot.mt.lib.Const;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.time.Duration;

/**
 * Configuration bean that setups a tenant provider, a data source lookup and a routing data source bean
 */
@Configuration("ComSapMtConfig")
@ConfigurationProperties("com.sap.mt")
@ConditionalOnProperty(name = Const.COM_SAP_MT_ENABLED, matchIfMissing = true)
public class Config {
    private String poolProvider;
    private String mtxUrl;
    private String baseUiUrl;
    private String urlSeparator;
    private boolean securityCheckOff = false;
    private String subscribeScope = "callback";
    private String initDbScope = "initdb";
    private long healthCheckIntervalMillis = 10000;
    private boolean oneDataSourcePerDb = false;
    private boolean tomcatJmx = false;
    private int maxRetries = 0;
    private Duration retryWaitTime = Duration.ofSeconds(10);
    private ProvisioningService provisioningService = new ProvisioningService();
    private boolean liquibaseLifecycleManagement;
    private PollingParameters mtxPolling;
    private Duration serviceManagerCacheRefreshInterval = Duration.ofMinutes(2);
    private DbEncryptionMode hanaEncryptionMode;
    private ModelProviderService modelProviderService = new ModelProviderService();
    private ResilienceConfig serviceManagerResilience;

    public String getPoolProvider() {
        return poolProvider;
    }

    public void setPoolProvider(String poolProvider) {
        this.poolProvider = poolProvider;
    }

    public String getMtxUrl() {
        return mtxUrl;
    }

    public void setMtxUrl(String mtxUrl) {
        this.mtxUrl = mtxUrl;
    }

    public String getBaseUiUrl() {
        return baseUiUrl;
    }

    public void setBaseUiUrl(String baseUiUrl) {
        this.baseUiUrl = baseUiUrl;
    }

    public String getUrlSeparator() {
        return urlSeparator;
    }

    public void setUrlSeparator(String urlSeparator) {
        this.urlSeparator = urlSeparator;
    }

    public boolean isSecurityCheckOff() {
        return securityCheckOff;
    }

    public void setSecurityCheckOff(boolean securityCheckOff) {
        this.securityCheckOff = securityCheckOff;
    }

    public String getSubscribeScope() {
        return subscribeScope;
    }

    public void setSubscribeScope(String subscribeScope) {
        this.subscribeScope = subscribeScope;
    }

    public String getInitDbScope() {
        return initDbScope;
    }

    public void setInitDbScope(String initDbScope) {
        this.initDbScope = initDbScope;
    }

    public long getHealthCheckIntervalMillis() {
        return healthCheckIntervalMillis;
    }

    public void setHealthCheckIntervalMillis(long healthCheckIntervalMillis) {
        this.healthCheckIntervalMillis = healthCheckIntervalMillis;
    }

    public boolean isOneDataSourcePerDb() {
        return oneDataSourcePerDb;
    }

    public void setOneDataSourcePerDb(boolean oneDataSourcePerDb) {
        this.oneDataSourcePerDb = oneDataSourcePerDb;
    }

    public void setTomcatJmx(boolean tomcatJmx) {
        this.tomcatJmx = tomcatJmx;
    }

    public boolean isTomcatJmx() {
        return tomcatJmx;
    }

    public int getMaxRetries() {
        return maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Duration getRetryWaitTime() {
        return retryWaitTime;
    }

    public void setRetryWaitTime(Duration retryWaitTime) {
        this.retryWaitTime = retryWaitTime;
    }

    public boolean isLiquibaseLifecycleManagement() {
        return liquibaseLifecycleManagement;
    }

    public void setLiquibaseLifecycleManagement(boolean liquibaseLifecycleManagement) {
        this.liquibaseLifecycleManagement = liquibaseLifecycleManagement;
    }

    public ProvisioningService getProvisioningService() {
        return provisioningService;
    }

    public void setProvisioningService(ProvisioningService provisioningService) {
        this.provisioningService = provisioningService;
    }

    public PollingParameters getMtxPolling() {
        return mtxPolling;
    }

    public void setMtxPolling(PollingParameters mtxPolling) {
        this.mtxPolling = mtxPolling;
    }

    public Duration getServiceManagerCacheRefreshInterval() {
        return serviceManagerCacheRefreshInterval;
    }

    public void setServiceManagerCacheRefreshInterval(Duration serviceManagerCacheRefreshInterval) {
        this.serviceManagerCacheRefreshInterval = serviceManagerCacheRefreshInterval;
    }

    public DbEncryptionMode getHanaEncryptionMode() {
        return hanaEncryptionMode;
    }

    public void setHanaEncryptionMode(DbEncryptionMode hanaEncryptionMode) {
        this.hanaEncryptionMode = hanaEncryptionMode;
    }

    public ModelProviderService getModelProviderService() {
        return modelProviderService;
    }

    public void setModelProviderService(ModelProviderService modelProviderService) {
        this.modelProviderService = modelProviderService;
    }

    public ResilienceConfig getServiceManagerResilience() {
        return serviceManagerResilience;
    }

    public void setServiceManagerResilience(ResilienceConfig serviceManagerResilience) {
        this.serviceManagerResilience = serviceManagerResilience;
    }

    public static class ProvisioningService {
        private String url;
        private ResilienceConfig resilienceConfig = ResilienceConfig.builder().build();
        private PollingParameters polling = PollingParameters.Builder.create().build();

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public ResilienceConfig getResilienceConfig() {
            return resilienceConfig;
        }

        public void setResilienceConfig(ResilienceConfig resilienceConfig) {
            this.resilienceConfig = resilienceConfig;
        }

        public PollingParameters getPolling() {
            return polling;
        }

        public void setPolling(PollingParameters polling) {
            this.polling = polling;
        }
    }

    public static class ModelProviderService {
        private String url;
        private ResilienceConfig resilienceConfig = ResilienceConfig.builder().build();
        private PollingParameters polling = PollingParameters.Builder.create().build();

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public ResilienceConfig getResilienceConfig() {
            return resilienceConfig;
        }

        public void setResilienceConfig(ResilienceConfig resilienceConfig) {
            this.resilienceConfig = resilienceConfig;
        }

        public PollingParameters getPolling() {
            return polling;
        }

        public void setPolling(PollingParameters polling) {
            this.polling = polling;
        }
    }
}
