/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.spring.boot.mt.config;

import com.sap.cloud.mt.runtime.DbHealthIndicatorImpl;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.spring.boot.mt.lib.Const;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;


@Configuration("dbHealthIndicator")
@ConfigurationProperties("com.sap.mt")
@ConditionalOnClass(HealthIndicator.class)
@ConditionalOnProperty(name = Const.COM_SAP_MT_ENABLED, matchIfMissing = true)
@ConditionalOnEnabledHealthIndicator("db")
public class DbHealthIndicator implements HealthIndicator {
    private String healthDummySelect;
    private final TenantAwareDataSource dataSource;
    private final Config config;
    private DbHealthIndicatorImpl<Health> dbHealthIndicator;

    public DbHealthIndicator(TenantAwareDataSource dataSource, Config config, DbIdentifiers dbIdentifiers) {
        this.dataSource = dataSource;
        this.config = config;
    }

    @Override
    public Health health() {
        if (dbHealthIndicator == null) {
            dbHealthIndicator = new DbHealthIndicatorImpl(healthDummySelect, dataSource,
                    config.getHealthCheckIntervalMillis(),
                    () -> Health.up().build(),
                    (text, details) -> Health.down().withDetail(text, details).build(),
                    (text, details) -> Health.up().withDetail(text, details).build());
        }
        return dbHealthIndicator.health();
    }

    public void setHealthDummySelect(String healthDummySelect) {
        this.healthDummySelect = healthDummySelect;
    }


}