/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.spring.boot.mt.config;

import com.sap.cloud.mt.runtime.IdentityZoneDeterminer;
import com.sap.cloud.security.adapter.spring.SpringSecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.spring.boot.mt.lib.Const;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

import java.util.function.Supplier;

@Configuration("comSapMtIdentityZoneDeterminer")
@ConditionalOnClass(SpringSecurityContext.class)
@ConditionalOnProperty(name = Const.COM_SAP_MT_ENABLED, matchIfMissing = true)
@ConditionalOnMissingBean(IdentityZoneDeterminer.class)
public class IdentityZoneDeterminerWithJavaSecurityImpl implements IdentityZoneDeterminer {
    private final Supplier<Token> tokenSupplier;

    public IdentityZoneDeterminerWithJavaSecurityImpl(@Qualifier("comSapMtToken") Supplier<Token> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    public String getIdentityZone() throws InternalError {
        try {
            return tokenSupplier.get().getZoneId();
        } catch(Exception e) { //NOSONAR
            return null;
        }
    }
}
